# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 1.24.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Assets(BaseModel):
    """
    Asset model for every asset (insight/visualization/feed/etc.) customer creates
    """ # noqa: E501
    date_created: Optional[datetime] = None
    last_updated: Optional[datetime] = None
    asset_id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = None
    company_id: StrictStr
    connection_id: Optional[StrictStr] = None
    llm_connection_id: Optional[StrictStr] = None
    snippet_id: Optional[StrictInt] = None
    industry_id: Optional[StrictInt] = None
    ai_job_id: Optional[StrictStr] = Field(default=None, description="Links to the AutoInsights job that created this asset")
    approval_status: Optional[StrictStr] = Field(default=None, description="Approval status for AI-generated assets")
    approved_by_user_id: Optional[StrictStr] = Field(default=None, description="User who approved this asset for marketplace")
    approved_at: Optional[datetime] = Field(default=None, description="When this asset was approved for marketplace")
    name: StrictStr
    slug: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    source: StrictStr = Field(description="Enum type: Source")
    asset_type: Optional[StrictStr] = Field(default=None, description="Enum type: AssetType")
    asset_schema: Optional[Dict[str, Any]] = Field(default=None, description="Stores database table schema data including columns, types, and metadata")
    visibility: Optional[StrictStr] = Field(default=None, description="Enum type: Visibility")
    tags: Optional[StrictStr] = None
    sql_logic: Optional[StrictStr] = None
    source_schema_name: Optional[StrictStr] = None
    source_table_name: Optional[StrictStr] = None
    sell_in_marketplace: StrictBool
    viz_chart_library: Optional[StrictStr] = Field(default=None, description="Enum type: PlottingLibrary")
    viz_chart_type: Optional[StrictStr] = Field(default=None, description="Enum type: ChartType")
    viz_dep_var_col_name: Optional[StrictStr] = None
    viz_indep_var_col_name: Optional[StrictStr] = None
    viz_size_col_name: Optional[StrictStr] = None
    viz_color_col_name: Optional[StrictStr] = None
    viz_data_aggregation: Optional[StrictStr] = Field(default=None, description="Enum type: AggregationType")
    viz_sort_direction: Optional[StrictStr] = Field(default=None, description="Enum type: SortDirection")
    viz_data_limit: Optional[StrictInt] = None
    viz_color_scheme: Optional[StrictStr] = Field(default=None, description="Enum type: ColorScheme")
    allow_params: StrictBool
    accept_terms: StrictBool
    cached: Optional[StrictBool] = None
    schedule: Optional[StrictStr] = None
    next_run: Optional[datetime] = None
    data_time_period_start: Optional[datetime] = Field(default=None, description="Start date of the data time period covered")
    data_time_period_end: Optional[datetime] = Field(default=None, description="End date of the data time period covered")
    geographic_coverage_type: Optional[StrictStr] = Field(default=None, description="Type of geographic coverage (Enum type: GeographicCoverage)")
    geographic_coverage_details: Optional[StrictStr] = Field(default=None, description="Specific regions/countries covered (e.g., 'United States, Canada, Mexico')")
    data_source_refresh_frequency: Optional[StrictStr] = Field(default=None, description="How often the source data is refreshed (Enum type: DataRefreshFrequency)")
    data_source_last_refreshed: Optional[datetime] = Field(default=None, description="When the source data was last refreshed")
    __properties: ClassVar[List[str]] = ["date_created", "last_updated", "asset_id", "user_id", "company_id", "connection_id", "llm_connection_id", "snippet_id", "industry_id", "ai_job_id", "approval_status", "approved_by_user_id", "approved_at", "name", "slug", "description", "source", "asset_type", "asset_schema", "visibility", "tags", "sql_logic", "source_schema_name", "source_table_name", "sell_in_marketplace", "viz_chart_library", "viz_chart_type", "viz_dep_var_col_name", "viz_indep_var_col_name", "viz_size_col_name", "viz_color_col_name", "viz_data_aggregation", "viz_sort_direction", "viz_data_limit", "viz_color_scheme", "allow_params", "accept_terms", "cached", "schedule", "next_run", "data_time_period_start", "data_time_period_end", "geographic_coverage_type", "geographic_coverage_details", "data_source_refresh_frequency", "data_source_last_refreshed"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MANUAL', 'AUTOMATIC']):
            raise ValueError("must be one of enum values ('MANUAL', 'AUTOMATIC')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CALCULATION', 'VISUALIZATION', 'DATA']):
            raise ValueError("must be one of enum values ('CALCULATION', 'VISUALIZATION', 'DATA')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PRIVATE', 'SHARED']):
            raise ValueError("must be one of enum values ('PRIVATE', 'SHARED')")
        return value

    @field_validator('viz_chart_library')
    def viz_chart_library_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PLOTLY', 'MATPLOTLIB', 'SEABORN']):
            raise ValueError("must be one of enum values ('PLOTLY', 'MATPLOTLIB', 'SEABORN')")
        return value

    @field_validator('viz_chart_type')
    def viz_chart_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LINE', 'BAR', 'HORIZONTALBAR', 'PIE', 'DOUGHNUT', 'POLAR', 'RADAR', 'BUBBLE', 'SCATTER', 'NA']):
            raise ValueError("must be one of enum values ('LINE', 'BAR', 'HORIZONTALBAR', 'PIE', 'DOUGHNUT', 'POLAR', 'RADAR', 'BUBBLE', 'SCATTER', 'NA')")
        return value

    @field_validator('viz_data_aggregation')
    def viz_data_aggregation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['No Aggregation', 'Sum', 'Average', 'Count', 'Minimum', 'Maximum']):
            raise ValueError("must be one of enum values ('No Aggregation', 'Sum', 'Average', 'Count', 'Minimum', 'Maximum')")
        return value

    @field_validator('viz_sort_direction')
    def viz_sort_direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['No Sorting', 'Ascending', 'Descending']):
            raise ValueError("must be one of enum values ('No Sorting', 'Ascending', 'Descending')")
        return value

    @field_validator('viz_color_scheme')
    def viz_color_scheme_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Default', 'Sequential', 'Diverging', 'Categorical', 'Monochrome', 'Pastel', 'Dark', 'Light']):
            raise ValueError("must be one of enum values ('Default', 'Sequential', 'Diverging', 'Categorical', 'Monochrome', 'Pastel', 'Dark', 'Light')")
        return value

    @field_validator('geographic_coverage_type')
    def geographic_coverage_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['GLOBAL', 'CONTINENTAL', 'REGIONAL', 'NATIONAL', 'STATE', 'LOCAL', 'CUSTOM', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('GLOBAL', 'CONTINENTAL', 'REGIONAL', 'NATIONAL', 'STATE', 'LOCAL', 'CUSTOM', 'UNKNOWN')")
        return value

    @field_validator('data_source_refresh_frequency')
    def data_source_refresh_frequency_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REAL_TIME', 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', 'QUARTERLY', 'ANNUAL', 'ONE_TIME', 'CUSTOM', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('REAL_TIME', 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', 'QUARTERLY', 'ANNUAL', 'ONE_TIME', 'CUSTOM', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Assets from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Assets from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_created": obj.get("date_created"),
            "last_updated": obj.get("last_updated"),
            "asset_id": obj.get("asset_id"),
            "user_id": obj.get("user_id"),
            "company_id": obj.get("company_id"),
            "connection_id": obj.get("connection_id"),
            "llm_connection_id": obj.get("llm_connection_id"),
            "snippet_id": obj.get("snippet_id"),
            "industry_id": obj.get("industry_id"),
            "ai_job_id": obj.get("ai_job_id"),
            "approval_status": obj.get("approval_status"),
            "approved_by_user_id": obj.get("approved_by_user_id"),
            "approved_at": obj.get("approved_at"),
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "description": obj.get("description"),
            "source": obj.get("source"),
            "asset_type": obj.get("asset_type"),
            "asset_schema": obj.get("asset_schema"),
            "visibility": obj.get("visibility"),
            "tags": obj.get("tags"),
            "sql_logic": obj.get("sql_logic"),
            "source_schema_name": obj.get("source_schema_name"),
            "source_table_name": obj.get("source_table_name"),
            "sell_in_marketplace": obj.get("sell_in_marketplace"),
            "viz_chart_library": obj.get("viz_chart_library"),
            "viz_chart_type": obj.get("viz_chart_type"),
            "viz_dep_var_col_name": obj.get("viz_dep_var_col_name"),
            "viz_indep_var_col_name": obj.get("viz_indep_var_col_name"),
            "viz_size_col_name": obj.get("viz_size_col_name"),
            "viz_color_col_name": obj.get("viz_color_col_name"),
            "viz_data_aggregation": obj.get("viz_data_aggregation"),
            "viz_sort_direction": obj.get("viz_sort_direction"),
            "viz_data_limit": obj.get("viz_data_limit"),
            "viz_color_scheme": obj.get("viz_color_scheme"),
            "allow_params": obj.get("allow_params"),
            "accept_terms": obj.get("accept_terms"),
            "cached": obj.get("cached"),
            "schedule": obj.get("schedule"),
            "next_run": obj.get("next_run"),
            "data_time_period_start": obj.get("data_time_period_start"),
            "data_time_period_end": obj.get("data_time_period_end"),
            "geographic_coverage_type": obj.get("geographic_coverage_type"),
            "geographic_coverage_details": obj.get("geographic_coverage_details"),
            "data_source_refresh_frequency": obj.get("data_source_refresh_frequency"),
            "data_source_last_refreshed": obj.get("data_source_last_refreshed")
        })
        return _obj


