# coding: utf-8

"""
    Spartera API Documentation

    Auto-generated API documentation for REST services of the Spartera platform

    The version of the OpenAPI document: 1.24.0
    Contact: support@spartera.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ConnectionsInput(BaseModel):
    """
    Input schema for creating Connection
    """ # noqa: E501
    user_id: Optional[StrictStr] = None
    engine_id: StrictInt
    company_id: StrictStr
    credential_type: Optional[StrictStr] = Field(default=None, description="Enum type: CredentialType")
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    provider_domain: Optional[StrictStr] = None
    verified_usage_ability: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["user_id", "engine_id", "company_id", "credential_type", "name", "description", "provider_domain", "verified_usage_ability"]

    @field_validator('credential_type')
    def credential_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SERVICE_ACCOUNT', 'USERNAME_PASSWORD', 'API_KEY', 'SERVICE_IDENTITY', 'ACCESS_KEY', 'NONE', 'OAUTH', 'JSON']):
            raise ValueError("must be one of enum values ('SERVICE_ACCOUNT', 'USERNAME_PASSWORD', 'API_KEY', 'SERVICE_IDENTITY', 'ACCESS_KEY', 'NONE', 'OAUTH', 'JSON')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectionsInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectionsInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "engine_id": obj.get("engine_id"),
            "company_id": obj.get("company_id"),
            "credential_type": obj.get("credential_type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "provider_domain": obj.get("provider_domain"),
            "verified_usage_ability": obj.get("verified_usage_ability")
        })
        return _obj


