from setuptools import setup, find_packages
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, "README.md"), encoding="utf-8") as f:
    long_description = f.read()

# Get the release/version string
with open(path.join(here, "RELEASE"), encoding="utf-8") as f:
    release = f.read()

docs_req = ["sphinx", "sphinx_rtd_theme", "sphinx-autorun", "sphinxcontrib-jsmath", "sphinx_markdown_tables"]

dev_req = [
    "sympy",
    "pytest",
    "pytest-cov",
    "coverage",
    "codecov",
    "recommonmark",
    "flake8"
]

setup(
    name="spatialmath-python",
    version=release,
    # This is a one-line description or tagline of what your project does. This
    # corresponds to the "Summary" metadata field:
    description="Provides spatial maths capability for Python.",  # TODO
    long_description=long_description,
    long_description_content_type="text/markdown",
    classifiers=[
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        "Development Status :: 5 - Production/Stable",
        # Indicate who your project is intended for
        "Intended Audience :: Developers",
        # Pick your license as you wish (should match "license" above)
        "License :: OSI Approved :: MIT License",
        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
    python_requires=">=3.6",
    project_urls={
        "Documentation": "https://petercorke.github.io/spatialmath-python",
        "Source": "https://github.com/petercorke/spatialmath-python",
        "Tracker": "https://github.com/petercorke/spatialmath-python/issues",
        "Coverage": "https://codecov.io/gh/petercorke/spatialmath-python",
    },
    url="https://github.com/petercorke/spatialmath-python",
    author="Peter Corke",
    author_email="rvc@petercorke.com",  # TODO
    keywords=["spatial-math", "spatial math",
        "SO2", "SE2", "SO3", "SE3",
        "SO(2)", "SE(2)", "SO(3)", "SE(3)",
        "twist", "product of exponential", "translation", "orientation",
        "angle-axis", "Lie group", "skew symmetric matrix",
        "pose", "translation", "rotation matrix", "rigid body transform", "homogeneous transformation",
        "Euler angles", "roll-pitch-yaw angles", "quaternion", "unit-quaternion"
        "robotics", "robot vision"],
    license="MIT",  # TODO
    packages=find_packages(exclude=["test_*", "TODO*"]),
    install_requires=["numpy", "scipy", "matplotlib", "colored", "ansitable"],
    extras_require={
        "docs": docs_req,
        "dev": dev_req
    },
)
