from dataclasses import dataclass, field
from datetime import datetime
from marshmallow import fields
import dateutil.parser
from typing import Optional
from dataclasses_json import dataclass_json


@dataclass_json
@dataclass
class APIEndpoint:
    r"""APIEndpoint
    An ApiEndpoint is a description of an Endpoint for an API.
    """
    api_endpoint_id: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'api_endpoint_id' }})
    api_id: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'api_id' }})
    created_at: datetime = field(default=None, metadata={'dataclasses_json': { 'field_name': 'created_at', 'encoder': datetime.isoformat, 'decoder': dateutil.parser.isoparse, 'mm_field': fields.DateTime(format='iso') }})
    description: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'description' }})
    display_name: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'display_name' }})
    matched: Optional[bool] = field(default=None, metadata={'dataclasses_json': { 'field_name': 'matched' }})
    method: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'method' }})
    path: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'path' }})
    updated_at: datetime = field(default=None, metadata={'dataclasses_json': { 'field_name': 'updated_at', 'encoder': datetime.isoformat, 'decoder': dateutil.parser.isoparse, 'mm_field': fields.DateTime(format='iso') }})
    version_id: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'version_id' }})
    workspace_id: str = field(default=None, metadata={'dataclasses_json': { 'field_name': 'workspace_id' }})
    
