"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from .apiendpoints import APIEndpoints
from .apis import Apis
from .embeds import Embeds
from .metadata import Metadata
from .plugins import Plugins
from .requests import Requests
from .schemas import Schemas
from .sdkconfiguration import SDKConfiguration
from speakeasy import utils
from speakeasy.models import errors, operations, shared
from typing import Optional

class Speakeasy:
    r"""Speakeasy API: The Speakeasy API allows teams to manage common operations with their APIs
    https://speakeasyapi.dev/docs/ - The Speakeasy Platform Documentation
    """
    api_endpoints: APIEndpoints
    r"""REST APIs for managing ApiEndpoint entities"""
    apis: Apis
    r"""REST APIs for managing Api entities"""
    embeds: Embeds
    r"""REST APIs for managing embeds"""
    metadata: Metadata
    r"""REST APIs for managing Version Metadata entities"""
    plugins: Plugins
    r"""REST APIs for managing and running plugins"""
    requests: Requests
    r"""REST APIs for retrieving request information"""
    schemas: Schemas
    r"""REST APIs for managing Schema entities"""

    sdk_configuration: SDKConfiguration

    def __init__(self,
                 security: shared.Security = None,
                 server: str = None,
                 server_url: str = None,
                 url_params: dict[str, str] = None,
                 client: requests_http.Session = None,
                 retry_config: utils.RetryConfig = None
                 ) -> None:
        """Instantiates the SDK configuring it with the provided parameters.
        
        :param security: The security details required for authentication
        :type security: shared.Security
        :param server: The server by name to use for all operations
        :type server: str
        :param server_url: The server URL to use for all operations
        :type server_url: str
        :param url_params: Parameters to optionally template the server URL with
        :type url_params: dict[str, str]
        :param client: The requests.Session HTTP client to use for all operations
        :type client: requests_http.Session
        :param retry_config: The utils.RetryConfig to use globally
        :type retry_config: utils.RetryConfig
        """
        if client is None:
            client = requests_http.Session()
        
        security_client = utils.configure_security_client(client, security)
        
        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        self.sdk_configuration = SDKConfiguration(client, security_client, server_url, server, retry_config=retry_config)
       
        self._init_sdks()
    
    def _init_sdks(self):
        self.api_endpoints = APIEndpoints(self.sdk_configuration)
        self.apis = Apis(self.sdk_configuration)
        self.embeds = Embeds(self.sdk_configuration)
        self.metadata = Metadata(self.sdk_configuration)
        self.plugins = Plugins(self.sdk_configuration)
        self.requests = Requests(self.sdk_configuration)
        self.schemas = Schemas(self.sdk_configuration)
    
    def validate_api_key(self) -> operations.ValidateAPIKeyResponse:
        r"""Validate the current api key."""
        base_url = utils.template_url(*self.sdk_configuration.get_server_details())
        
        url = base_url + '/v1/auth/validate'
        headers = {}
        headers['Accept'] = 'application/json'
        headers['user-agent'] = self.sdk_configuration.user_agent
        
        client = self.sdk_configuration.security_client
        
        http_res = client.request('GET', url, headers=headers)
        content_type = http_res.headers.get('Content-Type')

        res = operations.ValidateAPIKeyResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            pass
        else:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[shared.Error])
                res.error = out
            else:
                raise errors.SDKError(f'unknown content-type received: {content_type}', http_res.status_code, http_res.text, http_res)

        return res

    