"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .interactiontype import InteractionType
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from speakeasy import utils
from typing import Optional

class GenerateBumpType(str, Enum):
    r"""Bump type of the lock file (calculated semver delta, or a custom change (manual release))"""
    MAJOR = 'major'
    MINOR = 'minor'
    PATCH = 'patch'
    CUSTOM = 'custom'
    NONE = 'none'

class OpenapiDiffBumpType(str, Enum):
    r"""Bump type of the lock file (calculated semver delta, or a custom change (manual release))"""
    MAJOR = 'major'
    MINOR = 'minor'
    PATCH = 'patch'
    NONE = 'none'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class CliEvent:
    created_at: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('created_at'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""Timestamp when the event was created in the database."""
    execution_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('execution_id') }})
    r"""Unique identifier for each execution of the CLI."""
    id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('id') }})
    r"""Unique identifier for each event."""
    interaction_type: InteractionType = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('interaction_type') }})
    r"""Type of interaction."""
    local_started_at: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('local_started_at'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""Timestamp when the event started, in local time."""
    speakeasy_api_key_name: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('speakeasy_api_key_name') }})
    r"""Identifier of the Speakeasy API key."""
    speakeasy_version: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('speakeasy_version') }})
    r"""Version of the Speakeasy CLI."""
    success: bool = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('success') }})
    r"""Indicates whether the event was successful."""
    workspace_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('workspace_id') }})
    r"""Identifier of the workspace."""
    commit_head: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('commit_head'), 'exclude': lambda f: f is None }})
    r"""Remote commit ID."""
    continuous_integration_environment: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('continuous_integration_environment'), 'exclude': lambda f: f is None }})
    r"""Name of the CI environment."""
    duration_ms: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('duration_ms'), 'exclude': lambda f: f is None }})
    r"""Duration of the event in milliseconds."""
    error: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('error'), 'exclude': lambda f: f is None }})
    r"""Error message if the event was not successful."""
    generate_bump_type: Optional[GenerateBumpType] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_bump_type'), 'exclude': lambda f: f is None }})
    r"""Bump type of the lock file (calculated semver delta, or a custom change (manual release))"""
    generate_config_post_checksum: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_post_checksum'), 'exclude': lambda f: f is None }})
    r"""Checksum of the configuration file (post generation)"""
    generate_config_post_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_post_raw'), 'exclude': lambda f: f is None }})
    r"""Rendered configuration file (post generation)"""
    generate_config_post_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_post_version'), 'exclude': lambda f: f is None }})
    r"""The version of the customer's SDK that we just generated"""
    generate_config_pre_checksum: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_pre_checksum'), 'exclude': lambda f: f is None }})
    r"""Checksum of the configuration file (prior to generation)"""
    generate_config_pre_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_pre_raw'), 'exclude': lambda f: f is None }})
    r"""Rendered configuration file (prior to generation)"""
    generate_config_pre_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_config_pre_version'), 'exclude': lambda f: f is None }})
    r"""The version of the customer's SDK before we generated"""
    generate_eligible_features: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_eligible_features'), 'exclude': lambda f: f is None }})
    r"""Eligible feature set during generation"""
    generate_gen_lock_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_id'), 'exclude': lambda f: f is None }})
    r"""gen.lock ID (expected to be a uuid)."""
    generate_gen_lock_post_features: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_post_features'), 'exclude': lambda f: f is None }})
    r"""Features post generation"""
    generate_gen_lock_pre_blob_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_blob_digest'), 'exclude': lambda f: f is None }})
    r"""Blob digest of the Previous Generation"""
    generate_gen_lock_pre_doc_checksum: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_doc_checksum'), 'exclude': lambda f: f is None }})
    r"""Checksum of the Previous Rendered OpenAPI document (prior to generation, via gen lock)"""
    generate_gen_lock_pre_doc_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_doc_version'), 'exclude': lambda f: f is None }})
    r"""info.Version of the Previous Rendered OpenAPI document (prior to generation, via gen lock)"""
    generate_gen_lock_pre_features: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_features'), 'exclude': lambda f: f is None }})
    r"""Features prior to generation"""
    generate_gen_lock_pre_namespace_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_namespace_name'), 'exclude': lambda f: f is None }})
    r"""Namespace name of the Previous Generation"""
    generate_gen_lock_pre_revision_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_revision_digest'), 'exclude': lambda f: f is None }})
    r"""Revision digest of the Previous Generation"""
    generate_gen_lock_pre_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_gen_lock_pre_version'), 'exclude': lambda f: f is None }})
    r"""Artifact version for the Previous Generation"""
    generate_number_of_operations_ignored: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_number_of_operations_ignored'), 'exclude': lambda f: f is None }})
    r"""The number of operations ignored in generation."""
    generate_number_of_operations_used: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_number_of_operations_used'), 'exclude': lambda f: f is None }})
    r"""The number of operations used in generation."""
    generate_output_tests: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_output_tests'), 'exclude': lambda f: f is None }})
    r"""Indicates whether tests were output."""
    generate_published: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_published'), 'exclude': lambda f: f is None }})
    r"""Indicates whether the target was considered published."""
    generate_repo_url: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_repo_url'), 'exclude': lambda f: f is None }})
    r"""Expected Repo URL, for use in documentation generation."""
    generate_target: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_target'), 'exclude': lambda f: f is None }})
    r"""The target of the event."""
    generate_target_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_target_version'), 'exclude': lambda f: f is None }})
    r"""The version of the target."""
    generate_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('generate_version'), 'exclude': lambda f: f is None }})
    r"""Version of the generation logic used."""
    gh_action_organization: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('gh_action_organization'), 'exclude': lambda f: f is None }})
    r"""GitHub organization of the action."""
    gh_action_ref: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('gh_action_ref'), 'exclude': lambda f: f is None }})
    r"""GitHub Action ref value."""
    gh_action_repository: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('gh_action_repository'), 'exclude': lambda f: f is None }})
    r"""GitHub repository of the action."""
    gh_action_run_link: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('gh_action_run_link'), 'exclude': lambda f: f is None }})
    r"""Link to the GitHub action run."""
    gh_action_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('gh_action_version'), 'exclude': lambda f: f is None }})
    r"""Version of the GitHub action."""
    git_relative_cwd: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('git_relative_cwd'), 'exclude': lambda f: f is None }})
    r"""Current working directory relative to the git root."""
    git_remote_default_owner: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('git_remote_default_owner'), 'exclude': lambda f: f is None }})
    r"""Default owner for git remote."""
    git_remote_default_repo: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('git_remote_default_repo'), 'exclude': lambda f: f is None }})
    r"""Default repository name for git remote."""
    git_user_email: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('git_user_email'), 'exclude': lambda f: f is None }})
    r"""User email from git configuration."""
    git_user_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('git_user_name'), 'exclude': lambda f: f is None }})
    r"""User's name from git configuration. (not GitHub username)"""
    hostname: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('hostname'), 'exclude': lambda f: f is None }})
    r"""Remote hostname."""
    last_step: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('last_step'), 'exclude': lambda f: f is None }})
    r"""The last step of the event."""
    lint_report_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('lint_report_digest'), 'exclude': lambda f: f is None }})
    r"""The checksum of the lint report."""
    lint_report_error_count: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('lint_report_error_count'), 'exclude': lambda f: f is None }})
    r"""The number of errors in the lint report."""
    lint_report_info_count: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('lint_report_info_count'), 'exclude': lambda f: f is None }})
    r"""The number of info messages in the lint report."""
    lint_report_warning_count: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('lint_report_warning_count'), 'exclude': lambda f: f is None }})
    r"""The number of warnings in the lint report."""
    local_completed_at: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('local_completed_at'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""Timestamp when the event completed, in local time."""
    management_doc_checksum: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('management_doc_checksum'), 'exclude': lambda f: f is None }})
    r"""Checksum of the currently Rendered OpenAPI document."""
    management_doc_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('management_doc_version'), 'exclude': lambda f: f is None }})
    r"""Version taken from info.version field of the Rendered OpenAPI document."""
    mermaid_diagram: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('mermaid_diagram'), 'exclude': lambda f: f is None }})
    r"""Mermaid diagram"""
    openapi_diff_base_source_blob_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_base_source_blob_digest'), 'exclude': lambda f: f is None }})
    r"""The blob digest of the base source."""
    openapi_diff_base_source_namespace_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_base_source_namespace_name'), 'exclude': lambda f: f is None }})
    r"""The namespace name of the base source."""
    openapi_diff_base_source_revision_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_base_source_revision_digest'), 'exclude': lambda f: f is None }})
    r"""The revision digest of the base source."""
    openapi_diff_breaking_changes_count: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_breaking_changes_count'), 'exclude': lambda f: f is None }})
    r"""The number of breaking changes in the openapi diff report."""
    openapi_diff_bump_type: Optional[OpenapiDiffBumpType] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_bump_type'), 'exclude': lambda f: f is None }})
    r"""Bump type of the lock file (calculated semver delta, or a custom change (manual release))"""
    openapi_diff_report_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('openapi_diff_report_digest'), 'exclude': lambda f: f is None }})
    r"""The checksum of the openapi diff report."""
    publish_package_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('publish_package_name'), 'exclude': lambda f: f is None }})
    r"""Name of the published package."""
    publish_package_registry_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('publish_package_registry_name'), 'exclude': lambda f: f is None }})
    r"""Name of the registry where the package was published."""
    publish_package_url: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('publish_package_url'), 'exclude': lambda f: f is None }})
    r"""URL of the published package."""
    publish_package_version: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('publish_package_version'), 'exclude': lambda f: f is None }})
    r"""Version of the published package."""
    raw_command: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('raw_command'), 'exclude': lambda f: f is None }})
    r"""Full CLI command."""
    repo_label: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('repo_label'), 'exclude': lambda f: f is None }})
    r"""Label of the git repository."""
    source_blob_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('source_blob_digest'), 'exclude': lambda f: f is None }})
    r"""The blob digest of the source."""
    source_namespace_name: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('source_namespace_name'), 'exclude': lambda f: f is None }})
    r"""The namespace name of the source."""
    source_revision_digest: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('source_revision_digest'), 'exclude': lambda f: f is None }})
    r"""The revision digest of the source."""
    workflow_lock_post_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('workflow_lock_post_raw'), 'exclude': lambda f: f is None }})
    r"""Workflow lock file (post execution)"""
    workflow_lock_pre_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('workflow_lock_pre_raw'), 'exclude': lambda f: f is None }})
    r"""Workflow lock file (prior to execution)"""
    workflow_post_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('workflow_post_raw'), 'exclude': lambda f: f is None }})
    r"""Workflow file (post execution)"""
    workflow_pre_raw: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('workflow_pre_raw'), 'exclude': lambda f: f is None }})
    r"""Workflow file (prior to execution)"""
    

