"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from speakeasy_client_sdk_python.models.shared import clievent as shared_clievent, interactiontype as shared_interactiontype
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class SearchWorkspaceEventsGlobalsTypedDict(TypedDict):
    workspace_id: NotRequired[str]
    

class SearchWorkspaceEventsGlobals(BaseModel):
    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))] = None
    

class SearchWorkspaceEventsRequestTypedDict(TypedDict):
    generate_gen_lock_id: NotRequired[str]
    r"""A specific gen lock ID for the events."""
    interaction_type: NotRequired[shared_interactiontype.InteractionType]
    r"""Specified interaction type for events."""
    lint_report_digest: NotRequired[str]
    r"""Unique identifier of the lint report digest."""
    openapi_diff_report_digest: NotRequired[str]
    r"""Unique identifier of the openapi diff report digest."""
    source_revision_digest: NotRequired[str]
    r"""Unique identifier of the source revision digest."""
    workspace_id: NotRequired[str]
    r"""Unique identifier of the workspace."""
    

class SearchWorkspaceEventsRequest(BaseModel):
    generate_gen_lock_id: Annotated[Optional[str], FieldMetadata(query=QueryParamMetadata(style="form", explode=True))] = None
    r"""A specific gen lock ID for the events."""
    interaction_type: Annotated[Optional[shared_interactiontype.InteractionType], FieldMetadata(query=QueryParamMetadata(style="form", explode=True))] = None
    r"""Specified interaction type for events."""
    lint_report_digest: Annotated[Optional[str], FieldMetadata(query=QueryParamMetadata(style="form", explode=True))] = None
    r"""Unique identifier of the lint report digest."""
    openapi_diff_report_digest: Annotated[Optional[str], FieldMetadata(query=QueryParamMetadata(style="form", explode=True))] = None
    r"""Unique identifier of the openapi diff report digest."""
    source_revision_digest: Annotated[Optional[str], FieldMetadata(query=QueryParamMetadata(style="form", explode=True))] = None
    r"""Unique identifier of the source revision digest."""
    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))] = None
    r"""Unique identifier of the workspace."""
    

class SearchWorkspaceEventsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    cli_event_batch: NotRequired[List[shared_clievent.CliEventTypedDict]]
    r"""Success"""
    

class SearchWorkspaceEventsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    cli_event_batch: Optional[List[shared_clievent.CliEvent]] = None
    r"""Success"""
    
