"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
from .featureflag import FeatureFlag, FeatureFlagTypedDict
from datetime import datetime
from enum import Enum
from speakeasy_client_sdk_python.types import BaseModel
from typing import List, Optional, TypedDict
from typing_extensions import NotRequired


class ClaimsTypedDict(TypedDict):
    pass
    

class Claims(BaseModel):
    pass
    

class AccessTokenUserTypedDict(TypedDict):
    admin: NotRequired[bool]
    created_at: NotRequired[datetime]
    display_name: NotRequired[str]
    email: NotRequired[str]
    email_verified: NotRequired[bool]
    id: NotRequired[str]
    

class AccessTokenUser(BaseModel):
    admin: Optional[bool] = None
    created_at: Optional[datetime] = None
    display_name: Optional[str] = None
    email: Optional[str] = None
    email_verified: Optional[bool] = None
    id: Optional[str] = None
    

class AccessTokenAccountType(str, Enum):
    FREE = "free"
    SCALE_UP = "scale-up"
    ENTERPRISE = "enterprise"


class WorkspacesTypedDict(TypedDict):
    account_type: NotRequired[AccessTokenAccountType]
    id: NotRequired[str]
    name: NotRequired[str]
    updated_at: NotRequired[datetime]
    

class Workspaces(BaseModel):
    account_type: Optional[AccessTokenAccountType] = None
    id: Optional[str] = None
    name: Optional[str] = None
    updated_at: Optional[datetime] = None
    

class AccessTokenTypedDict(TypedDict):
    r"""An AccessToken is a token that can be used to authenticate with the Speakeasy API."""
    
    access_token: str
    claims: ClaimsTypedDict
    user: AccessTokenUserTypedDict
    feature_flags: NotRequired[List[FeatureFlagTypedDict]]
    workspaces: NotRequired[List[WorkspacesTypedDict]]
    

class AccessToken(BaseModel):
    r"""An AccessToken is a token that can be used to authenticate with the Speakeasy API."""
    
    access_token: str
    claims: Claims
    user: AccessTokenUser
    feature_flags: Optional[List[FeatureFlag]] = None
    workspaces: Optional[List[Workspaces]] = None
    
