"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from speakeasy_client_sdk_python.types import BaseModel
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class AccountType(str, Enum):
    FREE = "free"
    SCALE_UP = "scale-up"
    ENTERPRISE = "enterprise"

class APIKeyDetailsTypedDict(TypedDict):
    account_type: AccountType
    enabled_features: List[str]
    org_slug: str
    telemetry_disabled: bool
    workspace_id: str
    workspace_slug: str
    feature_flags: NotRequired[List[str]]
    generation_access_unlimited: NotRequired[bool]
    

class APIKeyDetails(BaseModel):
    account_type: AccountType
    enabled_features: List[str]
    org_slug: str
    telemetry_disabled: bool
    workspace_id: str
    workspace_slug: str
    feature_flags: Annotated[Optional[List[str]], pydantic.Field(deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.")] = None
    generation_access_unlimited: Optional[bool] = None
    
