"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from enum import Enum
from speakeasy_client_sdk_python import utils
from speakeasy_client_sdk_python._hooks import HookContext
from speakeasy_client_sdk_python.models import errors, operations, shared
from speakeasy_client_sdk_python.types import BaseModel, OptionalNullable, UNSET
from typing import Any, Mapping, Optional, Union, cast


class GenerateCodeSamplePreviewAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    APPLICATION_X_YAML = "application/x-yaml"


class GetCodeSamplePreviewAsyncAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    APPLICATION_X_YAML = "application/x-yaml"


class CodeSamples(BaseSDK):
    r"""REST APIs for retrieving Code Samples"""

    def generate_code_sample_preview(
        self,
        *,
        request: Union[
            shared.CodeSampleSchemaInput, shared.CodeSampleSchemaInputTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[GenerateCodeSamplePreviewAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GenerateCodeSamplePreviewResponse:
        r"""Generate Code Sample previews from a file and configuration parameters.

        This endpoint generates Code Sample previews from a file and configuration parameters.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, shared.CodeSampleSchemaInput)
        request = cast(shared.CodeSampleSchemaInput, request)

        req = self._build_request(
            method="POST",
            path="/v1/code_sample/preview",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, application/x-yaml;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", shared.CodeSampleSchemaInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="generateCodeSamplePreview",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return operations.GenerateCodeSamplePreviewResponse(
                two_hundred_application_json_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "200", "application/x-yaml"):
            return operations.GenerateCodeSamplePreviewResponse(
                two_hundred_application_x_yaml_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            data = utils.unmarshal_json(http_res_text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def generate_code_sample_preview_async(
        self,
        *,
        request: Union[
            shared.CodeSampleSchemaInput, shared.CodeSampleSchemaInputTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[GenerateCodeSamplePreviewAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GenerateCodeSamplePreviewResponse:
        r"""Generate Code Sample previews from a file and configuration parameters.

        This endpoint generates Code Sample previews from a file and configuration parameters.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, shared.CodeSampleSchemaInput)
        request = cast(shared.CodeSampleSchemaInput, request)

        req = self._build_request_async(
            method="POST",
            path="/v1/code_sample/preview",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, application/x-yaml;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", shared.CodeSampleSchemaInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="generateCodeSamplePreview",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return operations.GenerateCodeSamplePreviewResponse(
                two_hundred_application_json_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "200", "application/x-yaml"):
            return operations.GenerateCodeSamplePreviewResponse(
                two_hundred_application_x_yaml_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            data = utils.unmarshal_json(http_res_text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def generate_code_sample_previewhronous(
        self,
        *,
        request: Union[
            shared.CodeSampleSchemaInput, shared.CodeSampleSchemaInputTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GenerateCodeSamplePreviewAsyncResponse:
        r"""Initiate asynchronous Code Sample preview generation from a file and configuration parameters, receiving an JobID response for polling.

        This endpoint generates Code Sample previews from a file and configuration parameters, receiving an JobID response for polling.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, shared.CodeSampleSchemaInput)
        request = cast(shared.CodeSampleSchemaInput, request)

        req = self._build_request(
            method="POST",
            path="/v1/code_sample/preview/async",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", shared.CodeSampleSchemaInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="generateCodeSamplePreviewAsync",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "202", "application/json"):
            return operations.GenerateCodeSamplePreviewAsyncResponse(
                object=utils.unmarshal_json(
                    http_res.text,
                    Optional[operations.GenerateCodeSamplePreviewAsyncResponseBody],
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            data = utils.unmarshal_json(http_res.text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def generate_code_sample_preview_asynchronous_async(
        self,
        *,
        request: Union[
            shared.CodeSampleSchemaInput, shared.CodeSampleSchemaInputTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GenerateCodeSamplePreviewAsyncResponse:
        r"""Initiate asynchronous Code Sample preview generation from a file and configuration parameters, receiving an async JobID response for polling.

        This endpoint generates Code Sample previews from a file and configuration parameters, receiving an async JobID response for polling.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, shared.CodeSampleSchemaInput)
        request = cast(shared.CodeSampleSchemaInput, request)

        req = self._build_request_async(
            method="POST",
            path="/v1/code_sample/preview/async",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", shared.CodeSampleSchemaInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="generateCodeSamplePreviewAsync",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "202", "application/json"):
            return operations.GenerateCodeSamplePreviewAsyncResponse(
                object=utils.unmarshal_json(
                    http_res.text,
                    Optional[operations.GenerateCodeSamplePreviewAsyncResponseBody],
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            data = utils.unmarshal_json(http_res.text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        request: Union[
            operations.GetCodeSamplesRequest, operations.GetCodeSamplesRequestTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GetCodeSamplesResponse:
        r"""Retrieve usage snippets from document stored in the registry

        Retrieve usage snippets from document stored in the registry. Supports filtering by language and operation ID.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.GetCodeSamplesRequest)
        request = cast(operations.GetCodeSamplesRequest, request)

        req = self._build_request(
            method="GET",
            path="/v1/code_sample",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="getCodeSamples",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "2XX", "application/json"):
            return operations.GetCodeSamplesResponse(
                usage_snippets=utils.unmarshal_json(
                    http_res.text, Optional[shared.UsageSnippets]
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "4XX", "application/json"):
            data = utils.unmarshal_json(http_res.text, errors.ErrorData)
            raise errors.Error(data=data)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        request: Union[
            operations.GetCodeSamplesRequest, operations.GetCodeSamplesRequestTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GetCodeSamplesResponse:
        r"""Retrieve usage snippets from document stored in the registry

        Retrieve usage snippets from document stored in the registry. Supports filtering by language and operation ID.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, operations.GetCodeSamplesRequest)
        request = cast(operations.GetCodeSamplesRequest, request)

        req = self._build_request_async(
            method="GET",
            path="/v1/code_sample",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="getCodeSamples",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "2XX", "application/json"):
            return operations.GetCodeSamplesResponse(
                usage_snippets=utils.unmarshal_json(
                    http_res.text, Optional[shared.UsageSnippets]
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "4XX", "application/json"):
            data = utils.unmarshal_json(http_res.text, errors.ErrorData)
            raise errors.Error(data=data)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get_code_sample_preview(
        self,
        *,
        request: Union[
            operations.GetCodeSamplePreviewAsyncRequest,
            operations.GetCodeSamplePreviewAsyncRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[GetCodeSamplePreviewAsyncAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GetCodeSamplePreviewAsyncResponse:
        r"""Poll for the result of an asynchronous Code Sample preview generation.

        Poll for the result of an asynchronous Code Sample preview generation.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, operations.GetCodeSamplePreviewAsyncRequest
            )
        request = cast(operations.GetCodeSamplePreviewAsyncRequest, request)

        req = self._build_request(
            method="GET",
            path="/v1/code_sample/preview/async/{jobID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, application/x-yaml;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="getCodeSamplePreviewAsync",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_application_json_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "200", "application/x-yaml"):
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_application_x_yaml_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "202", "application/json"):
            http_response_text = utils.stream_to_text(http_res)
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_and_two_application_json_object=utils.unmarshal_json(
                    http_response_text,
                    Optional[operations.GetCodeSamplePreviewAsyncResponseBody],
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            data = utils.unmarshal_json(http_res_text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_code_sample_preview_async_async(
        self,
        *,
        request: Union[
            operations.GetCodeSamplePreviewAsyncRequest,
            operations.GetCodeSamplePreviewAsyncRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[GetCodeSamplePreviewAsyncAcceptEnum] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> operations.GetCodeSamplePreviewAsyncResponse:
        r"""Poll for the result of an asynchronous Code Sample preview generation.

        Poll for the result of an asynchronous Code Sample preview generation.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, operations.GetCodeSamplePreviewAsyncRequest
            )
        request = cast(operations.GetCodeSamplePreviewAsyncRequest, request)

        req = self._build_request_async(
            method="GET",
            path="/v1/code_sample/preview/async/{jobID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, application/x-yaml;q=0",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="getCodeSamplePreviewAsync",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_application_json_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "200", "application/x-yaml"):
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_application_x_yaml_response_stream=http_res,
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, "202", "application/json"):
            http_response_text = await utils.stream_to_text_async(http_res)
            return operations.GetCodeSamplePreviewAsyncResponse(
                two_hundred_and_two_application_json_object=utils.unmarshal_json(
                    http_response_text,
                    Optional[operations.GetCodeSamplePreviewAsyncResponseBody],
                ),
                status_code=http_res.status_code,
                content_type=http_res.headers.get("Content-Type") or "",
                raw_response=http_res,
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            data = utils.unmarshal_json(http_res_text, errors.ErrorData)
            raise errors.Error(data=data)

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
