"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from speakeasy_client_sdk_python.models.shared import (
    githubgetactionresponse as shared_githubgetactionresponse,
)
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, QueryParamMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetGitHubActionRequestTypedDict(TypedDict):
    org: str
    repo: str
    target_name: NotRequired[str]
    r"""The targetName of the workflow target."""


class GetGitHubActionRequest(BaseModel):
    org: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]

    repo: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]

    target_name: Annotated[
        Optional[str],
        pydantic.Field(alias="targetName"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The targetName of the workflow target."""


class GetGitHubActionResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    github_get_action_response: NotRequired[
        shared_githubgetactionresponse.GithubGetActionResponseTypedDict
    ]
    r"""OK"""


class GetGitHubActionResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    github_get_action_response: Optional[
        shared_githubgetactionresponse.GithubGetActionResponse
    ] = None
    r"""OK"""
