"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import io
import pydantic
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, MultipartFormMetadata
from typing import IO, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class SchemaFileTypedDict(TypedDict):
    content: Union[bytes, IO[bytes], io.BufferedReader]
    file_name: str
    content_type: NotRequired[str]


class SchemaFile(BaseModel):
    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class CodeSampleSchemaInputTypedDict(TypedDict):
    languages: List[str]
    r"""A list of languages to generate code samples for"""
    schema_file: SchemaFileTypedDict
    r"""The OpenAPI file to be uploaded"""
    package_name: NotRequired[str]
    r"""The name of the package"""
    sdk_class_name: NotRequired[str]
    r"""The SDK class name"""


class CodeSampleSchemaInput(BaseModel):
    languages: Annotated[List[str], FieldMetadata(multipart=True)]
    r"""A list of languages to generate code samples for"""

    schema_file: Annotated[
        SchemaFile, FieldMetadata(multipart=MultipartFormMetadata(file=True))
    ]
    r"""The OpenAPI file to be uploaded"""

    package_name: Annotated[Optional[str], FieldMetadata(multipart=True)] = None
    r"""The name of the package"""

    sdk_class_name: Annotated[Optional[str], FieldMetadata(multipart=True)] = None
    r"""The SDK class name"""
