# SpecFact CLI

> **Stop vibe coding. Start shipping quality code with contracts.**  
> Brownfield-first CLI: Reverse engineer legacy Python → specs → enforced contracts

[![PyPI version](https://img.shields.io/pypi/v/specfact-cli.svg)](https://pypi.org/project/specfact-cli/)
[![Python versions](https://img.shields.io/pypi/pyversions/specfact-cli.svg)](https://pypi.org/project/specfact-cli/)
[![License](https://img.shields.io/badge/license-Apache%202.0-blue.svg)](LICENSE.md)
[![Status](https://img.shields.io/badge/status-beta-orange.svg)](https://github.com/nold-ai/specfact-cli)

<div align="center">

**[🌐 Learn More at noldai.com](https://noldai.com)** • **[📚 Documentation](https://nold-ai.github.io/specfact-cli)** • **[💬 Support](mailto:hello@noldai.com)**

</div>

---

## 🚀 Quick Start in 60 Seconds

### Install in 10 seconds

```bash
# Zero-install (recommended)
uvx --from specfact-cli specfact

# Or install with pip
pip install specfact-cli
```

### Your first command (< 60 seconds)

```bash
# Modernizing legacy code? (Recommended)
specfact import from-code legacy-api --repo .

# Starting a new project?
specfact plan init legacy-api --interactive

# Using GitHub Spec-Kit or other tools?
specfact import from-bridge --repo . --adapter speckit --write
```

That's it! 🎉

> **Need machine-readable artifacts?** Use `specfact --output-format json …` (or the per-command `--output-format` flag) to emit plan bundles and reports as JSON instead of YAML.

---

## What is SpecFact CLI?

A brownfield-first CLI that **reverse engineers your legacy code** into documented specs, then prevents regressions with runtime contract enforcement.

**Stop vibe coding. Start shipping quality code with contracts.** SpecFact automatically extracts specs from existing code, then enforces them as you modernize—preventing bugs before they reach production.

**Perfect for:** Teams modernizing legacy Python systems, data pipelines, DevOps scripts

**For teams that can't afford production bugs during migration.**

---

## Why SpecFact?

### **Love GitHub Spec-Kit? SpecFact Adds What's Missing**

**Use both together:** Keep using Spec-Kit for new features, add SpecFact for legacy code modernization.

| What You Need | Spec-Kit | SpecFact CLI |
|---------------|----------|--------------|
| **Work with existing code** | ⚠️ Designed for new features | ✅ **Reverse-engineer legacy code** |
| **Prevent regressions** | ⚠️ Documentation only | ✅ **Runtime contract enforcement** |
| **Find hidden bugs** | ⚠️ LLM suggestions (may miss) | ✅ **Symbolic execution** (CrossHair) |
| **Automated safety net** | ⚠️ Manual code review | ✅ **CI/CD gates** (GitHub Actions) |

**Perfect together:**

- ✅ **Spec-Kit** for new features → Fast spec generation with Copilot
- ✅ **SpecFact** for legacy code → Runtime enforcement prevents regressions
- ✅ **Bidirectional sync** → Keep both tools in sync automatically
- ✅ **GitHub Actions** → SpecFact integrates with your existing GitHub workflows

**Bottom line:** Spec-Kit is great for documenting new features. SpecFact is essential for modernizing legacy code safely. Use both together for the best of both worlds.

---

## 💡 Key Capabilities

- ✅ **Reverse engineer legacy code** → Extract specs automatically from existing code
- ✅ **Runtime contract enforcement** → Prevent regressions during modernization
- ✅ **Symbolic execution** → Discover hidden edge cases with CrossHair
- ✅ **API contract testing** → Validate OpenAPI/AsyncAPI specs with Specmatic integration
- ✅ **Works offline** → No cloud required, fully local
- ✅ **CLI integrations** → Works seamlessly with VS Code, Cursor, GitHub Actions, and any agentic workflow

---

## 🔌 CLI Integrations

SpecFact CLI works with your existing tools—no new platform to learn. See real bugs that were caught and fixed through different integrations:

- ✅ **VS Code** - Catch async bugs before you commit
- ✅ **Cursor** - Prevent regressions during AI-assisted refactoring
- ✅ **GitHub Actions** - Block bad code from merging
- ✅ **Pre-commit Hooks** - Validate code locally before pushing
- ✅ **AI Assistants** - Find edge cases AI might miss

👉 **[Integration Showcases](docs/examples/integration-showcases/)** - Real examples of bugs fixed via CLI integrations

**Core USP**: Pure CLI-first approach—works offline, no account required, zero vendor lock-in. Regularly showcases successful integrations that fix bugs not detected by other tools.

---

## See It In Action

We ran SpecFact CLI **on itself** to prove it works with legacy code:

- ⚡ Analyzed 32 legacy Python files → Discovered **32 features** and **81 stories** in **3 seconds**
- 🚫 Set enforcement to "balanced" → **Blocked 2 HIGH violations** (as configured)
- 📊 Compared manual vs auto-derived plans → Found **24 deviations** in **5 seconds**

**Total time**: < 10 seconds | **Total value**: Found real naming inconsistencies and undocumented features in legacy codebase

👉 **[Read the complete example](docs/examples/dogfooding-specfact-cli.md)** with actual commands and outputs

---

## Documentation

**New to SpecFact?** Start with the [Getting Started Guide](docs/getting-started/README.md)

**Want to see integrations?** Check out [Integration Showcases](docs/examples/integration-showcases/) - Real bugs fixed via VS Code, Cursor, GitHub Actions

**Tried Spec-Kit?** See [How SpecFact Compares to Spec-Kit](docs/guides/speckit-comparison.md) and [The Journey: From Spec-Kit to SpecFact](docs/guides/speckit-journey.md)

**Need help?** Browse the [Documentation Hub](docs/README.md)

---

## Optional Telemetry (Opt-In)

- Telemetry is **off by default** and only activates if you set `SPECFACT_TELEMETRY_OPT_IN=true` or create `~/.specfact/telemetry.opt-in`.
- When enabled, SpecFact records anonymized metrics (e.g., number of features detected, contract violations blocked) to help us publish aggregate stats such as “contracts prevented 70% of the bugs surfaced during modernization.”
- Data is stored locally in `~/.specfact/telemetry.log`, and you can route it to your own OpenTelemetry collector via `SPECFACT_TELEMETRY_ENDPOINT`.
- Learn more in [`docs/reference/telemetry.md`](docs/reference/telemetry.md).

---

## Project Documentation

### 📚 Online Documentation

**GitHub Pages**: Full documentation is available at `https://nold-ai.github.io/specfact-cli/`

The documentation includes:

- Getting Started guides
- Complete command reference
- IDE integration setup
- Use cases and examples
- Architecture overview
- Testing procedures

**Note**: The GitHub Pages workflow is configured and will automatically deploy when changes are pushed to the `main` branch. Enable GitHub Pages in your repository settings to activate the site.

### 📖 Local Documentation

All documentation is in the [`docs/`](docs/) directory:

- **[Documentation Index](docs/README.md)** - Complete documentation overview
- **[Getting Started](docs/getting-started/installation.md)** - Installation and setup
- **[Command Reference](docs/reference/commands.md)** - All available commands
- **[IDE Integration](docs/guides/ide-integration.md)** - Set up slash commands
- **[Use Cases](docs/guides/use-cases.md)** - Real-world scenarios

---

## Contributing

We welcome contributions! Please see [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines.

```bash
git clone https://github.com/nold-ai/specfact-cli.git
cd specfact-cli
pip install -e ".[dev]"
hatch run contract-test-full
```

---

## License

**Apache License 2.0** - Open source and enterprise-friendly

SpecFact CLI is licensed under the Apache License 2.0, which means:

- ✅ **Free to use** for any purpose (commercial or non-commercial)
- ✅ **Modify and distribute** as needed
- ✅ **Enterprise-friendly** with explicit patent grant
- ✅ **Build commercial products** on top of SpecFact CLI

**Full license**: [LICENSE.md](LICENSE.md)

**Note**: The Apache 2.0 license is ideal for enterprise brownfield modernization projects, as it provides legal clarity and patent protection that many enterprises require.

---

## Support

- 💬 **Questions?** [GitHub Discussions](https://github.com/nold-ai/specfact-cli/discussions)
- 🐛 **Found a bug?** [GitHub Issues](https://github.com/nold-ai/specfact-cli/issues)
- 📧 **Need help?** [hello@noldai.com](mailto:hello@noldai.com)
- 🌐 **Learn more:** [noldai.com](https://noldai.com)

---

<div align="center">

**Built with ❤️ by [NOLD AI](https://noldai.com)**

Copyright © 2025 Nold AI (Owner: Dominikus Nold)

**Trademarks**: NOLD AI (NOLDAI) is a registered trademark (wordmark) at the European Union Intellectual Property Office (EUIPO). All other trademarks mentioned in this project are the property of their respective owners. See [TRADEMARKS.md](TRADEMARKS.md) for more information.

</div>
