# From “APÉNDICE B: TABLA DE CARACTERES VÁLIDOS Y CÓDIGOS ASCII RESPECTIVOS”
# in SPEI Manual.
VALID_CHARACTERS = frozenset(
    (
        ' ',
        '!',
        '"',
        '#',
        '$',
        '%',
        '&',
        "'",
        '(',
        ')',
        '*',
        '+',
        ',',
        '-',
        '.',
        '/',
        '0',
        '1',
        '2',
        '3',
        '4',
        '5',
        '6',
        '7',
        '8',
        '9',
        ':',
        ';',
        '?',
        '@',
        'A',
        'B',
        'C',
        'D',
        'E',
        'F',
        'G',
        'H',
        'I',
        'J',
        'K',
        'L',
        'M',
        'N',
        'O',
        'P',
        'Q',
        'R',
        'S',
        'T',
        'U',
        'V',
        'W',
        'X',
        'Y',
        'Z',
        '\\',
        '_',
        'a',
        'b',
        'c',
        'd',
        'e',
        'f',
        'g',
        'h',
        'i',
        'j',
        'k',
        'l',
        'm',
        'n',
        'o',
        'p',
        'q',
        'r',
        's',
        't',
        'u',
        'v',
        'w',
        'x',
        'y',
        'z',
        'é',
        'á',
        'í',
        'ó',
        'ú',
        'ñ',
        'Ñ',
        '¿',
        '¡',
    ),
)


def validate_alphanumeric(text: str) -> str:
    if not all(char in VALID_CHARACTERS for char in text):
        invalid_chars = set(text) - VALID_CHARACTERS
        raise ValueError(f'Invalid characters found: {invalid_chars}')

    return text
