# swagger-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = swagger_client.AmazonInfrastructureControllerApi(swagger_client.ApiClient(configuration))

try:
    # Get instance types
    api_response = api_instance.instance_types_using_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AmazonInfrastructureControllerApi->instance_types_using_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AmazonInfrastructureControllerApi* | [**instance_types_using_get**](docs/AmazonInfrastructureControllerApi.md#instance_types_using_get) | **GET** /instanceTypes | Get instance types
*AmazonInfrastructureControllerApi* | [**subnets_using_get**](docs/AmazonInfrastructureControllerApi.md#subnets_using_get) | **GET** /subnets | Get subnets
*AmazonInfrastructureControllerApi* | [**vpcs_using_get**](docs/AmazonInfrastructureControllerApi.md#vpcs_using_get) | **GET** /vpcs | Get VPCs
*ApplicationControllerApi* | [**cancel_pipeline_using_put**](docs/ApplicationControllerApi.md#cancel_pipeline_using_put) | **PUT** /applications/{application}/pipelines/{id}/cancel | Cancel pipeline
*ApplicationControllerApi* | [**cancel_task_using_put**](docs/ApplicationControllerApi.md#cancel_task_using_put) | **PUT** /applications/{application}/tasks/{id}/cancel | Cancel task
*ApplicationControllerApi* | [**get_all_applications_using_get**](docs/ApplicationControllerApi.md#get_all_applications_using_get) | **GET** /applications | Retrieve a list of applications
*ApplicationControllerApi* | [**get_application_history_using_get**](docs/ApplicationControllerApi.md#get_application_history_using_get) | **GET** /applications/{application}/history | Retrieve a list of an application&#39;s configuration revision history
*ApplicationControllerApi* | [**get_application_using_get**](docs/ApplicationControllerApi.md#get_application_using_get) | **GET** /applications/{application} | Retrieve an application&#39;s details
*ApplicationControllerApi* | [**get_pipeline_config_using_get**](docs/ApplicationControllerApi.md#get_pipeline_config_using_get) | **GET** /applications/{application}/pipelineConfigs/{pipelineName} | Retrieve a pipeline configuration
*ApplicationControllerApi* | [**get_pipeline_configs_for_application_using_get**](docs/ApplicationControllerApi.md#get_pipeline_configs_for_application_using_get) | **GET** /applications/{application}/pipelineConfigs | Retrieve a list of an application&#39;s pipeline configurations
*ApplicationControllerApi* | [**get_pipelines_using_get**](docs/ApplicationControllerApi.md#get_pipelines_using_get) | **GET** /applications/{application}/pipelines | Retrieve a list of an application&#39;s pipeline executions
*ApplicationControllerApi* | [**get_strategy_config_using_get**](docs/ApplicationControllerApi.md#get_strategy_config_using_get) | **GET** /applications/{application}/strategyConfigs/{strategyName} | Retrieve a pipeline strategy configuration
*ApplicationControllerApi* | [**get_strategy_configs_for_application_using_get**](docs/ApplicationControllerApi.md#get_strategy_configs_for_application_using_get) | **GET** /applications/{application}/strategyConfigs | Retrieve a list of an application&#39;s pipeline strategy configurations
*ApplicationControllerApi* | [**get_task_details_using_get**](docs/ApplicationControllerApi.md#get_task_details_using_get) | **GET** /applications/{application}/tasks/{id}/details/{taskDetailsId} | Get task details
*ApplicationControllerApi* | [**get_task_using_get**](docs/ApplicationControllerApi.md#get_task_using_get) | **GET** /applications/{application}/tasks/{id} | Get task
*ApplicationControllerApi* | [**get_tasks_using_get**](docs/ApplicationControllerApi.md#get_tasks_using_get) | **GET** /applications/{application}/tasks | Retrieve a list of an application&#39;s tasks
*ApplicationControllerApi* | [**invoke_pipeline_config_using_post**](docs/ApplicationControllerApi.md#invoke_pipeline_config_using_post) | **POST** /applications/{application}/pipelineConfigs/{pipelineName} | Invoke pipeline config
*ApplicationControllerApi* | [**task_using_post**](docs/ApplicationControllerApi.md#task_using_post) | **POST** /applications/{application}/tasks | Create task
*ArtifactControllerApi* | [**all_using_get**](docs/ArtifactControllerApi.md#all_using_get) | **GET** /artifacts/credentials | Retrieve the list of artifact accounts configured in Clouddriver.
*ArtifactControllerApi* | [**artifact_versions_using_get**](docs/ArtifactControllerApi.md#artifact_versions_using_get) | **GET** /artifacts/account/{accountName}/versions | Retrieve the list of artifact versions by account and artifact names
*AuthControllerApi* | [**get_service_accounts_using_get**](docs/AuthControllerApi.md#get_service_accounts_using_get) | **GET** /auth/user/serviceAccounts | Get service accounts
*AuthControllerApi* | [**logged_out_using_get**](docs/AuthControllerApi.md#logged_out_using_get) | **GET** /auth/loggedOut | Get logged out message
*AuthControllerApi* | [**redirect_using_get**](docs/AuthControllerApi.md#redirect_using_get) | **GET** /auth/redirect | Redirect to Deck
*AuthControllerApi* | [**sync_using_post**](docs/AuthControllerApi.md#sync_using_post) | **POST** /auth/roles/sync | Sync user roles
*AuthControllerApi* | [**user_using_get**](docs/AuthControllerApi.md#user_using_get) | **GET** /auth/user | Get user
*BakeControllerApi* | [**bake_options_using_get**](docs/BakeControllerApi.md#bake_options_using_get) | **GET** /bakery/options/{cloudProvider} | Retrieve a list of available bakery base images for a given cloud provider
*BakeControllerApi* | [**bake_options_using_get1**](docs/BakeControllerApi.md#bake_options_using_get1) | **GET** /bakery/options | Retrieve a list of available bakery base images, grouped by cloud provider
*BakeControllerApi* | [**lookup_logs_using_get**](docs/BakeControllerApi.md#lookup_logs_using_get) | **GET** /bakery/logs/{region}/{statusId} | Retrieve the logs for a given bake
*BuildControllerApi* | [**get_build_masters_using_get**](docs/BuildControllerApi.md#get_build_masters_using_get) | **GET** /v2/builds | Get build masters
*BuildControllerApi* | [**get_build_using_get**](docs/BuildControllerApi.md#get_build_using_get) | **GET** /v2/builds/{buildMaster}/build/{number}/** | Get build for build master
*BuildControllerApi* | [**get_builds_using_get**](docs/BuildControllerApi.md#get_builds_using_get) | **GET** /v2/builds/{buildMaster}/builds/** | Get builds for build master
*BuildControllerApi* | [**get_job_config_using_get**](docs/BuildControllerApi.md#get_job_config_using_get) | **GET** /v2/builds/{buildMaster}/jobs/** | Get job config
*BuildControllerApi* | [**get_jobs_for_build_master_using_get**](docs/BuildControllerApi.md#get_jobs_for_build_master_using_get) | **GET** /v2/builds/{buildMaster}/jobs | Get jobs for build master
*BuildControllerApi* | [**v3_get_build_masters_using_get**](docs/BuildControllerApi.md#v3_get_build_masters_using_get) | **GET** /v3/builds | Get build masters
*BuildControllerApi* | [**v3_get_build_using_get**](docs/BuildControllerApi.md#v3_get_build_using_get) | **GET** /v3/builds/{buildMaster}/build/{number} | Get build for build master
*BuildControllerApi* | [**v3_get_builds_using_get**](docs/BuildControllerApi.md#v3_get_builds_using_get) | **GET** /v3/builds/{buildMaster}/builds | Get builds for build master
*BuildControllerApi* | [**v3_get_job_config_using_get**](docs/BuildControllerApi.md#v3_get_job_config_using_get) | **GET** /v3/builds/{buildMaster}/job | Get job config
*BuildControllerApi* | [**v3_get_jobs_for_build_master_using_get**](docs/BuildControllerApi.md#v3_get_jobs_for_build_master_using_get) | **GET** /v3/builds/{buildMaster}/jobs | Get jobs for build master
*ClusterControllerApi* | [**get_cluster_load_balancers_using_get**](docs/ClusterControllerApi.md#get_cluster_load_balancers_using_get) | **GET** /applications/{application}/clusters/{account}/{clusterName}/{type}/loadBalancers | Retrieve a cluster&#39;s loadbalancers
*ClusterControllerApi* | [**get_clusters_using_get**](docs/ClusterControllerApi.md#get_clusters_using_get) | **GET** /applications/{application}/clusters/{account}/{clusterName} | Retrieve a cluster&#39;s details
*ClusterControllerApi* | [**get_clusters_using_get1**](docs/ClusterControllerApi.md#get_clusters_using_get1) | **GET** /applications/{application}/clusters/{account} | Retrieve a list of clusters for an account
*ClusterControllerApi* | [**get_clusters_using_get2**](docs/ClusterControllerApi.md#get_clusters_using_get2) | **GET** /applications/{application}/clusters | Retrieve a list of cluster names for an application, grouped by account
*ClusterControllerApi* | [**get_scaling_activities_using_get**](docs/ClusterControllerApi.md#get_scaling_activities_using_get) | **GET** /applications/{application}/clusters/{account}/{clusterName}/serverGroups/{serverGroupName}/scalingActivities | Retrieve a list of scaling activities for a server group
*ClusterControllerApi* | [**get_server_groups_using_get**](docs/ClusterControllerApi.md#get_server_groups_using_get) | **GET** /applications/{application}/clusters/{account}/{clusterName}/serverGroups/{serverGroupName} | Retrieve a server group&#39;s details
*ClusterControllerApi* | [**get_server_groups_using_get1**](docs/ClusterControllerApi.md#get_server_groups_using_get1) | **GET** /applications/{application}/clusters/{account}/{clusterName}/serverGroups | Retrieve a list of server groups for a cluster
*ClusterControllerApi* | [**get_target_server_group_using_get**](docs/ClusterControllerApi.md#get_target_server_group_using_get) | **GET** /applications/{application}/clusters/{account}/{clusterName}/{cloudProvider}/{scope}/serverGroups/target/{target} | Retrieve a server group that matches a target coordinate (e.g., newest, ancestor) relative to a cluster
*ConcourseControllerApi* | [**jobs_using_get**](docs/ConcourseControllerApi.md#jobs_using_get) | **GET** /concourse/{buildMaster}/teams/{team}/pipelines/{pipeline}/jobs | Retrieve the list of job names for a given pipeline available to triggers
*ConcourseControllerApi* | [**pipelines_using_get**](docs/ConcourseControllerApi.md#pipelines_using_get) | **GET** /concourse/{buildMaster}/teams/{team}/pipelines | Retrieve the list of pipeline names for a given team available to triggers
*ConcourseControllerApi* | [**resources_using_get**](docs/ConcourseControllerApi.md#resources_using_get) | **GET** /concourse/{buildMaster}/teams/{team}/pipelines/{pipeline}/resources | Retrieve the list of resource names for a given pipeline available to the Concourse stage
*CredentialsControllerApi* | [**get_account_using_get**](docs/CredentialsControllerApi.md#get_account_using_get) | **GET** /credentials/{account} | Retrieve an account&#39;s details
*CredentialsControllerApi* | [**get_accounts_using_get**](docs/CredentialsControllerApi.md#get_accounts_using_get) | **GET** /credentials | Retrieve a list of accounts
*EcsServerGroupEventsControllerApi* | [**get_events_using_get**](docs/EcsServerGroupEventsControllerApi.md#get_events_using_get) | **GET** /applications/{application}/serverGroups/{account}/{serverGroupName}/events | Retrieves a list of events for a server group
*ExecutionsControllerApi* | [**get_latest_executions_by_config_ids_using_get**](docs/ExecutionsControllerApi.md#get_latest_executions_by_config_ids_using_get) | **GET** /executions | Retrieves an ad-hoc collection of executions based on a number of user-supplied parameters. Either executionIds or pipelineConfigIds must be supplied in order to return any results. If both are supplied, an exception will be thrown.
*ExecutionsControllerApi* | [**search_for_pipeline_executions_by_trigger_using_get**](docs/ExecutionsControllerApi.md#search_for_pipeline_executions_by_trigger_using_get) | **GET** /applications/{application}/executions/search | Search for pipeline executions using a combination of criteria. The returned list is sorted by buildTime (trigger time) in reverse order so that newer executions are first in the list.
*FirewallControllerApi* | [**all_by_account_and_region_using_get**](docs/FirewallControllerApi.md#all_by_account_and_region_using_get) | **GET** /firewalls/{account}/{region} | Retrieve a list of firewalls for a given account and region
*FirewallControllerApi* | [**all_by_account_using_get**](docs/FirewallControllerApi.md#all_by_account_using_get) | **GET** /firewalls/{account} | Retrieve a list of firewalls for a given account, grouped by region
*FirewallControllerApi* | [**all_using_get1**](docs/FirewallControllerApi.md#all_using_get1) | **GET** /firewalls | Retrieve a list of firewalls, grouped by account, cloud provider, and region
*FirewallControllerApi* | [**get_security_group_using_get**](docs/FirewallControllerApi.md#get_security_group_using_get) | **GET** /firewalls/{account}/{region}/{name} | Retrieve a firewall&#39;s details
*ImageControllerApi* | [**find_images_using_get**](docs/ImageControllerApi.md#find_images_using_get) | **GET** /images/find | Retrieve a list of images, filtered by cloud provider, region, and account
*ImageControllerApi* | [**find_tags_using_get**](docs/ImageControllerApi.md#find_tags_using_get) | **GET** /images/tags | Find tags
*ImageControllerApi* | [**get_image_details_using_get**](docs/ImageControllerApi.md#get_image_details_using_get) | **GET** /images/{account}/{region}/{imageId} | Get image details
*InstanceControllerApi* | [**get_console_output_using_get**](docs/InstanceControllerApi.md#get_console_output_using_get) | **GET** /instances/{account}/{region}/{instanceId}/console | Retrieve an instance&#39;s console output
*InstanceControllerApi* | [**get_instance_details_using_get**](docs/InstanceControllerApi.md#get_instance_details_using_get) | **GET** /instances/{account}/{region}/{instanceId} | Retrieve an instance&#39;s details
*JobControllerApi* | [**get_job_using_get**](docs/JobControllerApi.md#get_job_using_get) | **GET** /applications/{applicationName}/jobs/{account}/{region}/{name} | Get job
*LoadBalancerControllerApi* | [**get_all_using_get**](docs/LoadBalancerControllerApi.md#get_all_using_get) | **GET** /loadBalancers | Retrieve a list of load balancers for a given cloud provider
*LoadBalancerControllerApi* | [**get_application_load_balancers_using_get**](docs/LoadBalancerControllerApi.md#get_application_load_balancers_using_get) | **GET** /applications/{application}/loadBalancers | Retrieve a list of load balancers for a given application
*LoadBalancerControllerApi* | [**get_load_balancer_details_using_get**](docs/LoadBalancerControllerApi.md#get_load_balancer_details_using_get) | **GET** /loadBalancers/{account}/{region}/{name} | Retrieve a load balancer&#39;s details as a single element list for a given account, region, cloud provider and load balancer name
*LoadBalancerControllerApi* | [**get_load_balancer_using_get**](docs/LoadBalancerControllerApi.md#get_load_balancer_using_get) | **GET** /loadBalancers/{name} | Retrieve a load balancer for a given cloud provider
*NetworkControllerApi* | [**all_by_cloud_provider_using_get**](docs/NetworkControllerApi.md#all_by_cloud_provider_using_get) | **GET** /networks/{cloudProvider} | Retrieve a list of networks for a given cloud provider
*NetworkControllerApi* | [**all_using_get2**](docs/NetworkControllerApi.md#all_using_get2) | **GET** /networks | Retrieve a list of networks, grouped by cloud provider
*PipelineConfigControllerApi* | [**convert_pipeline_config_to_pipeline_template_using_get**](docs/PipelineConfigControllerApi.md#convert_pipeline_config_to_pipeline_template_using_get) | **GET** /pipelineConfigs/{pipelineConfigId}/convertToTemplate | Convert a pipeline config to a pipeline template.
*PipelineConfigControllerApi* | [**get_all_pipeline_configs_using_get**](docs/PipelineConfigControllerApi.md#get_all_pipeline_configs_using_get) | **GET** /pipelineConfigs | Get all pipeline configs.
*PipelineConfigControllerApi* | [**get_pipeline_config_history_using_get**](docs/PipelineConfigControllerApi.md#get_pipeline_config_history_using_get) | **GET** /pipelineConfigs/{pipelineConfigId}/history | Get pipeline config history.
*PipelineControllerApi* | [**cancel_pipeline_using_put1**](docs/PipelineControllerApi.md#cancel_pipeline_using_put1) | **PUT** /pipelines/{id}/cancel | Cancel a pipeline execution
*PipelineControllerApi* | [**delete_pipeline_using_delete**](docs/PipelineControllerApi.md#delete_pipeline_using_delete) | **DELETE** /pipelines/{application}/{pipelineName} | Delete a pipeline definition
*PipelineControllerApi* | [**delete_pipeline_using_delete1**](docs/PipelineControllerApi.md#delete_pipeline_using_delete1) | **DELETE** /pipelines/{id} | Delete a pipeline execution
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_delete**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_delete) | **DELETE** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_get**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_get) | **GET** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_head**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_head) | **HEAD** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_options**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_options) | **OPTIONS** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_patch**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_patch) | **PATCH** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_post**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_post) | **POST** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**evaluate_expression_for_execution_using_put**](docs/PipelineControllerApi.md#evaluate_expression_for_execution_using_put) | **PUT** /pipelines/{id}/evaluateExpression | Evaluate a pipeline expression using the provided execution as context
*PipelineControllerApi* | [**get_pipeline_logs_using_get**](docs/PipelineControllerApi.md#get_pipeline_logs_using_get) | **GET** /pipelines/{id}/logs | Retrieve pipeline execution logs
*PipelineControllerApi* | [**get_pipeline_using_get**](docs/PipelineControllerApi.md#get_pipeline_using_get) | **GET** /pipelines/{id} | Retrieve a pipeline execution
*PipelineControllerApi* | [**invoke_pipeline_config_using_post1**](docs/PipelineControllerApi.md#invoke_pipeline_config_using_post1) | **POST** /pipelines/{application}/{pipelineNameOrId} | Trigger a pipeline execution
*PipelineControllerApi* | [**invoke_pipeline_config_via_echo_using_post**](docs/PipelineControllerApi.md#invoke_pipeline_config_via_echo_using_post) | **POST** /pipelines/v2/{application}/{pipelineNameOrId} | Trigger a pipeline execution
*PipelineControllerApi* | [**pause_pipeline_using_put**](docs/PipelineControllerApi.md#pause_pipeline_using_put) | **PUT** /pipelines/{id}/pause | Pause a pipeline execution
*PipelineControllerApi* | [**rename_pipeline_using_post**](docs/PipelineControllerApi.md#rename_pipeline_using_post) | **POST** /pipelines/move | Rename a pipeline definition
*PipelineControllerApi* | [**restart_stage_using_put**](docs/PipelineControllerApi.md#restart_stage_using_put) | **PUT** /pipelines/{id}/stages/{stageId}/restart | Restart a stage execution
*PipelineControllerApi* | [**resume_pipeline_using_put**](docs/PipelineControllerApi.md#resume_pipeline_using_put) | **PUT** /pipelines/{id}/resume | Resume a pipeline execution
*PipelineControllerApi* | [**save_pipeline_using_post**](docs/PipelineControllerApi.md#save_pipeline_using_post) | **POST** /pipelines | Save a pipeline definition
*PipelineControllerApi* | [**start_using_post**](docs/PipelineControllerApi.md#start_using_post) | **POST** /pipelines/start | Initiate a pipeline execution
*PipelineControllerApi* | [**update_pipeline_using_put**](docs/PipelineControllerApi.md#update_pipeline_using_put) | **PUT** /pipelines/{id} | Update a pipeline definition
*PipelineControllerApi* | [**update_stage_using_patch**](docs/PipelineControllerApi.md#update_stage_using_patch) | **PATCH** /pipelines/{id}/stages/{stageId} | Update a stage execution
*PipelineTemplatesControllerApi* | [**create_using_post**](docs/PipelineTemplatesControllerApi.md#create_using_post) | **POST** /pipelineTemplates | Create a pipeline template.
*PipelineTemplatesControllerApi* | [**delete_using_delete**](docs/PipelineTemplatesControllerApi.md#delete_using_delete) | **DELETE** /pipelineTemplates/{id} | Delete a pipeline template.
*PipelineTemplatesControllerApi* | [**get_using_get**](docs/PipelineTemplatesControllerApi.md#get_using_get) | **GET** /pipelineTemplates/{id} | Get a pipeline template.
*PipelineTemplatesControllerApi* | [**list_pipeline_template_dependents_using_get**](docs/PipelineTemplatesControllerApi.md#list_pipeline_template_dependents_using_get) | **GET** /pipelineTemplates/{id}/dependents | List all pipelines that implement a pipeline template
*PipelineTemplatesControllerApi* | [**list_using_get**](docs/PipelineTemplatesControllerApi.md#list_using_get) | **GET** /pipelineTemplates | List pipeline templates.
*PipelineTemplatesControllerApi* | [**resolve_templates_using_get**](docs/PipelineTemplatesControllerApi.md#resolve_templates_using_get) | **GET** /pipelineTemplates/resolve | Resolve a pipeline template.
*PipelineTemplatesControllerApi* | [**update_using_post**](docs/PipelineTemplatesControllerApi.md#update_using_post) | **POST** /pipelineTemplates/{id} | Update a pipeline template.
*ProjectControllerApi* | [**all_pipelines_for_project_using_get**](docs/ProjectControllerApi.md#all_pipelines_for_project_using_get) | **GET** /projects/{id}/pipelines | Get all pipelines for project
*ProjectControllerApi* | [**all_using_get3**](docs/ProjectControllerApi.md#all_using_get3) | **GET** /projects | Get all projects
*ProjectControllerApi* | [**get_clusters_using_get3**](docs/ProjectControllerApi.md#get_clusters_using_get3) | **GET** /projects/{id}/clusters | Get a project&#39;s clusters
*ProjectControllerApi* | [**get_using_get1**](docs/ProjectControllerApi.md#get_using_get1) | **GET** /projects/{id} | Get a project
*PubsubSubscriptionControllerApi* | [**all_using_get4**](docs/PubsubSubscriptionControllerApi.md#all_using_get4) | **GET** /pubsub/subscriptions | Retrieve the list of pub/sub subscriptions configured in Echo.
*ReorderPipelinesControllerApi* | [**reorder_pipelines_using_post**](docs/ReorderPipelinesControllerApi.md#reorder_pipelines_using_post) | **POST** /actions/pipelines/reorder | Re-order pipelines
*SearchControllerApi* | [**search_using_get**](docs/SearchControllerApi.md#search_using_get) | **GET** /search | Search infrastructure
*SecurityGroupControllerApi* | [**all_by_account_using_get1**](docs/SecurityGroupControllerApi.md#all_by_account_using_get1) | **GET** /securityGroups/{account} | Retrieve a list of security groups for a given account, grouped by region
*SecurityGroupControllerApi* | [**all_using_get5**](docs/SecurityGroupControllerApi.md#all_using_get5) | **GET** /securityGroups | Retrieve a list of security groups, grouped by account, cloud provider, and region
*SecurityGroupControllerApi* | [**get_security_group_using_get1**](docs/SecurityGroupControllerApi.md#get_security_group_using_get1) | **GET** /securityGroups/{account}/{region}/{name} | Retrieve a security group&#39;s details
*ServerGroupControllerApi* | [**get_server_group_details_using_get**](docs/ServerGroupControllerApi.md#get_server_group_details_using_get) | **GET** /applications/{applicationName}/serverGroups/{account}/{region}/{serverGroupName} | Retrieve a server group&#39;s details
*ServerGroupControllerApi* | [**get_server_groups_for_application_using_get**](docs/ServerGroupControllerApi.md#get_server_groups_for_application_using_get) | **GET** /applications/{applicationName}/serverGroups | Retrieve a list of server groups for a given application
*ServerGroupManagerControllerApi* | [**get_server_group_managers_for_application_using_get**](docs/ServerGroupManagerControllerApi.md#get_server_group_managers_for_application_using_get) | **GET** /applications/{application}/serverGroupManagers | Retrieve a list of server group managers for an application
*SnapshotControllerApi* | [**get_current_snapshot_using_get**](docs/SnapshotControllerApi.md#get_current_snapshot_using_get) | **GET** /applications/{application}/snapshots/{account} | Get current snapshot
*SnapshotControllerApi* | [**get_snapshot_history_using_get**](docs/SnapshotControllerApi.md#get_snapshot_history_using_get) | **GET** /applications/{application}/snapshots/{account}/history | Get snapshot history
*SubnetControllerApi* | [**all_by_cloud_provider_using_get1**](docs/SubnetControllerApi.md#all_by_cloud_provider_using_get1) | **GET** /subnets/{cloudProvider} | Retrieve a list of subnets for a given cloud provider
*TaskControllerApi* | [**cancel_task_using_put1**](docs/TaskControllerApi.md#cancel_task_using_put1) | **PUT** /tasks/{id}/cancel | Cancel task
*TaskControllerApi* | [**cancel_tasks_using_put**](docs/TaskControllerApi.md#cancel_tasks_using_put) | **PUT** /tasks/cancel | Cancel tasks
*TaskControllerApi* | [**delete_task_using_delete**](docs/TaskControllerApi.md#delete_task_using_delete) | **DELETE** /tasks/{id} | Delete task
*TaskControllerApi* | [**get_task_details_using_get1**](docs/TaskControllerApi.md#get_task_details_using_get1) | **GET** /tasks/{id}/details/{taskDetailsId} | Get task details
*TaskControllerApi* | [**get_task_using_get1**](docs/TaskControllerApi.md#get_task_using_get1) | **GET** /tasks/{id} | Get task
*TaskControllerApi* | [**task_using_post1**](docs/TaskControllerApi.md#task_using_post1) | **POST** /tasks | Create task
*V2CanaryControllerApi* | [**get_canary_result_using_get**](docs/V2CanaryControllerApi.md#get_canary_result_using_get) | **GET** /v2/canaries/canary/{canaryConfigId}/{canaryExecutionId} | Retrieve a canary result
*V2CanaryControllerApi* | [**get_canary_results_by_application_using_get**](docs/V2CanaryControllerApi.md#get_canary_results_by_application_using_get) | **GET** /v2/canaries/{application}/executions | Retrieve a list of an application&#39;s canary results
*V2CanaryControllerApi* | [**get_metric_set_pair_list_using_get**](docs/V2CanaryControllerApi.md#get_metric_set_pair_list_using_get) | **GET** /v2/canaries/metricSetPairList/{metricSetPairListId} | Retrieve a metric set pair list
*V2CanaryControllerApi* | [**initiate_canary_using_post**](docs/V2CanaryControllerApi.md#initiate_canary_using_post) | **POST** /v2/canaries/canary/{canaryConfigId} | Start a canary execution
*V2CanaryControllerApi* | [**list_credentials_using_get**](docs/V2CanaryControllerApi.md#list_credentials_using_get) | **GET** /v2/canaries/credentials | Retrieve a list of configured Kayenta accounts
*V2CanaryControllerApi* | [**list_judges_using_get**](docs/V2CanaryControllerApi.md#list_judges_using_get) | **GET** /v2/canaries/judges | Retrieve a list of all configured canary judges
*V2CanaryControllerApi* | [**list_metrics_service_metadata_using_get**](docs/V2CanaryControllerApi.md#list_metrics_service_metadata_using_get) | **GET** /v2/canaries/metadata/metricsService | Retrieve a list of descriptors for use in populating the canary config ui
*V2PipelineTemplatesControllerApi* | [**create_using_post1**](docs/V2PipelineTemplatesControllerApi.md#create_using_post1) | **POST** /v2/pipelineTemplates/create | (ALPHA) Create a pipeline template.
*V2PipelineTemplatesControllerApi* | [**delete_using_delete1**](docs/V2PipelineTemplatesControllerApi.md#delete_using_delete1) | **DELETE** /v2/pipelineTemplates/{id} | Delete a pipeline template.
*V2PipelineTemplatesControllerApi* | [**get_using_get2**](docs/V2PipelineTemplatesControllerApi.md#get_using_get2) | **GET** /v2/pipelineTemplates/{id} | (ALPHA) Get a pipeline template.
*V2PipelineTemplatesControllerApi* | [**list_pipeline_template_dependents_using_get1**](docs/V2PipelineTemplatesControllerApi.md#list_pipeline_template_dependents_using_get1) | **GET** /v2/pipelineTemplates/{id}/dependents | (ALPHA) List all pipelines that implement a pipeline template
*V2PipelineTemplatesControllerApi* | [**list_using_get1**](docs/V2PipelineTemplatesControllerApi.md#list_using_get1) | **GET** /v2/pipelineTemplates | (ALPHA) List pipeline templates.
*V2PipelineTemplatesControllerApi* | [**plan_using_post**](docs/V2PipelineTemplatesControllerApi.md#plan_using_post) | **POST** /v2/pipelineTemplates/plan | (ALPHA) Plan a pipeline template configuration.
*V2PipelineTemplatesControllerApi* | [**update_using_post1**](docs/V2PipelineTemplatesControllerApi.md#update_using_post1) | **POST** /v2/pipelineTemplates/update/{id} | (ALPHA) Update a pipeline template.
*VersionControllerApi* | [**get_version_using_get**](docs/VersionControllerApi.md#get_version_using_get) | **GET** /version | Fetch Gate&#39;s current version
*WebhookControllerApi* | [**preconfigured_webhooks_using_get**](docs/WebhookControllerApi.md#preconfigured_webhooks_using_get) | **GET** /webhooks/preconfigured | Retrieve a list of preconfigured webhooks in Orca
*WebhookControllerApi* | [**webhooks_using_post**](docs/WebhookControllerApi.md#webhooks_using_post) | **POST** /webhooks/{type}/{source} | Endpoint for posting webhooks to Spinnaker&#39;s webhook service


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountDetails](docs/AccountDetails.md)
 - [GrantedAuthority](docs/GrantedAuthority.md)
 - [HashMapstringobject](docs/HashMapstringobject.md)
 - [HttpEntity](docs/HttpEntity.md)
 - [Mapstringstring](docs/Mapstringstring.md)
 - [PipelineTemplateDependent](docs/PipelineTemplateDependent.md)
 - [ReorderPipelinesCommand](docs/ReorderPipelinesCommand.md)
 - [ResponseEntity](docs/ResponseEntity.md)
 - [User](docs/User.md)
 - [Version](docs/Version.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



