# coding: utf-8

"""
    Spinnaker API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ClusterControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cluster_load_balancers_using_get(self, application_name, account, cluster_name, type, **kwargs):  # noqa: E501
        """Retrieve a cluster's loadbalancers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_load_balancers_using_get(application_name, account, cluster_name, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: applicationName (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str type: type (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_load_balancers_using_get_with_http_info(application_name, account, cluster_name, type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_load_balancers_using_get_with_http_info(application_name, account, cluster_name, type, **kwargs)  # noqa: E501
            return data

    def get_cluster_load_balancers_using_get_with_http_info(self, application_name, account, cluster_name, type, **kwargs):  # noqa: E501
        """Retrieve a cluster's loadbalancers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_load_balancers_using_get_with_http_info(application_name, account, cluster_name, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application_name: applicationName (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str type: type (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_name', 'account', 'cluster_name', 'type', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_load_balancers_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_name' is set
        if ('application_name' not in params or
                params['application_name'] is None):
            raise ValueError("Missing the required parameter `application_name` when calling `get_cluster_load_balancers_using_get`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_cluster_load_balancers_using_get`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_cluster_load_balancers_using_get`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_cluster_load_balancers_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_name' in params:
            path_params['applicationName'] = params['application_name']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}/{type}/loadBalancers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clusters_using_get(self, application, account, cluster_name, **kwargs):  # noqa: E501
        """Retrieve a cluster's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get(application, account, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clusters_using_get_with_http_info(application, account, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_clusters_using_get_with_http_info(application, account, cluster_name, **kwargs)  # noqa: E501
            return data

    def get_clusters_using_get_with_http_info(self, application, account, cluster_name, **kwargs):  # noqa: E501
        """Retrieve a cluster's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get_with_http_info(application, account, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'cluster_name', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clusters_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_clusters_using_get`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_clusters_using_get`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_clusters_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clusters_using_get1(self, application, account, **kwargs):  # noqa: E501
        """Retrieve a list of clusters for an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get1(application, account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clusters_using_get1_with_http_info(application, account, **kwargs)  # noqa: E501
        else:
            (data) = self.get_clusters_using_get1_with_http_info(application, account, **kwargs)  # noqa: E501
            return data

    def get_clusters_using_get1_with_http_info(self, application, account, **kwargs):  # noqa: E501
        """Retrieve a list of clusters for an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get1_with_http_info(application, account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clusters_using_get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_clusters_using_get1`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_clusters_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clusters_using_get2(self, application, **kwargs):  # noqa: E501
        """Retrieve a list of cluster names for an application, grouped by account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get2(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clusters_using_get2_with_http_info(application, **kwargs)  # noqa: E501
        else:
            (data) = self.get_clusters_using_get2_with_http_info(application, **kwargs)  # noqa: E501
            return data

    def get_clusters_using_get2_with_http_info(self, application, **kwargs):  # noqa: E501
        """Retrieve a list of cluster names for an application, grouped by account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clusters_using_get2_with_http_info(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clusters_using_get2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_clusters_using_get2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scaling_activities_using_get(self, application, account, cluster_name, server_group_name, **kwargs):  # noqa: E501
        """Retrieve a list of scaling activities for a server group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scaling_activities_using_get(application, account, cluster_name, server_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str server_group_name: serverGroupName (required)
        :param str provider: provider
        :param str region: region
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scaling_activities_using_get_with_http_info(application, account, cluster_name, server_group_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scaling_activities_using_get_with_http_info(application, account, cluster_name, server_group_name, **kwargs)  # noqa: E501
            return data

    def get_scaling_activities_using_get_with_http_info(self, application, account, cluster_name, server_group_name, **kwargs):  # noqa: E501
        """Retrieve a list of scaling activities for a server group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scaling_activities_using_get_with_http_info(application, account, cluster_name, server_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str server_group_name: serverGroupName (required)
        :param str provider: provider
        :param str region: region
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'cluster_name', 'server_group_name', 'provider', 'region', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scaling_activities_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_scaling_activities_using_get`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_scaling_activities_using_get`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_scaling_activities_using_get`")  # noqa: E501
        # verify the required parameter 'server_group_name' is set
        if ('server_group_name' not in params or
                params['server_group_name'] is None):
            raise ValueError("Missing the required parameter `server_group_name` when calling `get_scaling_activities_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'server_group_name' in params:
            path_params['serverGroupName'] = params['server_group_name']  # noqa: E501

        query_params = []
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501
        if 'region' in params:
            query_params.append(('region', params['region']))  # noqa: E501

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}/serverGroups/{serverGroupName}/scalingActivities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_server_groups_using_get(self, application, account, cluster_name, server_group_name, **kwargs):  # noqa: E501
        """Retrieve a server group's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_groups_using_get(application, account, cluster_name, server_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str server_group_name: serverGroupName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_server_groups_using_get_with_http_info(application, account, cluster_name, server_group_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_server_groups_using_get_with_http_info(application, account, cluster_name, server_group_name, **kwargs)  # noqa: E501
            return data

    def get_server_groups_using_get_with_http_info(self, application, account, cluster_name, server_group_name, **kwargs):  # noqa: E501
        """Retrieve a server group's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_groups_using_get_with_http_info(application, account, cluster_name, server_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str server_group_name: serverGroupName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'cluster_name', 'server_group_name', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_groups_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_server_groups_using_get`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_server_groups_using_get`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_server_groups_using_get`")  # noqa: E501
        # verify the required parameter 'server_group_name' is set
        if ('server_group_name' not in params or
                params['server_group_name'] is None):
            raise ValueError("Missing the required parameter `server_group_name` when calling `get_server_groups_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'server_group_name' in params:
            path_params['serverGroupName'] = params['server_group_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}/serverGroups/{serverGroupName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_server_groups_using_get1(self, application, account, cluster_name, **kwargs):  # noqa: E501
        """Retrieve a list of server groups for a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_groups_using_get1(application, account, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_server_groups_using_get1_with_http_info(application, account, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_server_groups_using_get1_with_http_info(application, account, cluster_name, **kwargs)  # noqa: E501
            return data

    def get_server_groups_using_get1_with_http_info(self, application, account, cluster_name, **kwargs):  # noqa: E501
        """Retrieve a list of server groups for a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_groups_using_get1_with_http_info(application, account, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str x_rate_limit_app: X-RateLimit-App
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'cluster_name', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_groups_using_get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_server_groups_using_get1`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_server_groups_using_get1`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_server_groups_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}/serverGroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_server_group_using_get(self, application, account, cluster_name, cloud_provider, scope, target, **kwargs):  # noqa: E501
        """Retrieve a server group that matches a target coordinate (e.g., newest, ancestor) relative to a cluster  # noqa: E501

        `scope` is either a zone or a region  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_server_group_using_get(application, account, cluster_name, cloud_provider, scope, target, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str cloud_provider: cloudProvider (required)
        :param str scope: scope (required)
        :param str target: target (required)
        :param bool only_enabled: onlyEnabled
        :param bool validate_oldest: validateOldest
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_target_server_group_using_get_with_http_info(application, account, cluster_name, cloud_provider, scope, target, **kwargs)  # noqa: E501
        else:
            (data) = self.get_target_server_group_using_get_with_http_info(application, account, cluster_name, cloud_provider, scope, target, **kwargs)  # noqa: E501
            return data

    def get_target_server_group_using_get_with_http_info(self, application, account, cluster_name, cloud_provider, scope, target, **kwargs):  # noqa: E501
        """Retrieve a server group that matches a target coordinate (e.g., newest, ancestor) relative to a cluster  # noqa: E501

        `scope` is either a zone or a region  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_server_group_using_get_with_http_info(application, account, cluster_name, cloud_provider, scope, target, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str application: application (required)
        :param str account: account (required)
        :param str cluster_name: clusterName (required)
        :param str cloud_provider: cloudProvider (required)
        :param str scope: scope (required)
        :param str target: target (required)
        :param bool only_enabled: onlyEnabled
        :param bool validate_oldest: validateOldest
        :param str x_rate_limit_app: X-RateLimit-App
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application', 'account', 'cluster_name', 'cloud_provider', 'scope', 'target', 'only_enabled', 'validate_oldest', 'x_rate_limit_app']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_server_group_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application' is set
        if ('application' not in params or
                params['application'] is None):
            raise ValueError("Missing the required parameter `application` when calling `get_target_server_group_using_get`")  # noqa: E501
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `get_target_server_group_using_get`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params or
                params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_target_server_group_using_get`")  # noqa: E501
        # verify the required parameter 'cloud_provider' is set
        if ('cloud_provider' not in params or
                params['cloud_provider'] is None):
            raise ValueError("Missing the required parameter `cloud_provider` when calling `get_target_server_group_using_get`")  # noqa: E501
        # verify the required parameter 'scope' is set
        if ('scope' not in params or
                params['scope'] is None):
            raise ValueError("Missing the required parameter `scope` when calling `get_target_server_group_using_get`")  # noqa: E501
        # verify the required parameter 'target' is set
        if ('target' not in params or
                params['target'] is None):
            raise ValueError("Missing the required parameter `target` when calling `get_target_server_group_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application' in params:
            path_params['application'] = params['application']  # noqa: E501
        if 'account' in params:
            path_params['account'] = params['account']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'cloud_provider' in params:
            path_params['cloudProvider'] = params['cloud_provider']  # noqa: E501
        if 'scope' in params:
            path_params['scope'] = params['scope']  # noqa: E501
        if 'target' in params:
            path_params['target'] = params['target']  # noqa: E501

        query_params = []
        if 'only_enabled' in params:
            query_params.append(('onlyEnabled', params['only_enabled']))  # noqa: E501
        if 'validate_oldest' in params:
            query_params.append(('validateOldest', params['validate_oldest']))  # noqa: E501

        header_params = {}
        if 'x_rate_limit_app' in params:
            header_params['X-RateLimit-App'] = params['x_rate_limit_app']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/applications/{application}/clusters/{account}/{clusterName}/{cloudProvider}/{scope}/serverGroups/target/{target}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
