# splitit-onboarding-python-sdk
Splitit's Onboarding API

This Python package is automatically generated by the [Konfig](https://konfigthis.com):

- API version: 1.0.0
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonPriorClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/konfig-dev/splitit-onboarding-sdks/tree/main/python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/konfig-dev/splitit-onboarding-sdks/tree/main/python.git`)

Then import the package:
```python
import splitit_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import splitit_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import splitit_client
from pprint import pprint
from splitit_client.api import data_api
from splitit_client.model.countries_response import CountriesResponse
from splitit_client.model.currencies_response import CurrenciesResponse
from splitit_client.model.enum_dto import EnumDTO
from splitit_client.model.merchant_verticals_response import MerchantVerticalsResponse
from splitit_client.model.processors_response import ProcessorsResponse
from splitit_client.model.self_on_boarding_error_response import SelfOnBoardingErrorResponse
# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.
client_id = os.environ["CLIENT_ID"]
client_secret = os.environ["CLIENT_SECRET"]
configuration = splitit_client.Configuration(
    # Defining the host is optional and defaults to https://onboarding-v2.sandbox.splitit.com
    # See configuration.py for a list of all supported configuration parameters.
    host = 'https://onboarding-v2.sandbox.splitit.com'
    client_id=client_id,
    client_secret=client_secret
)


# Enter a context with an instance of the API client
with splitit_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = data_api.DataApi(api_client)

    try:
        api_response = api_instance.get_countries()
        pprint(api_response)
    except splitit_client.ApiException as e:
        print("Exception when calling DataApi->get_countries: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://onboarding-v2.sandbox.splitit.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataApi* | [**get_countries**](docs/DataApi.md#get_countries) | **GET** /api/data/get-countries | 
*DataApi* | [**get_currencies**](docs/DataApi.md#get_currencies) | **GET** /api/data/get-currencies | 
*DataApi* | [**get_processors**](docs/DataApi.md#get_processors) | **GET** /api/data/get-processors | 
*DataApi* | [**get_verticals**](docs/DataApi.md#get_verticals) | **GET** /api/data/get-verticals | 
*DataApi* | [**status_legend**](docs/DataApi.md#status_legend) | **GET** /api/data/status-legend | 
*MerchantsApi* | [**create_merchant**](docs/MerchantsApi.md#create_merchant) | **POST** /api/merchants/create | 
*MerchantsApi* | [**get_merchant_details**](docs/MerchantsApi.md#get_merchant_details) | **GET** /api/merchants/get-details | 
*MerchantsApi* | [**get_merchants**](docs/MerchantsApi.md#get_merchants) | **GET** /api/merchants/get | 


## Documentation For Models

 - [CountriesResponse](docs/CountriesResponse.md)
 - [CountryResponse](docs/CountryResponse.md)
 - [CreateMerchantRequest](docs/CreateMerchantRequest.md)
 - [CreateMerchantResponse](docs/CreateMerchantResponse.md)
 - [CurrenciesResponse](docs/CurrenciesResponse.md)
 - [CurrencyResponse](docs/CurrencyResponse.md)
 - [EnumDTO](docs/EnumDTO.md)
 - [GetMerchantDetailsResponse](docs/GetMerchantDetailsResponse.md)
 - [GetMerchantResponse](docs/GetMerchantResponse.md)
 - [GetMerchantsResponse](docs/GetMerchantsResponse.md)
 - [MerchantVerticalResponse](docs/MerchantVerticalResponse.md)
 - [MerchantVerticalsResponse](docs/MerchantVerticalsResponse.md)
 - [ProcessorAuthenticationParametersRequest](docs/ProcessorAuthenticationParametersRequest.md)
 - [ProcessorResponse](docs/ProcessorResponse.md)
 - [ProcessorsResponse](docs/ProcessorsResponse.md)
 - [SelfOnBoardingErrorResponse](docs/SelfOnBoardingErrorResponse.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **onboarding.api.v2**: onboarding.api.v2


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in splitit_client.apis and splitit_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from splitit_client.api.default_api import DefaultApi`
- `from splitit_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import splitit_client
from splitit_client.apis import *
from splitit_client.models import *
```

