# splitit-onboarding-python-sdk
Splitit's Onboarding API

- API version: 1.0.0
- Package version: 2.0.0

## Requirements.

Python >=3.7

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install splitit-onboarding-python-sdk==2.0.0
```
(you may need to run `pip` with root permission: `sudo pip install splitit-onboarding-python-sdk==2.0.0`)

Then import the package:
```python
import splitit_client
```
## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from pprint import pprint
from splitit_client import Splitit

splitit = Splitit(
    # Defining the host is optional and defaults to https://onboarding-v2.sandbox.splitit.com
    # See configuration.py for a list of all supported configuration parameters.
    host = "https://onboarding-v2.sandbox.splitit.com",

    # Configure OAuth2 access token for authorization: oauth2
    access_token = 'YOUR_ACCESS_TOKEN'
)

get_countries_response = splitit.data.get_countries()
try:
    pprint(get_countries_response.body["countries"])
    pprint(get_countries_response.headers)
    pprint(get_countries_response.status)
except ApiException as e:
    print("Exception when calling CountriesResponse.get_countries: %s\n" % e)
    pprint(e.body)
    pprint(e.headers)
    pprint(e.status)
    pprint(e.reason)
```

## Documentation for API Endpoints

All URIs are relative to *https://onboarding-v2.sandbox.splitit.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataApi* | [**get_countries**](docs/apis/tags/DataApi.md#get_countries) | **get** /api/data/get-countries | 
*DataApi* | [**get_currencies**](docs/apis/tags/DataApi.md#get_currencies) | **get** /api/data/get-currencies | 
*DataApi* | [**get_processors**](docs/apis/tags/DataApi.md#get_processors) | **get** /api/data/get-processors | 
*DataApi* | [**get_verticals**](docs/apis/tags/DataApi.md#get_verticals) | **get** /api/data/get-verticals | 
*DataApi* | [**status_legend**](docs/apis/tags/DataApi.md#status_legend) | **get** /api/data/status-legend | 
*MerchantsApi* | [**create**](docs/apis/tags/MerchantsApi.md#create) | **post** /api/merchants/create | 
*MerchantsApi* | [**get**](docs/apis/tags/MerchantsApi.md#get) | **get** /api/merchants/get | 
*MerchantsApi* | [**get_details**](docs/apis/tags/MerchantsApi.md#get_details) | **get** /api/merchants/get-details | 

## Documentation For Models

 - [CountriesResponse](docs/models/CountriesResponse.md)
 - [CountryResponse](docs/models/CountryResponse.md)
 - [CreateMerchantRequest](docs/models/CreateMerchantRequest.md)
 - [CreateMerchantResponse](docs/models/CreateMerchantResponse.md)
 - [CurrenciesResponse](docs/models/CurrenciesResponse.md)
 - [CurrencyResponse](docs/models/CurrencyResponse.md)
 - [EnumDTO](docs/models/EnumDTO.md)
 - [GetMerchantDetailsResponse](docs/models/GetMerchantDetailsResponse.md)
 - [GetMerchantResponse](docs/models/GetMerchantResponse.md)
 - [GetMerchantsResponse](docs/models/GetMerchantsResponse.md)
 - [MerchantVerticalResponse](docs/models/MerchantVerticalResponse.md)
 - [MerchantVerticalsResponse](docs/models/MerchantVerticalsResponse.md)
 - [ProcessorAuthenticationParametersRequest](docs/models/ProcessorAuthenticationParametersRequest.md)
 - [ProcessorResponse](docs/models/ProcessorResponse.md)
 - [ProcessorsResponse](docs/models/ProcessorsResponse.md)
 - [SelfOnBoardingErrorResponse](docs/models/SelfOnBoardingErrorResponse.md)
 - [StatusLegendResponse](docs/models/StatusLegendResponse.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **onboarding.api.v2**: onboarding.api.v2



## Author
This Python package is automatically generated by [Konfig](https://konfigthis.com)
