"""
    splitit-web-api-v3

    Splitit's API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""


import re  # noqa: F401
import sys  # noqa: F401

from splitit_client.api_client import ApiClient, Endpoint as _Endpoint
from splitit_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from splitit_client.model.failed_response import FailedResponse
from splitit_client.model.installment_plan_cancel_response import InstallmentPlanCancelResponse
from splitit_client.model.installment_plan_create_request import InstallmentPlanCreateRequest
from splitit_client.model.installment_plan_get_response import InstallmentPlanGetResponse
from splitit_client.model.installment_plan_model import InstallmentPlanModel
from splitit_client.model.installment_plan_refund_request import InstallmentPlanRefundRequest
from splitit_client.model.installment_plan_refund_response import InstallmentPlanRefundResponse
from splitit_client.model.installment_plan_update_request_by_identifier import InstallmentPlanUpdateRequestByIdentifier
from splitit_client.model.installment_plan_update_response import InstallmentPlanUpdateResponse
from splitit_client.model.plan_error_response import PlanErrorResponse
from splitit_client.model.update_order_request import UpdateOrderRequest
from splitit_client.model.verify_authorization_response import VerifyAuthorizationResponse


class InstallmentPlanApi(object):
    """NOTE: This class is auto generated by Konfig
    Ref: https://konfigthis.com

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.cancel_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanCancelResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/{installmentPlanNumber}/cancel',
                'operation_id': 'cancel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'required': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'installment_plan_number':
                        (str,),
                    'x_splitit_idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'installment_plan_number': 'installmentPlanNumber',
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'installment_plan_number': 'path',
                    'x_splitit_idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanModel,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/{installmentPlanNumber}',
                'operation_id': 'get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'required': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'installment_plan_number':
                        (str,),
                    'x_splitit_idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'installment_plan_number': 'installmentPlanNumber',
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'installment_plan_number': 'path',
                    'x_splitit_idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.post_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanModel,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans',
                'operation_id': 'post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_splitit_idempotency_key',
                    'installment_plan_create_request',
                    'x_splitit_test_mode',
                ],
                'required': [
                    'x_splitit_idempotency_key',
                    'installment_plan_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                    'x_splitit_test_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('x_splitit_test_mode',): {

                        "NONE": "None",
                        "REGULAR": "Regular",
                        "FAST": "Fast",
                        "AUTOMATION": "Automation"
                    },
                },
                'openapi_types': {
                    'x_splitit_idempotency_key':
                        (str,),
                    'installment_plan_create_request':
                        (InstallmentPlanCreateRequest,),
                    'x_splitit_test_mode':
                        (str,),
                },
                'attribute_map': {
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                    'x_splitit_test_mode': 'X-Splitit-TestMode',
                },
                'location_map': {
                    'x_splitit_idempotency_key': 'header',
                    'installment_plan_create_request': 'body',
                    'x_splitit_test_mode': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.refund_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanRefundResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/{installmentPlanNumber}/refund',
                'operation_id': 'refund',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                    'installment_plan_refund_request',
                ],
                'required': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                    'installment_plan_refund_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'installment_plan_number':
                        (str,),
                    'x_splitit_idempotency_key':
                        (str,),
                    'installment_plan_refund_request':
                        (InstallmentPlanRefundRequest,),
                },
                'attribute_map': {
                    'installment_plan_number': 'installmentPlanNumber',
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'installment_plan_number': 'path',
                    'x_splitit_idempotency_key': 'header',
                    'installment_plan_refund_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.search_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanGetResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/search',
                'operation_id': 'search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_splitit_idempotency_key',
                    'installment_plan_number',
                    'ref_order_number',
                    'extended_params',
                ],
                'required': [
                    'x_splitit_idempotency_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_splitit_idempotency_key':
                        (str,),
                    'installment_plan_number':
                        (str,),
                    'ref_order_number':
                        (str,),
                    'extended_params':
                        ({str: (str,)},),
                },
                'attribute_map': {
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                    'installment_plan_number': 'installmentPlanNumber',
                    'ref_order_number': 'refOrderNumber',
                    'extended_params': 'extendedParams',
                },
                'location_map': {
                    'x_splitit_idempotency_key': 'header',
                    'installment_plan_number': 'query',
                    'ref_order_number': 'query',
                    'extended_params': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_order_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanUpdateResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/{installmentPlanNumber}/updateorder',
                'operation_id': 'update_order',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                    'update_order_request',
                ],
                'required': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                    'update_order_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'installment_plan_number':
                        (str,),
                    'x_splitit_idempotency_key':
                        (str,),
                    'update_order_request':
                        (UpdateOrderRequest,),
                },
                'attribute_map': {
                    'installment_plan_number': 'installmentPlanNumber',
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'installment_plan_number': 'path',
                    'x_splitit_idempotency_key': 'header',
                    'update_order_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.update_order2_endpoint = _Endpoint(
            settings={
                'response_type': (InstallmentPlanUpdateResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/updateorder',
                'operation_id': 'update_order2',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_splitit_idempotency_key',
                    'installment_plan_update_request_by_identifier',
                ],
                'required': [
                    'x_splitit_idempotency_key',
                    'installment_plan_update_request_by_identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_splitit_idempotency_key':
                        (str,),
                    'installment_plan_update_request_by_identifier':
                        (InstallmentPlanUpdateRequestByIdentifier,),
                },
                'attribute_map': {
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'x_splitit_idempotency_key': 'header',
                    'installment_plan_update_request_by_identifier': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.verify_authorization_endpoint = _Endpoint(
            settings={
                'response_type': (VerifyAuthorizationResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/installmentplans/{installmentPlanNumber}/verifyauthorization',
                'operation_id': 'verify_authorization',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'required': [
                    'installment_plan_number',
                    'x_splitit_idempotency_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'installment_plan_number':
                        (str,),
                    'x_splitit_idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'installment_plan_number': 'installmentPlanNumber',
                    'x_splitit_idempotency_key': 'X-Splitit-IdempotencyKey',
                },
                'location_map': {
                    'installment_plan_number': 'path',
                    'x_splitit_idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def cancel(
        self,
        installment_plan_number,
        x_splitit_idempotency_key,
        **kwargs
    ):
        """cancel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel(installment_plan_number, x_splitit_idempotency_key, async_req=True)
        >>> result = thread.get()

        Args:
            installment_plan_number (str):
            x_splitit_idempotency_key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanCancelResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['installment_plan_number'] = \
            installment_plan_number
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        return self.cancel_endpoint.call_with_http_info(**kwargs)

    def get(
        self,
        installment_plan_number,
        x_splitit_idempotency_key,
        **kwargs
    ):
        """get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get(installment_plan_number, x_splitit_idempotency_key, async_req=True)
        >>> result = thread.get()

        Args:
            installment_plan_number (str):
            x_splitit_idempotency_key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['installment_plan_number'] = \
            installment_plan_number
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        return self.get_endpoint.call_with_http_info(**kwargs)

    def post(
        self,
        x_splitit_idempotency_key,
        installment_plan_create_request,
        **kwargs
    ):
        """post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post(x_splitit_idempotency_key, installment_plan_create_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_splitit_idempotency_key (str):
            installment_plan_create_request (InstallmentPlanCreateRequest):

        Keyword Args:
            x_splitit_test_mode (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        kwargs['installment_plan_create_request'] = \
            installment_plan_create_request
        return self.post_endpoint.call_with_http_info(**kwargs)

    def refund(
        self,
        installment_plan_number,
        x_splitit_idempotency_key,
        installment_plan_refund_request,
        **kwargs
    ):
        """refund  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.refund(installment_plan_number, x_splitit_idempotency_key, installment_plan_refund_request, async_req=True)
        >>> result = thread.get()

        Args:
            installment_plan_number (str):
            x_splitit_idempotency_key (str):
            installment_plan_refund_request (InstallmentPlanRefundRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanRefundResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['installment_plan_number'] = \
            installment_plan_number
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        kwargs['installment_plan_refund_request'] = \
            installment_plan_refund_request
        return self.refund_endpoint.call_with_http_info(**kwargs)

    def search(
        self,
        x_splitit_idempotency_key,
        **kwargs
    ):
        """search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search(x_splitit_idempotency_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_splitit_idempotency_key (str):

        Keyword Args:
            installment_plan_number (str): [optional]
            ref_order_number (str): [optional]
            extended_params ({str: (str,)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanGetResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        return self.search_endpoint.call_with_http_info(**kwargs)

    def update_order(
        self,
        installment_plan_number,
        x_splitit_idempotency_key,
        update_order_request,
        **kwargs
    ):
        """update_order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_order(installment_plan_number, x_splitit_idempotency_key, update_order_request, async_req=True)
        >>> result = thread.get()

        Args:
            installment_plan_number (str):
            x_splitit_idempotency_key (str):
            update_order_request (UpdateOrderRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['installment_plan_number'] = \
            installment_plan_number
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        kwargs['update_order_request'] = \
            update_order_request
        return self.update_order_endpoint.call_with_http_info(**kwargs)

    def update_order2(
        self,
        x_splitit_idempotency_key,
        installment_plan_update_request_by_identifier,
        **kwargs
    ):
        """update_order2  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_order2(x_splitit_idempotency_key, installment_plan_update_request_by_identifier, async_req=True)
        >>> result = thread.get()

        Args:
            x_splitit_idempotency_key (str):
            installment_plan_update_request_by_identifier (InstallmentPlanUpdateRequestByIdentifier):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstallmentPlanUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        kwargs['installment_plan_update_request_by_identifier'] = \
            installment_plan_update_request_by_identifier
        return self.update_order2_endpoint.call_with_http_info(**kwargs)

    def verify_authorization(
        self,
        installment_plan_number,
        x_splitit_idempotency_key,
        **kwargs
    ):
        """verify_authorization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_authorization(installment_plan_number, x_splitit_idempotency_key, async_req=True)
        >>> result = thread.get()

        Args:
            installment_plan_number (str):
            x_splitit_idempotency_key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            VerifyAuthorizationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['installment_plan_number'] = \
            installment_plan_number
        kwargs['x_splitit_idempotency_key'] = \
            x_splitit_idempotency_key
        return self.verify_authorization_endpoint.call_with_http_info(**kwargs)

