# coding: utf-8

"""
    splitit-web-api-v3

    Splitit's Web API

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from splitit_client.type.card_data2 import CardData2
from splitit_client.type.consumer_data import ConsumerData
from splitit_client.type.disputes import Disputes
from splitit_client.type.external_provider_types import ExternalProviderTypes
from splitit_client.type.fraud_check import FraudCheck
from splitit_client.type.installment2 import Installment2
from splitit_client.type.installment_plan_extended_params import InstallmentPlanExtendedParams
from splitit_client.type.merchant_ref import MerchantRef
from splitit_client.type.money import Money
from splitit_client.type.money_flows import MoneyFlows
from splitit_client.type.re_authorization import ReAuthorization
from splitit_client.type.reference_entity_base import ReferenceEntityBase
from splitit_client.type.terminal_ref import TerminalRef
from splitit_client.type.test_modes import TestModes

class RequiredInstallmentPlan(TypedDict):
    NumberOfInstallments: int

    NumberOfProcessedInstallments: int

    IsFullCaptured: bool

    IsChargedBack: bool

    ArePaymentsOnHold: bool

    ScpFundingPercent: typing.Union[int, float]

    FundingStatus: MoneyFlows

    TestMode: TestModes

    CreationDateTime: datetime

    LifeTimeUrlExpirationTime: datetime

    IsInAutoRetry: bool

    AllowCardUpdateOnSplititPortals: bool

    InstallmentsScheduleInterval: int

class OptionalInstallmentPlan(TypedDict, total=False):
    InstallmentPlanNumber: str

    InstallmentPlanStatus: ReferenceEntityBase

    Amount: Money

    OutstandingAmount: Money

    Disputes: Disputes

    OriginalAmount: Money

    RefundAmount: Money

    Consumer: ConsumerData

    ActiveCard: CardData2

    FraudCheck: FraudCheck

    Terminal: TerminalRef

    Merchant: MerchantRef

    RefOrderNumber: str

    PurchaseMethod: ReferenceEntityBase

    Strategy: ReferenceEntityBase

    DelayResolution: ReferenceEntityBase

    ExtendedParams: InstallmentPlanExtendedParams

    Installments: typing.List[Installment2]

    SecureAuthorizations: typing.List[ReAuthorization]

    LogoUrl: str

    PaymentMethod: str

    OnHoldLastOpenDate: datetime

    OnHoldLastOpenUserId: str

    ExternalPaymentProvider: ExternalProviderTypes

class InstallmentPlan(RequiredInstallmentPlan, OptionalInstallmentPlan):
    pass
