from spm._runtime import Runtime


def _ft_datatype_raw(*args, **kwargs):
    """
      FT_DATATYPE_RAW describes the FieldTrip MATLAB structure for raw data  
         
        The raw datatype represents sensor-level time-domain data typically  
        obtained after calling FT_DEFINETRIAL and FT_PREPROCESSING. It contains  
        one or multiple segments of data, each represented as Nchan X Ntime  
        arrays.  
         
        An example of a raw data structure with 151 MEG channels is  
         
                 label: {151x1 cell}      the channel labels represented as a cell-array of strings  
                  time: {1x266 cell}      the time axis [1*Ntime double] per trial  
                 trial: {1x266 cell}      the numeric data as a cell array, with a matrix of [151*Ntime double] per trial  
            sampleinfo: [266x2 double]    the begin and endsample of each trial relative to the recording on disk  
             trialinfo: [266x1 double]    optional trigger or condition codes for each trial  
                   hdr: [1x1 struct]      the full header information of the original dataset on disk  
                  grad: [1x1 struct]      information about the sensor array (for EEG it is called elec)  
                   cfg: [1x1 struct]      the configuration used by the function that generated this data structure  
         
        Required fields:  
          - time, trial, label  
         
        Optional fields:  
          - sampleinfo, trialinfo, grad, elec, opto, hdr, cfg  
         
        Deprecated fields:  
          - fsample  
         
        Obsoleted fields:  
          - offset  
         
        Revision history:  
         
        (2011/latest) The description of the sensors has changed, see FT_DATATYPE_SENS  
        for further information.  
         
        (2010v2) The trialdef field has been replaced by the sampleinfo and  
        trialinfo fields. The sampleinfo corresponds to trl(:,1:2), the trialinfo  
        to trl(4:end).  
         
        (2010v1) In 2010/Q3 it shortly contained the trialdef field which was a copy  
        of the trial definition (trl) is generated by FT_DEFINETRIAL.  
         
        (2007) It used to contain the offset field, which corresponds to trl(:,3).  
        Since the offset field is redundant with the time axis, the offset field is  
        from now on not present any more. It can be recreated if needed.  
         
        (2003) The initial version was defined  
         
        See also FT_DATATYPE, FT_DATATYPE_COMP, FT_DATATYPE_TIMELOCK, FT_DATATYPE_FREQ,  
        FT_DATATYPE_SPIKE, FT_DATATYPE_SENS  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/ft_datatype_raw.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("ft_datatype_raw", *args, **kwargs)
