from spm._runtime import Runtime


def spm_MDP_VB_XXX(*args, **kwargs):
    """
      active inference and learning using belief propagation (factorised)  
        FORMAT [MDP] = spm_MDP_VB_XXX(MDP,OPTIONS)  
         
        Input; MDP(m,n)       - structure array of m models over n epochs  
        MDP.U(1,F)            - controllable factors  
        MDP.T                 - number of outcomes  
         
        MDP.A{G}(O,N1,...,NF) - likelihood of O outcomes for modality G, given hidden states  
        MDP.B{F}(N,N,U)       - transitions among N states under U control states  
        MDP.C{G}(O)           - prior probabilities over final outcomes (log preferences)  
        MDP.D{F}(N,1)         - prior probabilities over initial states (Dirichlet counts)  
        MDP.E(P,1)            - prior probabilities over control states (Dirichlet counts)  
         
        MDP.a{G}              - concentration parameters for A  
        MDP.b{F}              - concentration parameters for B  
        MDP.c{G}              - concentration parameters for C  
        MDP.d{F}              - concentration parameters for D  
        MDP.e{P}              - concentration parameters for E  
         
        optional:  
        MDP.s(F,T)            - true states   - for each hidden factor  
        MDP.o(G,T)            - true outcomes - for each outcome modality  
        MDP.O{G,T}            - likelihoods   - for each outcome modality  
        MDP.u(F,T)            - true controls - for each hidden factor  
         
        MDP.alpha             - precision - action selection [512]  
        MDP.chi               - Occams window for deep updates  
        MDP.eta               - Forgetting hyperparameter [1]  
        MDP.N                 - depth of deep policy search [N = 0]  
        MDP.k(1,F)            - beliefs about controllable factors  
         
        MDP.demi.C            - Mixed model: cell array of true causes (DEM.C)  
        MDP.demi.U            - Bayesian model average (DEM.U) see: spm_MDP_DEM  
        MDP.link              - link array to generate outcomes from  
                                subordinate MDP for deep (hierarchical) models  
         
        MDP.n(O,T)            - outputs for modality O at time T are generated by  
                                agent n(O,T); unless n(O,T) = 0, when outputs  
                                are generated by the agents states  
        MDP.m(F)              - states for factor F are generated for agent m(F);  
                                unless m(F) = 0, when states are updated for the  
                                agent in question  
         
        OPTIONS.A             - switch to evaluate explicit action  
        OPTIONS.B             - switch to evaluate backwards pass (replay)  
        OPTIONS.N             - switch to evaluate neuronal responses  
        OPTIONS.P             - switch to plot graphics: [default: 0)  
        OPTIONS.D             - switch to update initial states with final states  
        OPTIONS.BMR           - Bayesian model reduction for multiple trials  
                                see: spm_MDP_VB_sleep(MDP,BMR)  
        Outputs:  
         
        MDP.P{F}(U,T)         - conditional expectations over control states  
        MDP.X{F}(N,T)         - conditional expectations over hidden states  
        MDP.Y{O,T}            - conditional expectations over outcomes  
        MDP.R(P,T)            - conditional expectations over policies  
         
        MDP.F(1,T)            - (negative) free energies (states)  over time  
        MDP.Z{U,T}            - (negative) free energies (control) over time  
        MDP.G{P,T}            - (negative) expected free energies  over time  
        MDP.Fa(G)             - (negative) free energy of parameters (a)  
        MDP.Fb(F)             - ...  
         
        MDP.v                 - expected free energy over policies  
        MDP.w                 - precision of beliefs about policies  
        MDP.un                - simulated neuronal encoding of hidden states  
        MDP.xn                - simulated neuronal encoding of policies  
        MDP.wn                - simulated neuronal encoding of precision (tonic)  
        MDP.dn                - simulated dopamine responses (phasic)  
         
        This routine provides solutions of active inference (minimisation of  
        variational free energy) using a generative model based upon a Markov  
        decision process. The model and inference scheme is formulated in  
        discrete space and time. This means that the generative model (and  
        process) are hidden Markov models whose dynamics are given by transition  
        probabilities among states and the likelihood corresponds to a particular  
        outcome conditioned upon hidden states.  
         
        This implementation equips agents with the prior beliefs that they will  
        maximise expected free energy. Expected free energy can be interpreted in  
        several ways - most intuitively as minimising the KL divergence between  
        predicted and preferred outcomes (specified as prior beliefs) -i.e., risk  
        while simultaneously minimising ambiguity. Alternatively, this can be  
        rearranged into expected information gain and expected value, where value  
        is the log of prior preferences (overstates or outcomes).  
         
        This implementation generalises previous MDP based formulations of active  
        inference by equipping each factor of latent states with a number of  
        paths; some of which may be controllable and others not. Controllable  
        factors are now specified with indicator variables in the vector MDP.U.  
        Furthermore, because the scheme uses sophisticated inference (i.e., a  
        recursive tree search accumulating path integral is of expected free  
        energy) a policy reduces to a particular combination of controllable  
        paths or dynamics over factors. In consequence, posterior beliefs cover  
        latent states and paths; with their associated variational free energies.  
        Furthermore, it is now necessary to specify the initial states and the  
        initial paths using D and E respectively. In other words, he now plays  
        the role of a prior over the path of each factor that can only be changed  
        if it is controllable (it no longer corresponds to a prior over  
        policies).  
         
        In addition to state and path estimation (and policy selection), the  
        scheme also updates model parameters; including the state transition  
        matrices, mapping to outcomes and the initial state. This is useful for  
        learning the context. Likelihood and prior probabilities can be specified  
        in terms of concentration parameters (of a Dirichlet distribution  
        (a,b,c,...). If the corresponding (A,B,C,...) are supplied, they will be  
        used to generate outcomes.  
         
        This scheme allows for differences in the functional form of priors –  
        specified in terms of probability transition tensors – between the  
        generating process and generative model. The generative model is, by  
        default, specified in terms of Dirichlet parameters, while the generative  
        process is specified in terms of expected (likelihood and prior  
        transition) probabilities: b and B, respectively. If the number or  
        dimensionality of b and B do not correspond, then select OPTIONS.A = 1.  
        This will automatically evaluate the most likely policy (combination of  
        controllable paths) to reproduce the predicted outcomes (i.e. that which  
        minimises variational free energy or maximises accuracy); as opposed to  
        using the path selected by the model.  
         
        scheme is designed for any allowable policies or control variables  
        specified in MDP.U. Constraints on allowable policies can limit the  
        numerics or combinatorics considerably. Further, the outcome space and  
        hidden states can be defined in terms of factors; corresponding to  
        sensory modalities and (functionally) segregated representations,  
        respectively. This means, for each factor or subset of hidden states  
        there are corresponding control states that determine the transition  
        probabilities. in this implementation, hidden factors are combined using  
        a Kronecker intensive product to enable exact Bayesian inference using  
        belief propagation (the Kronecker tensor form ensures that conditional  
        dependencies among hidden factors are evaluated).  
         
        In this belief propagation scheme, the next action is evaluated in terms  
        of the free energy expected under all subsequent actions until some time  
        horizon (specified by MDP.T). This expected free energy is accumulated  
        along all allowable paths or policies (see the subroutine spm_forward);  
        effectively, performing a deep tree search over future sequences of  
        actions. Because actions are conditionally independent of previous  
        actions, it is only necessary to update posterior beliefs over hidden  
        states at the current time point (using a Bayesian belief updating) and  
        then use the prior over actions (based upon expected free energy) to  
        select the next action. Previous actions are inferred under the posterior  
        beliefs over current states; i.e., inferred state transitions.  
         
        In brief, the agent encodes beliefs about hidden states in the past  
        conditioned on realised outcomes and actions. The resulting conditional  
        expectations determine the (path integral) of free energy that then  
        determines an empirical prior over the next action, from which the next  
        realised action sampled  
         
         
        If supplied with a structure array, this routine will automatically step  
        through the implicit sequence of epochs (implicit in the number of  
        columns of the array). If the array has multiple rows, each row will be  
        treated as a separate model or agent. This enables agents to communicate  
        through acting upon a common set of hidden factors, or indeed sharing the  
        same outcomes.  
         
        See also: spm_MDP, which uses multiple future states and a mean field  
        approximation for control states - but allows for different actions at  
        all times (as in control problems).  
         
        See also: spm_MDP_VB_X,  which is the corresponding variational message  
        passing scheme for fixed policies; i.e., ordered sequences of actions  
        that are specified a priori.  
         
        See also: spm_MDP_VB_XX,  which is the corresponding variational message  
        passing scheme for sophisticated policy searches under the assumption  
        that the generative process and model have the same structure  
         
         
       __________________________________________________________________________  
        Copyright (C) 2019 Wellcome Trust Centre for Neuroimaging  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/spm_MDP_VB_XXX.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("spm_MDP_VB_XXX", *args, **kwargs)
