from spm._runtime import Runtime


def spm_dem_ERP(*args, **kwargs):
    """
      simulated electrophysiological response based on conditional estimates  
        FORMAT [R] = spm_dem_ERP(qU,qU,...)  
        qU - conditional estimates of states  
        R  - summed response over peri-stimulus time  
         
        These simulated response assume that LFPs are generated by superficial  
        pyramidal cells that correspond to units encoding prediction error.  
        Peristimulus time histograms (PSTH) assume that states (U) are encoded  
        using a non-negative firing rate that is proportional to exp(U), using  
        an opponent system  
       __________________________________________________________________________  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/spm_dem_ERP.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("spm_dem_ERP", *args, **kwargs)
