from spm._runtime import Runtime


def _read_ricoh_header(*args, **kwargs):
    """
      READ_RICOH_HEADER reads the header information from continuous  
        or averaged MEG data generated by the Ricoh MEG system and software  
        and allows the data to be used in FieldTrip.  
         
        Use as  
         [hdr] = read_ricoh_header(filename)  
         
        This is a wrapper function around the functions  
        getRHdrSystem  
        getRHdrChannel  
        getRHdrAcqCond  
        getRHdrCoregist  
        getRHdrDigitize  
        getRHdrSource  
         
        See also READ_RICOH_DATA, READ_RICOH_EVENT  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_ricoh_header.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("read_ricoh_header", *args, **kwargs)
