from spm._runtime import Runtime


def _read_yokogawa_data(*args, **kwargs):
    """
      READ_YOKAGAWA_DATA reads continuous, epoched or averaged MEG data  
        that has been generated by the Yokogawa MEG system and software  
        and allows that data to be used in combination with FieldTrip.  
         
        Use as  
          [dat] = read_yokogawa_data(filename, hdr, begsample, endsample, chanindx)  
         
        This is a wrapper function around the functions  
          GetMeg160ContinuousRawDataM  
          GetMeg160EvokedAverageDataM  
          GetMeg160EvokedRawDataM  
         
        See also READ_YOKOGAWA_HEADER, READ_YOKOGAWA_EVENT  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_yokogawa_data.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("read_yokogawa_data", *args, **kwargs)
