from spm._runtime import Runtime


def ft_prepare_headmodel(*args, **kwargs):
    """
      FT_PREPARE_HEADMODEL constructs a volume conduction model from the geometry  
        of the head. The volume conduction model specifies how currents that are  
        generated by sources in the brain, e.g. dipoles, are propagated through the  
        tissue and how these result in externally measureable EEG potentials or MEG  
        fields.  
         
        FieldTrip implements a variety of forward solutions, partially with internal  
        code and some of them using external toolboxes or executables. Each of the  
        forward solutions requires a set of configuration options which are listed  
        below. This function takes care of all the preparatory steps in the  
        construction of the volume conduction model and sets it up so that  
        subsequent computations are efficient and fast.  
         
        Use as  
          headmodel = ft_prepare_headmodel(cfg)               or  
          headmodel = ft_prepare_headmodel(cfg, mesh)         with the output of FT_PREPARE_MESH or FT_READ_HEADSHAPE  
          headmodel = ft_prepare_headmodel(cfg, seg)          with the output of FT_VOLUMESEGMENT  
          headmodel = ft_prepare_headmodel(cfg, elec)         with the output of FT_READ_SENS  
          headmodel = ft_prepare_headmodel(cfg, sourcemodel)  with the output of FT_PREPARE_LEADFIELD  
         
        In general the input to this function is a geometrical description of the  
        shape of the head and a description of the electrical conductivity. The  
        geometrical description can be a set of surface points obtained from  
        fT_READ_HEADSHAPE, a surface mesh that was obtained from FT_PREPARE_MESH or  
        a segmented anatomical MRI that was obtained from FT_VOLUMESEGMENT.  
         
        The cfg argument is a structure that can contain:  
          cfg.method         = string that specifies the forward solution, see below  
          cfg.conductivity   = a number or a vector containing the conductivities of the compartments  
          cfg.tissue         = a string or integer, to be used in combination with a 'seg' for the  
                                 second intput. If 'brain', 'skull', and 'scalp' are fields  
                                 present in 'seg', then cfg.tissue need not be specified, as  
                                 these are defaults, depending on cfg.method. Otherwise,  
                                 cfg.tissue should refer to which field(s) of seg should be used.  
         
        For EEG the following methods are available:  
          singlesphere       analytical single sphere model  
          concentricspheres  analytical concentric sphere model with up to 4 spheres  
          openmeeg           boundary element method, based on the OpenMEEG software  
          bemcp              boundary element method, based on the implementation from Christophe Phillips  
          dipoli             boundary element method, based on the implementation from Thom Oostendorp  
          asa                boundary element method, based on the (commercial) ASA software  
          simbio             finite element method, based on the SimBio software  
          duneuro            finite element method, based on duneuro software  
          fns                finite difference method, based on the FNS software  
          infinite           electric dipole in an infinite homogenous medium  
          halfspace          infinite homogenous medium on one side, vacuum on the other  
          besa               finite element leadfield matrix from BESA  
          interpolate        interpolate the precomputed leadfield  
         
        For MEG the following methods are available:  
          openmeeg           boundary element method, based on the OpenMEEG software  
          singlesphere       analytical single sphere model  
          localspheres       local spheres model for MEG, one sphere per channel  
          singleshell        realisically shaped single shell approximation, based on the implementation from Guido Nolte  
          infinite           magnetic dipole in an infinite vacuum  
         
        Each specific method has its own specific configuration options which are listed below.  
         
        BEMCP, DIPOLI, OPENMEEG  
          cfg.tissue            see above; in combination with 'seg' input  
          cfg.isolatedsource    (optional)  
          cfg.tempdir           (optional)  
          cfg.tempname          (optional)  
         
        CONCENTRICSPHERES  
          cfg.tissue            see above; in combination with 'seg' input  
          cfg.order             (optional)  
          cfg.fitind            (optional)  
         
        LOCALSPHERES  
          cfg.grad  
          cfg.tissue            see above; in combination with 'seg' input; default options are 'brain' or 'scalp'  
          cfg.feedback          (optional)  
          cfg.radius            (optional)  
          cfg.maxradius         (optional)  
          cfg.baseline          (optional)  
         
        SIMBIO  
          cfg.conductivity  
         
        DUNEURO  
          cfg.conductivity      An array with the conductivities must be provided. (see above)  
          cfg.grid_filename     Alternatively,  a filename for the grid and a filename for the conductivities can be passed.  
          cfg.tensors_filename  "  
          cfg.duneuro_settings  (optional) Additional settings can be provided for duneuro (see http://www.duneuro.org).  
         
        SINGLESHELL  
          cfg.tissue            see above; in combination with 'seg' input; default options are 'brain' or 'scalp'  
          cfg.order             (optional)  
         
        SINGLESPHERE  
          cfg.tissue            see above; in combination with 'seg' input; default options are 'brain' or 'scalp'; must be only 1 value  
         
        INTERPOLATE  
           cfg.outputfile       (required) string, filename prefix for the output files  
         
        BESA  
          cfg.headmodel         (required) string, filename of precomputed FEM leadfield  
          cfg.elec              (required) structure with electrode positions or filename, see FT_READ_SENS  
          cfg.outputfile        (required) string, filename prefix for the output files  
         
        FNS  
          cfg.tissue  
          cfg.tissueval  
          cfg.conductivity  
          cfg.elec  
          cfg.grad  
          cfg.transform  
         
        HALFSPACE  
          cfg.point  
          cfg.submethod         (optional)  
         
        More details for each of the specific methods can be found in the corresponding  
        low-level function which is called FT_HEADMODEL_XXX where XXX is the method  
        of choise.  
         
        See also FT_PREPARE_MESH, FT_PREPARE_SOURCEMODEL, FT_PREPARE_LEADFIELD,  
        FT_HEADMODEL_BEMCP, FT_HEADMODEL_ASA, FT_HEADMODEL_DIPOLI,  
        FT_HEADMODEL_SIMBIO, FT_HEADMODEL_FNS, FT_HEADMODEL_HALFSPACE,  
        FT_HEADMODEL_INFINITE, FT_HEADMODEL_OPENMEEG, FT_HEADMODEL_SINGLESPHERE,  
        FT_HEADMODEL_CONCENTRICSPHERES, FT_HEADMODEL_LOCALSPHERES,  
        FT_HEADMODEL_SINGLESHELL, FT_HEADMODEL_INTERPOLATE, FT_HEADMODEL_DUNEURO  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/ft_prepare_headmodel.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("ft_prepare_headmodel", *args, **kwargs)
