from spm._runtime import Runtime


def ft_sourceplot_interactive(*args, **kwargs):
    """
      FT_SOURCEPLOT_INTERACTIVE provides a rapid way to plot 3D surface  
        renderings of pos_time or pos_freq functional data, and interactively  
        explore them. One figure is created with surface plots of the individual  
        conditions, and by default a plot of the functional data averaged over  
        the entire cortex is created over time (or frequency). Users can click in  
        the line graph to shift the time point for which the functional data is  
        shown in the surface plots. Additionally, users can Shift+Click in the  
        surface plots to add a "virtual electrode", for which a new line graph  
        figure will be created.  
         
        Input data needs to be source+mesh, so has to contain a tri, pos, and one  
        functional field plus a time- or frequency axis.  
         
        Configuration options (all optional) include:  
          cfg.parameter       = string, functional parameter to plot. Default = 'pow'.  
          cfg.data_labels     = cell array of strings, describing each data input argument. Default =  
                                {'Input 1',...,'Input N'}  
          cfg.time_label      = string, xlabel for line graphs of functional data. Default = 'Time  
                                (s)' for data with time dimension, 'Frequency (Hz)' for data with  
                                freq dimension.  
          cfg.pow_label       = string, ylabel for line graphs of functional data. Default = 'Current  
                                density (a.u.)'.  
          cfg.clim            = string, or 2-element numeric vector specifying the color limits  
                                (see 'has_diff' option below).  
          cfg.has_diff        = 1x1 logical, default = false. If true, this function will treat the  
                                last data input argument slightly differently from the ones before  
                                it, which is useful in case you wish to plot a difference score in  
                                addition to two per-condition current densities. Specifically, if  
                                true, (1) the line plots generated by this function will not include  
                                the last data input argument; and (2) the colours limits for the  
                                surface plot corresponding to the last data input argument will be  
                                set symmetrically around zero (if cfg.clim is left empty - see  
                                above).  
          cfg.atlas           = string, filename of an atlas to use in generating title strings for  
                                the line graphs corresponding to 'virtual electrodes' placed on the  
                                surface plots. Atlas must be in the coordinate system of the  
                                specified data input arguments. See FT_READ_ATLAS.  
         
        Example use:  
          cfg = [];  
          cfg.data_labels = {'Congruent', 'Incongruent'};  
          ft_sourceplot_interactive(cfg, sourceFC, sourceFIC);  
         
        See also FT_SOURCEPLOT, FT_SOURCEMOVIE  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/ft_sourceplot_interactive.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("ft_sourceplot_interactive", *args, **kwargs)
