from spm._runtime import Runtime


def DEM_demo_psychosis(*args, **kwargs):
    """
      This demonstration routine illustrates the use of attractors in dynamical  
        systems theory to explain fluctuations in longitudinal data, such as  
        symptom scores. The generative model is based upon a Lorenz system that  
        features a number of attractors; namely, fixed point attractors  
        (modelling conditions that resolve), quasi-periodic attractors that can  
        model cyclothymic conditions, and chaotic attractors that show a more  
        itinerant time course. As with the model based upon stochastic chaos, the  
        Lorenz system generates fluctuations in a low dimensional space of  
        physiological variables that, in turn, generate psychological states,  
        which are then thresholded to generate symptom scores. In this example,  
        there are three physiological states, two psychological states and two  
        kinds of symptom score (generated by using a soft threshold function of  
        psychological states). The parameters of this model range from the  
        parameters of the dynamical attractor that determine the underlying time  
        course of some synthetic (e.g., schizoaffective) disorder through to the  
        parameters of the likelihood mapping to symptom scores – and the initial  
        states.  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/DEM_demo_psychosis.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """

    return Runtime.call("DEM_demo_psychosis", *args, **kwargs, nargout=0)
