from spm.__wrapper__ import Runtime


def _read_yokogawa_data_new(*args, **kwargs):
    """
      READ_YOKAGAWA_DATA_NEW reads continuous, epoched or averaged MEG data  
        that has been generated by the Yokogawa MEG system and software  
        and allows that data to be used in combination with FieldTrip.  
         
        Use as  
          [dat] = read_yokogawa_data_new(filename, hdr, begsample, endsample, chanindx)  
         
        This is a wrapper function around the function  
        getYkgwData  
         
        See also READ_YOKOGAWA_HEADER_NEW, READ_YOKOGAWA_EVENT  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_yokogawa_data_new.m )

    Copyright (C) 2024-2024 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_yokogawa_data_new", *args, **kwargs)
