from spm.__wrapper__ import Runtime


def _read_yokogawa_event(*args, **kwargs):
    """
      READ_YOKOGAWA_EVENT reads event information from continuous,  
        epoched or averaged MEG data that has been generated by the Yokogawa  
        MEG system and software and allows those events to be used in  
        combination with FieldTrip.  
         
        Use as  
          [event] = read_yokogawa_event(filename)  
         
        See also READ_YOKOGAWA_HEADER, READ_YOKOGAWA_DATA  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_yokogawa_event.m )

    Copyright (C) 2024-2024 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_yokogawa_event", *args, **kwargs)
