from spm.__wrapper__ import Runtime


def DEM_cells(*args, **kwargs):
    """
      This demo illustrates self-organisation in an ensemble of (sixteen) cells  
        using the same principles described in DEM_morphogenesis, but using a  
        simpler generative model. Overall, the dynamics of these simulations show  
        how one can prescribe a point attractor for each constituent of an  
        ensemble that endows the ensemble with a point attractor to which it  
        converges. In this example, we consider the special case where the point  
        attractor is itself a Markov blanket. In other words, cells come to  
        acquire dependencies, in terms of intracellular signalling, that conform  
        to a simple Markov blanket with intrinsic or internal cells, surrounded  
        by active cells that are, in turn, surrounded by sensory cells. This  
        organisation rests upon intracellular signals and active inference using  
        generalised (second-order) variational filtering. In brief, the hidden  
        causes driving action (migration and signalling) are expectations about  
        cell type. These expectations are optimised using sensory signals;  
        namely, the signals generated by other cells. By equipping each cell with  
        prior beliefs about what it would sense if it was a particular cell type  
        (i.e., internal, active or sensory), they act (i.e., move and signal) to  
        behave and infer their role in an ensemble of cells that itself has a  
        Markov blanket. In a DEM_cells_cells.m, we use this first-order scheme to  
        simulate the hierarchical emergence of Markov blankets; i.e., ensembles  
        of cells that can be one of three types at the local level; independently  
        of their time at the global level.  
       __________________________________________________________________________  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/DEM_cells.m )

    Copyright (C) 2024-2024 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("DEM_cells", *args, **kwargs)
