from spm.__wrapper__ import Runtime


def spm_MDP_VB_XX(*args, **kwargs):
    """
      active inference and learning using belief propagation  
        FORMAT [MDP] = spm_MDP_VB_XX(MDP,OPTIONS)  
         
        Input; MDP(m,n)       - structure array of m models over n epochs  
        MDP.U(P,F)            - P allowable actions over F factors  
        MDP.T                 - number of outcomes  
         
        MDP.A{G}(O,N1,...,NF) - likelihood of O outcomes given hidden states  
        MDP.B{F}(NF,NF,PF)    - transitions among states under PF control states  
        MDP.C{G}(O,T)         - prior probabilities over final outcomes (log preferences)  
        MDP.D{F}(NF,1)        - prior probabilities over initial states (Dirichlet counts)   
        MDP.E(P,1)            - prior probabilities over policies (Dirichlet counts)  
         
        MDP.a{G}              - concentration parameters for A   
        MDP.b{F}              - concentration parameters for B  
        MDP.c{G}              - concentration parameters for C  
        MDP.d{F}              - concentration parameters for D  
        MDP.e{P}              - concentration parameters for E  
         
        optional:  
        MDP.s(F,T)            - matrix of true states - for each hidden factor  
        MDP.o(G,T)            - matrix of outcomes    - for each outcome modality  
        or .O{G}(O,T)         - likelihood matrix     - for each outcome modality  
        MDP.u(F,T - 1)        - vector of actions     - for each hidden factor  
         
        MDP.alpha             - precision - action selection [512]  
        MDP.chi               - Occams window for deep updates  
        MDP.eta               - learning rate for model parameters  
        MDP.N                 - depth of deep policy search [N <= T]  
         
        MDP.demi.C            - Mixed model: cell array of true causes (DEM.C)  
        MDP.demi.U            - Bayesian model average (DEM.U) see: spm_MDP_DEM  
        MDP.link              - link array to generate outcomes from  
                                subordinate MDP; for deep (hierarchical) models  
         
        MDP.n(O,T)            - outputs for modality O at time T are generated by  
                                agent n(O,T); unless n(O,T) = 0, when outputs  
                                are generated by the agents states  
        MDP.m(F)              - states for factor F are generated for agent m(F);  
                                unless m(F) = 0, when states are updated for the  
                                agent in question  
          
        OPTIONS.plot          - switch to suppress graphics:  (default: [0])  
        OPTIONS.D             - switch to update initial states over epochs  
        OPTIONS.BMR           - Bayesian model reduction for multiple trials  
                                see: spm_MDP_VB_sleep(MDP,BMR)  
        Outputs:  
         
        MDP.P(N1,...,NF,T)    - action probability  
        MDP.X{F}(NF,T)        - conditional expectations over hidden states  
        MDP.R(P,T)            - conditional expectations over policies  
         
        MDP.F(t)        - ELBO or (-ve) free energy (states and policies) over t  
        actions  
         
        MDP.un          - simulated neuronal encoding of hidden states  
        MDP.xn          - simulated neuronal encoding of policies  
        MDP.wn          - simulated neuronal encoding of precision (tonic)  
        MDP.dn          - simulated dopamine responses (phasic)  
         
        This routine provides solutions of active inference (minimisation of  
        variational free energy) using a generative model based upon a Markov  
        decision process. The model and inference scheme is formulated in  
        discrete space and time. This means that the generative model (and  
        process) are hidden Markov models whose dynamics are given by transition  
        probabilities among states and the likelihood corresponds to a particular  
        outcome conditioned upon hidden states.  
         
        This implementation equips agents with the prior beliefs that they will  
        maximise expected free energy. Variational free energy can be interpreted  
        in several ways - most intuitively as minimising the KL divergence  
        between predicted and preferred outcomes (specified as prior beliefs) -  
        while simultaneously minimising ambiguity.  
         
        This particular scheme is designed for any allowable policies or control  
        variables specified in MDP.U. Constraints on allowable policies can limit  
        the numerics or combinatorics considerably. Further, the outcome space  
        and hidden states can be defined in terms of factors; corresponding to  
        sensory modalities and (functionally) segregated representations,  
        respectively. This means, for each factor or subset of hidden states  
        there are corresponding control states that determine the transition  
        probabilities. in this implementation, hidden factors are combined using  
        a Kronecker intensive product to enable exact Bayesian inference using  
        belief propagation (the Kronecker tensor form ensures that conditional  
        dependencies among hidden factors are evaluated).  
         
        In this belief propagation scheme, the next action is evaluated in terms  
        of the free energy expected under all subsequent actions until some time  
        horizon (specified by MDP.T). This expected free energy is accumulated  
        along all allowable paths or policies (see the subroutine spm_forward);  
        effectively, performing a deep tree search over future sequences of  
        actions. Because actions are conditionally independent of previous  
        actions, it is only necessary to update posterior beliefs over hidden  
        states at the current time point (using a Bayesian belief updating) and  
        then use the prior over actions (based upon expected free energy) to  
        select the next action. Previous actions are realised variables and are  
        used when evaluating the posterior beliefs over current states.  
         
        In brief, the agent encodes beliefs about hidden states in the past  
        conditioned on realised outcomes and actions. The resulting conditional  
        expectations determine the (path integral) of free energy that then  
        determines an empirical prior over the next action, from which the next  
        realised action sampled  
         
        In addition to state estimation and policy selection, the scheme also  
        updates model parameters; including the state transition matrices,  
        mapping to outcomes and the initial state. This is useful for learning  
        the context. Likelihood and prior probabilities can be specified in terms  
        of concentration parameters (of a Dirichlet distribution (a,b,c,..). If  
        the corresponding (A,B,C,..) are supplied, they will be used to generate  
        outcomes.  
         
        If supplied with a structure array, this routine will automatically step  
        through the implicit sequence of epochs (implicit in the number of  
        columns of the array). If the array has multiple rows, each row will be  
        treated as a separate model or agent. This enables agents to communicate  
        through acting upon a common set of hidden factors, or indeed sharing the  
        same outcomes.  
         
        See also: spm_MDP, which uses multiple future states and a mean field  
        approximation for control states - but allows for different actions at  
        all times (as in control problems).  
         
        See also: spm_MDP_VB_X,  which is the corresponding variational message  
        passing scheme for fixed policies; i.e., ordered sequences of actions  
        that are specified a priori.  
       __________________________________________________________________________  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/spm_MDP_VB_XX.m )

    Copyright (C) 2024-2024 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_MDP_VB_XX", *args, **kwargs)
