from spm.__wrapper__ import Runtime


def pm_brain_mask(*args, **kwargs):
    """
      Calculate a brain mask  
        FORMAT bmask = pm_brain_mask(P,flags)  
         
        P - is a single pointer to a single image  
         
        flags - structure containing various options  
                fwhm     - fwhm of smoothing kernel for generating mask  
                nerode   - number of erosions  
                thresh   - threshold for smoothed mask  
                ndilate  - number of dilations  
         
       __________________________________________________________________________  
         
        Inputs  
        A single *.img conforming to SPM data format (see 'Data Format').  
         
        Outputs  
        Brain mask in a matrix  
       __________________________________________________________________________  
         
        The brain mask is generated by segmenting the image into GM, WM and CSF,  
        adding these components together then thresholding above zero.  
        A morphological opening is performed to get rid of stuff left outside of  
        the brain. Any leftover holes are filled.  
       __________________________________________________________________________  
      

    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/FieldMap/pm_brain_mask.m )

    Copyright (C) 2024-2024 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("pm_brain_mask", *args, **kwargs)
