from mpython import Runtime


def _read_brainstorm_event(*args, **kwargs):
    """
      READ_BRAINSTORM_EVENT reads the event information from .EEG files
        that have been generated by the Nihon Kohden system. The function
        constitutes a wrapper around BrainStorm3 functionalities

        Use as
          [event] = read_brainstorm_event(filename)

        See also READ_NK1200_HEADER, READ_NK1200_DATA


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_brainstorm_event.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_brainstorm_event", *args, **kwargs)
