from mpython import Runtime


def _read_brainstorm_header(*args, **kwargs):
    """
      READ_BRAINSTORM_HEADER reads the header information from .EEG files
        that have been generated by the Nihon Kohden system. The function
        constitutes a wrapper around BrainStorm3 functionalities

        Use as
          [hdr] = read_brainstorm_header(filename)

        See also READ_BRAINSTORM_DATA, READ_BRAINSTORM_EVENT


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_brainstorm_header.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_brainstorm_header", *args, **kwargs)
