from mpython import Runtime


def _read_ctf_pos(*args, **kwargs):
    """
      READ_CTF_POS reads Polhemus file created with the CTF digitizer application

        Use as
          [fid, pnt, label] = read_ctf_pos(filename)
        Input:
        filename  - Polhemus ASCII file containing digitized points

        Output:
        fid   - fiducial         locations of fiducials
        pnt   - sensor/headshape locations
        label - labels of the fiducials

        IMPORTANT: Note that Polhemus data files should be -ASCII files with
        extension .pos generated by the CTF digitizer


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_ctf_pos.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_ctf_pos", *args, **kwargs)
