from mpython import Runtime


def _read_ricoh_event(*args, **kwargs):
    """
      READ_RICOH_EVENT reads event information from continuous,
        epoched or averaged MEG data that has been generated by the Ricoh
        MEG system and software and allows those events to be used in
        combination with FieldTrip.

        Use as
          [event] = read_ricoh_event(filename)

        See also READ_RICOH_HEADER, READ_RICOH_DATA


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_ricoh_event.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_ricoh_event", *args, **kwargs)
