from mpython import Runtime


def _read_yokogawa_header(*args, **kwargs):
    """
      READ_YOKOGAWA_HEADER reads the header information from continuous,
        epoched or averaged MEG data that has been generated by the Yokogawa
        MEG system and software and allows that data to be used in combination
        with FieldTrip.

        Use as
         [hdr] = read_yokogawa_header(filename)

        This is a wrapper function around the functions
          GetMeg160SystemInfoM
          GetMeg160ChannelCountM
          GetMeg160ChannelInfoM
          GetMeg160CalibInfoM
          GetMeg160AmpGainM
          GetMeg160DataAcqTypeM
          GetMeg160ContinuousAcqCondM
          GetMeg160EvokedAcqCondM

        See also READ_YOKOGAWA_DATA, READ_YOKOGAWA_EVENT


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/fileio/private/read_yokogawa_header.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("read_yokogawa_header", *args, **kwargs)
