from mpython import Runtime


def _cortex_light(*args, **kwargs):
    """
      This returns a predefined color as [red green blue] values
          red               = [255   0   0]/255;
          green             = [  0 192   0]/255;
          blue              = [  0   0 255]/255;
          magenta           = [255 255   0]/255;
          cyan              = [  0 255 255]/255;
          yellow            = [255 255   0]/255;
          white             = [255 255 255]/255;
          black             = [  0   0   0]/255;

          skull             = [140  85  85]/255
          cortex            = [255 213 119]/255;
          cortex_light      = [199 194 169]/255;
          cortex_dark       = [100  97  85]/255;
          skin              = [249 223 192]/255;
          skin_light        = [249 223 192]/255;
          skin_medium_light = [225 194 158]/255;
          skin_medium       = [188 142 106]/255;
          skin_medium_dark  = [155 102	65]/255;
          skin_dark         = [ 91  71  61]/255;


    [Matlab code]( https://github.com/spm/spm/blob/main/external/fieldtrip/plotting/private/cortex_light.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("cortex_light", *args, **kwargs)
