from mpython import (
    Runtime,
    MatlabClass,
    MatlabFunction,
    Cell,
    Struct,
    Array,
    SparseArray,
)
from ._version import __version__
from .file_array import file_array
from .gifti import gifti
from .meeg import meeg
from .nifti import nifti
from .slover import slover
from .xmltree import xmltree
from .__compat import (
    loadxml,
    savexml,
    spm_add,
    spm_adjmean_fmri_ui,
    spm_adjmean_ui,
    spm_atranspa,
    spm_chi2_plot,
    spm_digamma,
    spm_dirichlet,
    spm_eeval,
    spm_fMRI_design_show,
    spm_imcalc_ui,
    spm_load_float,
    spm_matlab_version_chk,
    spm_mean,
    spm_mean_ui,
    spm_read_hdr,
    spm_resss,
    spm_spm_ui,
    spm_tbx_config2cfg,
)
from .__config import (
    cfg_mlbatch_appcfg,
    spm_cfg,
    spm_cfg_bbox,
    spm_cfg_bms_map,
    spm_cfg_cat,
    spm_cfg_cdir,
    spm_cfg_checkreg,
    spm_cfg_con,
    spm_cfg_coreg,
    spm_cfg_dcm_bms,
    spm_cfg_dcm_est,
    spm_cfg_dcm_fmri,
    spm_cfg_dcm_meeg,
    spm_cfg_dcm_peb,
    spm_cfg_deface,
    spm_cfg_deformations,
    spm_cfg_dicom,
    spm_cfg_disp,
    spm_cfg_ecat,
    spm_cfg_eeg,
    spm_cfg_eeg_artefact,
    spm_cfg_eeg_average,
    spm_cfg_eeg_avgfreq,
    spm_cfg_eeg_avgtime,
    spm_cfg_eeg_bc,
    spm_cfg_eeg_cfc,
    spm_cfg_eeg_channel_selector,
    spm_cfg_eeg_collapse_timefreq,
    spm_cfg_eeg_combineplanar,
    spm_cfg_eeg_contrast,
    spm_cfg_eeg_convert,
    spm_cfg_eeg_convert2images,
    spm_cfg_eeg_copy,
    spm_cfg_eeg_correct_sensor_data,
    spm_cfg_eeg_crop,
    spm_cfg_eeg_delete,
    spm_cfg_eeg_dipfit,
    spm_cfg_eeg_downsample,
    spm_cfg_eeg_epochs,
    spm_cfg_eeg_filter,
    spm_cfg_eeg_firstlevel,
    spm_cfg_eeg_fuse,
    spm_cfg_eeg_grandmean,
    spm_cfg_eeg_inv_coregshift,
    spm_cfg_eeg_inv_extract,
    spm_cfg_eeg_inv_headmodel,
    spm_cfg_eeg_inv_headmodelhelmet,
    spm_cfg_eeg_inv_invert,
    spm_cfg_eeg_inv_invertiter,
    spm_cfg_eeg_inv_mix,
    spm_cfg_eeg_inv_optimize,
    spm_cfg_eeg_inv_patchdef,
    spm_cfg_eeg_inv_post,
    spm_cfg_eeg_inv_prepro,
    spm_cfg_eeg_inv_priors,
    spm_cfg_eeg_inv_results,
    spm_cfg_eeg_inv_sensorshift,
    spm_cfg_eeg_inv_simulate,
    spm_cfg_eeg_merge,
    spm_cfg_eeg_momentfit,
    spm_cfg_eeg_montage,
    spm_cfg_eeg_opmsetup,
    spm_cfg_eeg_prepare,
    spm_cfg_eeg_reduce,
    spm_cfg_eeg_regressors,
    spm_cfg_eeg_remove_bad_trials,
    spm_cfg_eeg_review,
    spm_cfg_eeg_shp_distort,
    spm_cfg_eeg_shp_gainmat,
    spm_cfg_eeg_spatial_confounds,
    spm_cfg_eeg_tf,
    spm_cfg_eeg_tf_rescale,
    spm_cfg_exp_frames,
    spm_cfg_factorial_design,
    spm_cfg_fmri_data,
    spm_cfg_fmri_design,
    spm_cfg_fmri_est,
    spm_cfg_fmri_spec,
    spm_cfg_imcalc,
    spm_cfg_md,
    spm_cfg_mfx,
    spm_cfg_minc,
    spm_cfg_model_review,
    spm_cfg_norm,
    spm_cfg_opm_create,
    spm_cfg_opm_epoch_trigger,
    spm_cfg_opm_read_lvm,
    spm_cfg_opm_synth_gradiometer,
    spm_cfg_parrec,
    spm_cfg_ppi,
    spm_cfg_preproc8,
    spm_cfg_print,
    spm_cfg_realign,
    spm_cfg_realignunwarp,
    spm_cfg_render,
    spm_cfg_reorient,
    spm_cfg_results,
    spm_cfg_sendmail,
    spm_cfg_setlevel,
    spm_cfg_smooth,
    spm_cfg_split,
    spm_cfg_st,
    spm_cfg_static_tools,
    spm_cfg_tissue_volumes,
    spm_cfg_voi,
    spm_make_standalone,
    spm_markdown,
    spm_rewrite_job,
    spm_run_bms_map,
    spm_run_bms_vis,
    spm_run_con,
    spm_run_coreg,
    spm_run_dcm_bms,
    spm_run_dcm_bms_vis,
    spm_run_dicom,
    spm_run_factorial_design,
    spm_run_fmri_data,
    spm_run_fmri_est,
    spm_run_fmri_spec,
    spm_run_norm,
    spm_run_realign,
    spm_run_realignunwarp,
    spm_run_reorient,
    spm_run_results,
    spm_run_setlevel,
    spm_run_smooth,
    spm_run_st,
    spm_run_tissue_volumes,
    spm_run_voi,
)
from .__external import (
    bemcp_example,
    addCTFtrial,
    getCTFdata,
    readCPersist,
    readCTFMRI,
    readCTFds,
    readCTFhdm,
    setCTFDataBalance,
    writeCTFMRI,
    writeCTFds,
    writeCTFhdm,
    writeMarkerFile,
    writeRes4,
    read_eep_avr,
    read_eep_cnt,
    read_eep_rej,
    read_eep_trg,
    read_eep_trial,
    write_eep_avr,
    write_eep_cnt,
    besa2fieldtrip,
    bis2fieldtrip,
    ft_connectivity_cancorr,
    ft_connectivity_corr,
    ft_connectivity_csd2transfer,
    ft_connectivity_dtf,
    ft_connectivity_granger,
    ft_connectivity_mim,
    ft_connectivity_mutualinformation,
    ft_connectivity_pdc,
    ft_connectivity_plm,
    ft_connectivity_powcorr_ortho,
    ft_connectivity_ppc,
    ft_connectivity_psi,
    ft_connectivity_wpli,
    data2bids,
    edf2fieldtrip,
    uimage,
    uimagesc,
    rgb2hsv,
    boxcar,
    flattopwin,
    hanning,
    hilbert,
    binocdf,
    binopdf,
    common_size,
    mvnrnd,
    nanvar,
    range_,
    tcdf,
    tinv,
    fieldtrip2besa,
    fieldtrip2bis,
    fieldtrip2ctf,
    fieldtrip2fiff,
    fieldtrip2homer,
    fieldtrip2spss,
    ft_chantype,
    ft_chanunit,
    ft_create_buffer,
    ft_destroy_buffer,
    ft_filetype,
    ft_filter_event,
    ft_flush_data,
    ft_flush_event,
    ft_flush_header,
    ft_poll_buffer,
    ft_read_atlas,
    ft_read_cifti,
    ft_read_data,
    ft_read_event,
    ft_read_header,
    ft_read_headmodel,
    ft_read_headshape,
    ft_read_json,
    ft_read_mri,
    ft_read_sens,
    ft_read_spike,
    ft_read_tsv,
    ft_read_vol,
    ft_write_cifti,
    ft_write_data,
    ft_write_event,
    ft_write_headshape,
    ft_write_json,
    ft_write_mri,
    ft_write_sens,
    ft_write_spike,
    ft_write_tsv,
    ft_apply_montage,
    ft_compute_leadfield,
    ft_convert_units,
    ft_determine_units,
    ft_estimate_units,
    ft_headmodel_asa,
    ft_headmodel_bemcp,
    ft_headmodel_concentricspheres,
    ft_headmodel_dipoli,
    ft_headmodel_duneuro,
    ft_headmodel_fns,
    ft_headmodel_halfspace,
    ft_headmodel_infinite,
    ft_headmodel_interpolate,
    ft_headmodel_localspheres,
    ft_headmodel_openmeeg,
    ft_headmodel_simbio,
    ft_headmodel_singleshell,
    ft_headmodel_singlesphere,
    ft_headmodel_slab,
    ft_headmodeltype,
    ft_inside_headmodel,
    ft_prepare_vol_sens,
    ft_senslabel,
    ft_senstype,
    ft_sourcedepth,
    ft_analysispipeline,
    ft_annotate,
    ft_anonymizedata,
    ft_appenddata,
    ft_appendfreq,
    ft_appendlayout,
    ft_appendsens,
    ft_appendsource,
    ft_appendspike,
    ft_appendtimelock,
    ft_artifact_clip,
    ft_artifact_ecg,
    ft_artifact_eog,
    ft_artifact_jump,
    ft_artifact_muscle,
    ft_artifact_nan,
    ft_artifact_threshold,
    ft_artifact_tms,
    ft_artifact_zvalue,
    ft_audiovideobrowser,
    ft_badchannel,
    ft_baddata,
    ft_badsegment,
    ft_channelnormalise,
    ft_channelrepair,
    ft_clusterplot,
    ft_combineplanar,
    ft_componentanalysis,
    ft_conjunctionanalysis,
    ft_connectivityanalysis,
    ft_connectivityplot,
    ft_connectivitysimulation,
    ft_crossfrequencyanalysis,
    ft_databrowser,
    ft_defacemesh,
    ft_defacevolume,
    ft_defaults,
    ft_definetrial,
    ft_denoise_amm,
    ft_denoise_dssp,
    ft_denoise_hfc,
    ft_denoise_pca,
    ft_denoise_prewhiten,
    ft_denoise_ssp,
    ft_denoise_sss,
    ft_denoise_synthetic,
    ft_denoise_tsr,
    ft_detect_movement,
    ft_dipolefitting,
    ft_dipolesimulation,
    ft_electrodeplacement,
    ft_electroderealign,
    ft_electrodermalactivity,
    ft_eventtiminganalysis,
    ft_examplefunction,
    ft_freqanalysis,
    ft_freqanalysis_mvar,
    ft_freqbaseline,
    ft_freqdescriptives,
    ft_freqgrandaverage,
    ft_freqinterpolate,
    ft_freqsimulation,
    ft_freqstatistics,
    ft_geometryplot,
    ft_globalmeanfield,
    ft_headcircumference,
    ft_headmovement,
    ft_heartrate,
    ft_interactiverealign,
    ft_interpolatenan,
    ft_lateralizedpotential,
    ft_layoutplot,
    ft_math,
    ft_megplanar,
    ft_megrealign,
    ft_meshrealign,
    ft_movieplotER,
    ft_movieplotTFR,
    ft_multiplotCC,
    ft_multiplotER,
    ft_multiplotTFR,
    ft_mvaranalysis,
    ft_neighbourplot,
    ft_networkanalysis,
    ft_prepare_headmodel,
    ft_prepare_layout,
    ft_prepare_leadfield,
    ft_prepare_mesh,
    ft_prepare_montage,
    ft_prepare_neighbours,
    ft_prepare_sourcemodel,
    ft_preprocessing,
    ft_recodeevent,
    ft_redefinetrial,
    ft_regressconfound,
    ft_rejectartifact,
    ft_rejectcomponent,
    ft_rejectvisual,
    ft_removetemplateartifact,
    ft_reproducescript,
    ft_resampledata,
    ft_respiration,
    ft_scalpcurrentdensity,
    ft_singleplotER,
    ft_singleplotTFR,
    ft_sliceinterp,
    ft_sourceanalysis,
    ft_sourcedescriptives,
    ft_sourcegrandaverage,
    ft_sourceinterpolate,
    ft_sourcemovie,
    ft_sourceparcellate,
    ft_sourceplot,
    ft_sourceplot_interactive,
    ft_sourcestatistics,
    ft_sourcewrite,
    ft_statistics_analytic,
    ft_statistics_crossvalidate,
    ft_statistics_montecarlo,
    ft_statistics_mvpa,
    ft_statistics_stats,
    ft_steadystatesimulation,
    ft_stratify,
    ft_timelockanalysis,
    ft_timelockbaseline,
    ft_timelockgrandaverage,
    ft_timelocksimulation,
    ft_timelockstatistics,
    ft_topoplotCC,
    ft_topoplotER,
    ft_topoplotIC,
    ft_topoplotTFR,
    ft_virtualchannel,
    ft_volumebiascorrect,
    ft_volumedownsample,
    ft_volumelookup,
    ft_volumenormalise,
    ft_volumerealign,
    ft_volumereslice,
    ft_volumesegment,
    ft_volumewrite,
    ft_wizard,
    homer2fieldtrip,
    imotions2fieldtrip,
    ft_inverse_dics,
    ft_inverse_dipolefit,
    ft_inverse_eloreta,
    ft_inverse_harmony,
    ft_inverse_lcmv,
    ft_inverse_mne,
    ft_inverse_music,
    ft_inverse_pcc,
    ft_inverse_rv,
    ft_inverse_sam,
    ft_inverse_sloreta,
    loreta2fieldtrip,
    nutmeg2fieldtrip,
    ft_colormap,
    ft_plot_axes,
    ft_plot_box,
    ft_plot_cloud,
    ft_plot_crosshair,
    ft_plot_dipole,
    ft_plot_headmodel,
    ft_plot_headshape,
    ft_plot_layout,
    ft_plot_line,
    ft_plot_matrix,
    ft_plot_mesh,
    ft_plot_montage,
    ft_plot_ortho,
    ft_plot_patch,
    ft_plot_sens,
    ft_plot_slice,
    ft_plot_text,
    ft_plot_topo,
    ft_plot_topo3d,
    ft_plot_vector,
    ft_select_box,
    ft_select_channel,
    ft_select_point,
    ft_select_point3d,
    ft_select_range,
    ft_select_voxel,
    ft_uilayout,
    ft_preproc_bandpassfilter,
    ft_preproc_bandstopfilter,
    ft_preproc_baselinecorrect,
    ft_preproc_denoise,
    ft_preproc_derivative,
    ft_preproc_detrend,
    ft_preproc_dftfilter,
    ft_preproc_highpassfilter,
    ft_preproc_hilbert,
    ft_preproc_lowpassfilter,
    ft_preproc_medianfilter,
    ft_preproc_online_downsample_apply,
    ft_preproc_online_downsample_init,
    ft_preproc_online_filter_apply,
    ft_preproc_online_filter_init,
    ft_preproc_padding,
    ft_preproc_polyremoval,
    ft_preproc_rectify,
    ft_preproc_rereference,
    ft_preproc_resample,
    ft_preproc_slidingrange,
    ft_preproc_smooth,
    ft_preproc_standardize,
    spass2fieldtrip,
    ft_specest_hilbert,
    ft_specest_irasa,
    ft_specest_mtmconvol,
    ft_specest_mtmfft,
    ft_specest_neuvar,
    ft_specest_tfr,
    ft_specest_wavelet,
    spm2fieldtrip,
    det2x2,
    det3x3,
    getpid,
    inv2x2,
    inv3x3,
    lmoutr,
    ltrisect,
    meg_leadfield1,
    mtimes2x2,
    mtimes3x3,
    mxDeserialize,
    mxSerialize,
    plgndr,
    plinproj,
    ptriproj,
    read_16bit,
    read_24bit,
    read_ctf_shm,
    rfbevent,
    routlm,
    sandwich2x2,
    sandwich3x3,
    solid_angle,
    splint_gh,
    write_ctf_shm,
    ft_statfun_actvsblT,
    ft_statfun_bayesfactor,
    ft_statfun_cohensd,
    ft_statfun_correlationT,
    ft_statfun_depsamplesFmultivariate,
    ft_statfun_depsamplesFunivariate,
    ft_statfun_depsamplesT,
    ft_statfun_depsamplesregrT,
    ft_statfun_diff,
    ft_statfun_diff_itc,
    ft_statfun_gcmi,
    ft_statfun_indepsamplesF,
    ft_statfun_indepsamplesT,
    ft_statfun_indepsamplesZcoh,
    ft_statfun_indepsamplesregrT,
    ft_statfun_mean,
    ft_statfun_pooledT,
    ft_statfun_roc,
    ft_trialfun_balert,
    ft_trialfun_bids,
    ft_trialfun_brainvision_segmented,
    ft_trialfun_edf,
    ft_trialfun_emgdetect,
    ft_trialfun_example1,
    ft_trialfun_example2,
    ft_trialfun_general,
    ft_trialfun_gui,
    ft_trialfun_hed,
    ft_trialfun_imotions,
    ft_trialfun_neuromagSTI016fix,
    ft_trialfun_realtime,
    ft_trialfun_show,
    ft_trialfun_trial,
    ft_trialfun_twoclass_classification,
    appendstruct,
    copyfields,
    dccnpath,
    ft_affinecoordinates,
    ft_average_sens,
    ft_cfg2keyval,
    ft_channelcombination,
    ft_channelselection,
    ft_checkconfig,
    ft_checkdata,
    ft_checkopt,
    ft_compile_mex,
    ft_compile_standalone,
    ft_convert_coordsys,
    ft_datatype,
    ft_datatype_comp,
    ft_datatype_dip,
    ft_datatype_freq,
    ft_datatype_headmodel,
    ft_datatype_mvar,
    ft_datatype_parcellation,
    ft_datatype_raw,
    ft_datatype_segmentation,
    ft_datatype_sens,
    ft_datatype_source,
    ft_datatype_spike,
    ft_datatype_timelock,
    ft_datatype_volume,
    ft_debug,
    ft_determine_coordsys,
    ft_documentationconfiguration,
    ft_documentationreference,
    ft_error,
    ft_fetch_data,
    ft_fetch_event,
    ft_fetch_header,
    ft_findcfg,
    ft_getopt,
    ft_hash,
    ft_hastoolbox,
    ft_headcoordinates,
    ft_info,
    ft_keyval2cfg,
    ft_notice,
    ft_platform_supports,
    ft_postamble,
    ft_preamble,
    ft_progress,
    ft_save_workspace,
    ft_scalingfactor,
    ft_selectdata,
    ft_setopt,
    ft_source2full,
    ft_source2grid,
    ft_source2sparse,
    ft_standalone,
    ft_struct2char,
    ft_struct2double,
    ft_struct2single,
    ft_struct2string,
    ft_test,
    ft_trackusage,
    ft_transform_geometry,
    ft_transform_headmodel,
    ft_transform_headshape,
    ft_transform_sens,
    ft_transform_vol,
    ft_version,
    ft_warning,
    ft_warp_apply,
    ft_warp_error,
    ft_warp_optim,
    getsubfield,
    hasyokogawa,
    issubfield,
    istrue,
    keepfields,
    keyval,
    keyvalcheck,
    markdown2matlab,
    match_str,
    match_val,
    matlab2markdown,
    memtic,
    memtoc,
    nearest,
    printstruct,
    removefields,
    renamefields,
    rmsubfield,
    setsubfield,
    strel_bol,
    tokenize,
    xdf2fieldtrip,
    fiff_copy_tree,
    fiff_define_constants,
    fiff_dir_tree_find,
    fiff_end_block,
    fiff_end_file,
    fiff_find_evoked,
    fiff_finish_writing_raw,
    fiff_invert_transform,
    fiff_list_dir_tree,
    fiff_make_ch_rename,
    fiff_make_dir_tree,
    fiff_open,
    fiff_pick_channels,
    fiff_pick_channels_evoked,
    fiff_pick_info,
    fiff_pick_types,
    fiff_pick_types_evoked,
    fiff_read_bad_channels,
    fiff_read_coord_trans,
    fiff_read_ctf_comp,
    fiff_read_epochs,
    fiff_read_events,
    fiff_read_evoked,
    fiff_read_evoked_all,
    fiff_read_extended_ch_info,
    fiff_read_hpi_result,
    fiff_read_meas_info,
    fiff_read_mri,
    fiff_read_named_matrix,
    fiff_read_proj,
    fiff_read_raw_segment,
    fiff_read_raw_segment_times,
    fiff_read_tag,
    fiff_read_tag_info,
    fiff_rename_comp,
    fiff_rename_list,
    fiff_reset_ch_pos,
    fiff_setup_read_raw,
    fiff_split_name_list,
    fiff_start_block,
    fiff_start_file,
    fiff_start_writing_raw,
    fiff_transform_eeg_chs,
    fiff_transform_meg_chs,
    fiff_write_ch_info,
    fiff_write_ch_infos,
    fiff_write_complex,
    fiff_write_complex_matrix,
    fiff_write_coord_trans,
    fiff_write_ctf_comp,
    fiff_write_dau16,
    fiff_write_dig_file,
    fiff_write_dig_point,
    fiff_write_double,
    fiff_write_double_complex,
    fiff_write_double_complex_matrix,
    fiff_write_double_matrix,
    fiff_write_epochs,
    fiff_write_events,
    fiff_write_evoked,
    fiff_write_float,
    fiff_write_float_matrix,
    fiff_write_float_sparse_ccs,
    fiff_write_float_sparse_rcs,
    fiff_write_id,
    fiff_write_int,
    fiff_write_int_matrix,
    fiff_write_name_list,
    fiff_write_named_matrix,
    fiff_write_proj,
    fiff_write_raw_buffer,
    fiff_write_raw_segment,
    fiff_write_raw_segment_times,
    fiff_write_short,
    fiff_write_string,
    mne_add_coil_defs,
    mne_babyMEG_dig_trig,
    mne_block_diag,
    mne_combine_xyz,
    mne_compensate_to,
    mne_ex_average_epochs,
    mne_ex_cancel_noise,
    mne_ex_compute_inverse,
    mne_ex_data_sets,
    mne_ex_evoked_grad_amp,
    mne_ex_read_epochs,
    mne_ex_read_evoked,
    mne_ex_read_raw,
    mne_ex_read_write_raw,
    mne_ex_rt,
    mne_file_name,
    mne_find_channel,
    mne_find_events,
    mne_find_source_space_hemi,
    mne_fread3,
    mne_fwrite3,
    mne_get_current_comp,
    mne_label_time_courses,
    mne_license,
    mne_load_coil_def,
    mne_make_combined_event_file,
    mne_make_compensator,
    mne_make_projector,
    mne_make_projector_info,
    mne_mesh_edges,
    mne_morph_data,
    mne_omit_first_line,
    mne_patch_info,
    mne_pick_channels_cov,
    mne_pick_channels_forward,
    mne_prepare_inverse_operator,
    mne_read_bem_surfaces,
    mne_read_cov,
    mne_read_curvature,
    mne_read_epoch,
    mne_read_events,
    mne_read_forward_solution,
    mne_read_inverse_operator,
    mne_read_label_file,
    mne_read_morph_map,
    mne_read_noise_cov,
    mne_read_source_spaces,
    mne_read_stc_file,
    mne_read_stc_file1,
    mne_read_surface,
    mne_read_surfaces,
    mne_read_w_file,
    mne_read_w_file1,
    mne_reduce_surface,
    mne_rt_define_commands,
    mne_set_current_comp,
    mne_source_spectral_analysis,
    mne_transform_coordinates,
    mne_transform_source_space_to,
    mne_transpose_named_matrix,
    mne_write_cov,
    mne_write_cov_file,
    mne_write_events,
    mne_write_inverse_sol_stc,
    mne_write_inverse_sol_w,
    mne_write_label_file,
    mne_write_stc_file,
    mne_write_stc_file1,
    mne_write_surface,
    mne_write_w_file,
    mne_write_w_file1,
)
from .__man import dcm_fit_finger, gen_finger, glm_phi
from .__matlabbatch import (
    cfg_branch,
    cfg_choice,
    cfg_const,
    cfg_dep,
    cfg_entry,
    cfg_exbranch,
    cfg_files,
    cfg_intree,
    cfg_inv_out,
    cfg_item,
    cfg_leaf,
    cfg_mchoice,
    cfg_menu,
    cfg_repeat,
    cfg_basicio_rewrite,
    cfg_cfg_basicio,
    cfg_cfg_basicio_def,
    cfg_check_assignin,
    cfg_load_vars,
    cfg_run_assignin,
    cfg_run_call_matlab,
    cfg_run_cd,
    cfg_run_dir_move,
    cfg_run_file_filter,
    cfg_run_file_fplist,
    cfg_run_file_move,
    cfg_run_file_split,
    cfg_run_fileparts,
    cfg_run_gunzip_files,
    cfg_run_gzip_files,
    cfg_run_mkdir,
    cfg_run_named_dir,
    cfg_run_named_file,
    cfg_run_named_input,
    cfg_run_runjobs,
    cfg_run_save_vars,
    cfg_run_subsrefvar,
    cfg_vout_dir_move,
    cfg_vout_file_filter,
    cfg_vout_file_fplist,
    cfg_vout_file_move,
    cfg_vout_file_split,
    cfg_vout_fileparts,
    cfg_vout_gunzip_files,
    cfg_vout_gzip_files,
    cfg_vout_mkdir,
    cfg_vout_named_dir,
    cfg_vout_named_file,
    cfg_vout_named_input,
    cfg_vout_runjobs,
    cfg_vout_save_vars,
    create_cfg_cfg_basicio,
    cfg_callbuiltin,
    cfg_confgui,
    cfg_run_template,
    cfg_dbstop,
    cfg_findspec,
    cfg_get_defaults,
    cfg_getfile,
    cfg_load_jobs,
    cfg_message,
    cfg_mlbatch_appcfg,
    cfg_serial,
    cfg_struct2cfg,
    cfg_tropts,
    cfg_txtdesc2cfg,
    cfg_ui,
    cfg_ui_multibatch,
    cfg_ui_util,
    cfg_util,
    cfg_example_add1,
    cfg_example_add2,
    cfg_example_cumsum1,
    cfg_example_cumsum2,
    cfg_example_div,
    cfg_example_master,
    cfg_example_run_add1,
    cfg_example_run_add2,
    cfg_example_run_cumsum1,
    cfg_example_run_cumsum2,
    cfg_example_run_div,
    cfg_example_run_sum,
    cfg_example_sum,
    toy_example,
    gencode,
    gencode_rvalue,
    gencode_substruct,
    gencode_substructcode,
    help2cell,
    hgsave_pre2008a,
    subsasgn_check_funhandle,
    subsasgn_check_num,
    subsasgn_check_valcfg,
)
from .spm import spm
from .spm_ADEM import spm_ADEM
from .spm_ADEM_M_set import spm_ADEM_M_set
from .spm_ADEM_diff import spm_ADEM_diff
from .spm_ADEM_set import spm_ADEM_set
from .spm_ADEM_update import spm_ADEM_update
from .spm_ALAP import spm_ALAP
from .spm_A_reduce import spm_A_reduce
from .spm_BIDS import spm_BIDS
from .spm_BIDS_file import spm_BIDS_file
from .spm_BMS import spm_BMS
from .spm_BMS_F import spm_BMS_F
from .spm_BMS_F_smpl import spm_BMS_F_smpl
from .spm_BMS_bor import spm_BMS_bor
from .spm_BMS_gibbs import spm_BMS_gibbs
from .spm_Bcdf import spm_Bcdf
from .spm_Bpdf import spm_Bpdf
from .spm_Ce import spm_Ce
from .spm_DEM import spm_DEM
from .spm_DEM_F import spm_DEM_F
from .spm_DEM_M_set import spm_DEM_M_set
from .spm_DEM_R import spm_DEM_R
from .spm_DEM_diff import spm_DEM_diff
from .spm_DEM_embed import spm_DEM_embed
from .spm_DEM_eval import spm_DEM_eval
from .spm_DEM_eval_diff import spm_DEM_eval_diff
from .spm_DEM_generate import spm_DEM_generate
from .spm_DEM_int import spm_DEM_int
from .spm_DEM_qH import spm_DEM_qH
from .spm_DEM_qP import spm_DEM_qP
from .spm_DEM_qU import spm_DEM_qU
from .spm_DEM_set import spm_DEM_set
from .spm_DEM_z import spm_DEM_z
from .spm_DFP import spm_DFP
from .spm_DFP_plot import spm_DFP_plot
from .spm_DesMtx import spm_DesMtx
from .spm_DesRep import spm_DesRep
from .spm_DisplayTimeSeries import spm_DisplayTimeSeries
from .spm_Dpdf import spm_Dpdf
from .spm_ECdensity import spm_ECdensity
from .spm_FcUtil import spm_FcUtil
from .spm_Fcdf import spm_Fcdf
from .spm_Fpdf import spm_Fpdf
from .spm_GDEM import spm_GDEM
from .spm_Gcdf import spm_Gcdf
from .spm_Gpdf import spm_Gpdf
from .spm_Icdf import spm_Icdf
from .spm_Ipdf import spm_Ipdf
from .spm_KL_cat import spm_KL_cat
from .spm_KL_dir import spm_KL_dir
from .spm_LAP import spm_LAP
from .spm_LAPF import spm_LAPF
from .spm_LAPS import spm_LAPS
from .spm_LAP_F import spm_LAP_F
from .spm_LAP_eval import spm_LAP_eval
from .spm_LAP_iS import spm_LAP_iS
from .spm_LAP_pg import spm_LAP_pg
from .spm_LAP_ph import spm_LAP_ph
from .spm_Laplace import spm_Laplace
from .spm_MB_col import spm_MB_col
from .spm_MDP_MI import spm_MDP_MI
from .spm_MDP_da import spm_MDP_da
from .spm_MH import spm_MH
from .spm_MH_reml import spm_MH_reml
from .spm_MH_reml_likelihood import spm_MH_reml_likelihood
from .spm_Markov_blanket import spm_Markov_blanket
from .spm_Menu import spm_Menu
from .spm_NESS_F import spm_NESS_F
from .spm_NESS_ds import spm_NESS_ds
from .spm_NESS_gen import spm_NESS_gen
from .spm_NESS_gen_lap import spm_NESS_gen_lap
from .spm_Ncdf import spm_Ncdf
from .spm_Ncdf_jdw import spm_Ncdf_jdw
from .spm_Npdf import spm_Npdf
from .spm_P import spm_P
from .spm_PEB import spm_PEB
from .spm_P_Bonf import spm_P_Bonf
from .spm_P_FDR import spm_P_FDR
from .spm_P_RF import spm_P_RF
from .spm_P_clusterFDR import spm_P_clusterFDR
from .spm_P_peakFDR import spm_P_peakFDR
from .spm_Pcdf import spm_Pcdf
from .spm_Pec_resels import spm_Pec_resels
from .spm_Ppdf import spm_Ppdf
from .spm_Q import spm_Q
from .spm_Q_perm import spm_Q_perm
from .spm_ROI import spm_ROI
from .spm_SpUtil import spm_SpUtil
from .spm_Tcdf import spm_Tcdf
from .spm_Tpdf import spm_Tpdf
from .spm_VBX import spm_VBX
from .spm_VOI import spm_VOI
from .spm_Volt_W import spm_Volt_W
from .spm_Volterra import spm_Volterra
from .spm_Welcome import spm_Welcome
from .spm_XYZreg import spm_XYZreg
from .spm_XYZreg_Ex2 import spm_XYZreg_Ex2
from .spm_Xcdf import spm_Xcdf
from .spm_Xpdf import spm_Xpdf
from .spm_affine_priors import spm_affine_priors
from .spm_ancova import spm_ancova
from .spm_api_bmc import spm_api_bmc
from .spm_ar_reml import spm_ar_reml
from .spm_argmax import spm_argmax
from .spm_atlas import spm_atlas
from .spm_authors import spm_authors
from .spm_axis import spm_axis
from .spm_barh import spm_barh
from .spm_bayes2_logbf import spm_bayes2_logbf
from .spm_beta_compare import spm_beta_compare
from .spm_betaln import spm_betaln
from .spm_bilinear import spm_bilinear
from .spm_bilinear_condition import spm_bilinear_condition
from .spm_bireduce import spm_bireduce
from .spm_bms_against_null import spm_bms_against_null
from .spm_bms_anova import spm_bms_anova
from .spm_bms_anova_img import spm_bms_anova_img
from .spm_bms_compare_groups import spm_bms_compare_groups
from .spm_bms_display import spm_bms_display
from .spm_bms_display_ROI import spm_bms_display_ROI
from .spm_bms_display_vox import spm_bms_display_vox
from .spm_bms_partition import spm_bms_partition
from .spm_bms_test_null import spm_bms_test_null
from .spm_bms_ttest import spm_bms_ttest
from .spm_browser import spm_browser
from .spm_bsplinc import spm_bsplinc
from .spm_bsplins import spm_bsplins
from .spm_bwlabel import spm_bwlabel
from .spm_cat import spm_cat
from .spm_cat_struct import spm_cat_struct
from .spm_cell_swap import spm_cell_swap
from .spm_changepath import spm_changepath
from .spm_check_filename import spm_check_filename
from .spm_check_installation import spm_check_installation
from .spm_check_orientations import spm_check_orientations
from .spm_check_registration import spm_check_registration
from .spm_check_results import spm_check_results
from .spm_check_version import spm_check_version
from .spm_circularGraph import spm_circularGraph
from .spm_clf import spm_clf
from .spm_cli import spm_cli
from .spm_clusters import spm_clusters
from .spm_colourmap import spm_colourmap
from .spm_combinations import spm_combinations
from .spm_compact_svd import spm_compact_svd
from .spm_compare_families import spm_compare_families
from .spm_cond_units import spm_cond_units
from .spm_conman import spm_conman
from .spm_contrasts import spm_contrasts
from .spm_conv import spm_conv
from .spm_conv_full import spm_conv_full
from .spm_conv_vol import spm_conv_vol
from .spm_convmtx import spm_convmtx
from .spm_copy import spm_copy
from .spm_coreg import spm_coreg
from .spm_cov2corr import spm_cov2corr
from .spm_create_vol import spm_create_vol
from .spm_cross import spm_cross
from .spm_csd_fmri_gu import spm_csd_fmri_gu
from .spm_csd_fmri_mar import spm_csd_fmri_mar
from .spm_csd_fmri_mtf import spm_csd_fmri_mtf
from .spm_cva import spm_cva
from .spm_cva_ui import spm_cva_ui
from .spm_dartel_integrate import spm_dartel_integrate
from .spm_data_hdr_read import spm_data_hdr_read
from .spm_data_hdr_write import spm_data_hdr_write
from .spm_data_id import spm_data_id
from .spm_data_read import spm_data_read
from .spm_data_write import spm_data_write
from .spm_dcm_HMM import spm_dcm_HMM
from .spm_dcm_HMM_plot import spm_dcm_HMM_plot
from .spm_dcm_J import spm_dcm_J
from .spm_dcm_KL import spm_dcm_KL
from .spm_dcm_U import spm_dcm_U
from .spm_dcm_average import spm_dcm_average
from .spm_dcm_bdc import spm_dcm_bdc
from .spm_dcm_bma import spm_dcm_bma
from .spm_dcm_bma_results import spm_dcm_bma_results
from .spm_dcm_bmc import spm_dcm_bmc
from .spm_dcm_bmc_peb import spm_dcm_bmc_peb
from .spm_dcm_bmr import spm_dcm_bmr
from .spm_dcm_bmr_all import spm_dcm_bmr_all
from .spm_dcm_bpa import spm_dcm_bpa
from .spm_dcm_check_stability import spm_dcm_check_stability
from .spm_dcm_compare import spm_dcm_compare
from .spm_dcm_connectivity_ui import spm_dcm_connectivity_ui
from .spm_dcm_contrasts import spm_dcm_contrasts
from .spm_dcm_create import spm_dcm_create
from .spm_dcm_csd_Q import spm_dcm_csd_Q
from .spm_dcm_delay import spm_dcm_delay
from .spm_dcm_diagnose import spm_dcm_diagnose
from .spm_dcm_display import spm_dcm_display
from .spm_dcm_estimate import spm_dcm_estimate
from .spm_dcm_evidence import spm_dcm_evidence
from .spm_dcm_fit import spm_dcm_fit
from .spm_dcm_fmri_check import spm_dcm_fmri_check
from .spm_dcm_fmri_csd import spm_dcm_fmri_csd
from .spm_dcm_fmri_csd_DEM import spm_dcm_fmri_csd_DEM
from .spm_dcm_fmri_csd_data import spm_dcm_fmri_csd_data
from .spm_dcm_fmri_csd_gen import spm_dcm_fmri_csd_gen
from .spm_dcm_fmri_csd_results import spm_dcm_fmri_csd_results
from .spm_dcm_fmri_graph_gen import spm_dcm_fmri_graph_gen
from .spm_dcm_fmri_image import spm_dcm_fmri_image
from .spm_dcm_fmri_mar import spm_dcm_fmri_mar
from .spm_dcm_fmri_mode import spm_dcm_fmri_mode
from .spm_dcm_fmri_mode_gen import spm_dcm_fmri_mode_gen
from .spm_dcm_fmri_nmm import spm_dcm_fmri_nmm
from .spm_dcm_fmri_priors import spm_dcm_fmri_priors
from .spm_dcm_generate import spm_dcm_generate
from .spm_dcm_graph import spm_dcm_graph
from .spm_dcm_graph_functional import spm_dcm_graph_functional
from .spm_dcm_identify import spm_dcm_identify
from .spm_dcm_load import spm_dcm_load
from .spm_dcm_loo import spm_dcm_loo
from .spm_dcm_mdp import spm_dcm_mdp
from .spm_dcm_mtf import spm_dcm_mtf
from .spm_dcm_optimise import spm_dcm_optimise
from .spm_dcm_peb import spm_dcm_peb
from .spm_dcm_peb_bmc import spm_dcm_peb_bmc
from .spm_dcm_peb_bmc_fam import spm_dcm_peb_bmc_fam
from .spm_dcm_peb_con import spm_dcm_peb_con
from .spm_dcm_peb_fit import spm_dcm_peb_fit
from .spm_dcm_peb_full import spm_dcm_peb_full
from .spm_dcm_peb_review import spm_dcm_peb_review
from .spm_dcm_peb_rnd import spm_dcm_peb_rnd
from .spm_dcm_peb_rnd_search import spm_dcm_peb_rnd_search
from .spm_dcm_peb_test import spm_dcm_peb_test
from .spm_dcm_peb_to_gcm import spm_dcm_peb_to_gcm
from .spm_dcm_post_hoc import spm_dcm_post_hoc
from .spm_dcm_post_hoc_old import spm_dcm_post_hoc_old
from .spm_dcm_ppd import spm_dcm_ppd
from .spm_dcm_reduce import spm_dcm_reduce
from .spm_dcm_review import spm_dcm_review
from .spm_dcm_search import spm_dcm_search
from .spm_dcm_sessions import spm_dcm_sessions
from .spm_dcm_simulate import spm_dcm_simulate
from .spm_dcm_sparse import spm_dcm_sparse
from .spm_dcm_sparse_priors import spm_dcm_sparse_priors
from .spm_dcm_specify import spm_dcm_specify
from .spm_dcm_specify_ui import spm_dcm_specify_ui
from .spm_dcm_ui import spm_dcm_ui
from .spm_dcm_voi import spm_dcm_voi
from .spm_dctmtx import spm_dctmtx
from .spm_ddiff import spm_ddiff
from .spm_deface import spm_deface
from .spm_defaults import spm_defaults
from .spm_deformations import spm_deformations
from .spm_dem2dcm import spm_dem2dcm
from .spm_design_contrasts import spm_design_contrasts
from .spm_design_factorial import spm_design_factorial
from .spm_design_flexible import spm_design_flexible
from .spm_design_within_subject import spm_design_within_subject
from .spm_detrend import spm_detrend
from .spm_dftmtx import spm_dftmtx
from .spm_diag import spm_diag
from .spm_diag_array import spm_diag_array
from .spm_dicom_convert import spm_dicom_convert
from .spm_dicom_essentials import spm_dicom_essentials
from .spm_dicom_header import spm_dicom_header
from .spm_dicom_headers import spm_dicom_headers
from .spm_dicom_metadata import spm_dicom_metadata
from .spm_dicom_text_to_dict import spm_dicom_text_to_dict
from .spm_diff import spm_diff
from .spm_diff_dx import spm_diff_dx
from .spm_diffeo import spm_diffeo
from .spm_dilate import spm_dilate
from .spm_dir_MI import spm_dir_MI
from .spm_dir_norm import spm_dir_norm
from .spm_dir_sort import spm_dir_sort
from .spm_dirichlet_exceedance import spm_dirichlet_exceedance
from .spm_dot import spm_dot
from .spm_dwtmtx import spm_dwtmtx
from .spm_dx import spm_dx
from .spm_dx_eig import spm_dx_eig
from .spm_ecat2nifti import spm_ecat2nifti
from .spm_eeg_artefact import spm_eeg_artefact
from .spm_eeg_artefact_events import spm_eeg_artefact_events
from .spm_eeg_artefact_eyeblink import spm_eeg_artefact_eyeblink
from .spm_eeg_artefact_flat import spm_eeg_artefact_flat
from .spm_eeg_artefact_heartbeat import spm_eeg_artefact_heartbeat
from .spm_eeg_artefact_jump import spm_eeg_artefact_jump
from .spm_eeg_artefact_nans import spm_eeg_artefact_nans
from .spm_eeg_artefact_peak2peak import spm_eeg_artefact_peak2peak
from .spm_eeg_artefact_saccade import spm_eeg_artefact_saccade
from .spm_eeg_artefact_threshchan import spm_eeg_artefact_threshchan
from .spm_eeg_artefact_zscore import spm_eeg_artefact_zscore
from .spm_eeg_artefact_zscorediff import spm_eeg_artefact_zscorediff
from .spm_eeg_assemble_priors import spm_eeg_assemble_priors
from .spm_eeg_average import spm_eeg_average
from .spm_eeg_average_TF import spm_eeg_average_TF
from .spm_eeg_avgfreq import spm_eeg_avgfreq
from .spm_eeg_avgtime import spm_eeg_avgtime
from .spm_eeg_bc import spm_eeg_bc
from .spm_eeg_cfc import spm_eeg_cfc
from .spm_eeg_collapse_timefreq import spm_eeg_collapse_timefreq
from .spm_eeg_combineplanar import spm_eeg_combineplanar
from .spm_eeg_contrast import spm_eeg_contrast
from .spm_eeg_convert import spm_eeg_convert
from .spm_eeg_convert2images import spm_eeg_convert2images
from .spm_eeg_convert_ui import spm_eeg_convert_ui
from .spm_eeg_copy import spm_eeg_copy
from .spm_eeg_correct_sensor_data import spm_eeg_correct_sensor_data
from .spm_eeg_crop import spm_eeg_crop
from .spm_eeg_definetrial import spm_eeg_definetrial
from .spm_eeg_dipoles_ui import spm_eeg_dipoles_ui
from .spm_eeg_displayECD import spm_eeg_displayECD
from .spm_eeg_display_tf import spm_eeg_display_tf
from .spm_eeg_downsample import spm_eeg_downsample
from .spm_eeg_epochs import spm_eeg_epochs
from .spm_eeg_filter import spm_eeg_filter
from .spm_eeg_firstlevel import spm_eeg_firstlevel
from .spm_eeg_fixpnt import spm_eeg_fixpnt
from .spm_eeg_ft2spm import spm_eeg_ft2spm
from .spm_eeg_fuse import spm_eeg_fuse
from .spm_eeg_grandmean import spm_eeg_grandmean
from .spm_eeg_history import spm_eeg_history
from .spm_eeg_inv_Mesh2Voxels import spm_eeg_inv_Mesh2Voxels
from .spm_eeg_inv_check import spm_eeg_inv_check
from .spm_eeg_inv_checkdatareg import spm_eeg_inv_checkdatareg
from .spm_eeg_inv_checkforward import spm_eeg_inv_checkforward
from .spm_eeg_inv_checkmeshes import spm_eeg_inv_checkmeshes
from .spm_eeg_inv_custom_ui import spm_eeg_inv_custom_ui
from .spm_eeg_inv_datareg import spm_eeg_inv_datareg
from .spm_eeg_inv_datareg_ui import spm_eeg_inv_datareg_ui
from .spm_eeg_inv_extract import spm_eeg_inv_extract
from .spm_eeg_inv_extract_ui import spm_eeg_inv_extract_ui
from .spm_eeg_inv_fmripriors import spm_eeg_inv_fmripriors
from .spm_eeg_inv_forward import spm_eeg_inv_forward
from .spm_eeg_inv_forward_ui import spm_eeg_inv_forward_ui
from .spm_eeg_inv_get_vol_sens import spm_eeg_inv_get_vol_sens
from .spm_eeg_inv_group import spm_eeg_inv_group
from .spm_eeg_inv_headcoordinates import spm_eeg_inv_headcoordinates
from .spm_eeg_inv_icp import spm_eeg_inv_icp
from .spm_eeg_inv_imag_api import spm_eeg_inv_imag_api
from .spm_eeg_inv_image_display import spm_eeg_inv_image_display
from .spm_eeg_inv_mesh import spm_eeg_inv_mesh
from .spm_eeg_inv_mesh_spherify import spm_eeg_inv_mesh_spherify
from .spm_eeg_inv_mesh_ui import spm_eeg_inv_mesh_ui
from .spm_eeg_inv_prep_modes_xval import spm_eeg_inv_prep_modes_xval
from .spm_eeg_inv_results import spm_eeg_inv_results
from .spm_eeg_inv_results_display import spm_eeg_inv_results_display
from .spm_eeg_inv_results_ui import spm_eeg_inv_results_ui
from .spm_eeg_inv_rigidreg import spm_eeg_inv_rigidreg
from .spm_eeg_inv_spatnorm import spm_eeg_inv_spatnorm
from .spm_eeg_inv_transform_mesh import spm_eeg_inv_transform_mesh
from .spm_eeg_inv_transform_points import spm_eeg_inv_transform_points
from .spm_eeg_inv_vb_ecd_gui import spm_eeg_inv_vb_ecd_gui
from .spm_eeg_inv_vbecd import spm_eeg_inv_vbecd
from .spm_eeg_inv_vbecd_disp import spm_eeg_inv_vbecd_disp
from .spm_eeg_inv_vbecd_getLF import spm_eeg_inv_vbecd_getLF
from .spm_eeg_inv_vbecd_gui import spm_eeg_inv_vbecd_gui
from .spm_eeg_inv_vbecd_mom import spm_eeg_inv_vbecd_mom
from .spm_eeg_inv_visu3D_api import spm_eeg_inv_visu3D_api
from .spm_eeg_invert import spm_eeg_invert
from .spm_eeg_invert_EBoptimise import spm_eeg_invert_EBoptimise
from .spm_eeg_invert_bma import spm_eeg_invert_bma
from .spm_eeg_invert_classic import spm_eeg_invert_classic
from .spm_eeg_invert_classic_mix import spm_eeg_invert_classic_mix
from .spm_eeg_invert_classic_volumetric import spm_eeg_invert_classic_volumetric
from .spm_eeg_invert_display import spm_eeg_invert_display
from .spm_eeg_invert_prepro import spm_eeg_invert_prepro
from .spm_eeg_invert_setuppatches import spm_eeg_invert_setuppatches
from .spm_eeg_invert_ui import spm_eeg_invert_ui
from .spm_eeg_invertiter import spm_eeg_invertiter
from .spm_eeg_lapmtx import spm_eeg_lapmtx
from .spm_eeg_layout3D import spm_eeg_layout3D
from .spm_eeg_lgainmat import spm_eeg_lgainmat
from .spm_eeg_load import spm_eeg_load
from .spm_eeg_locate_channels import spm_eeg_locate_channels
from .spm_eeg_mask import spm_eeg_mask
from .spm_eeg_mask2channels import spm_eeg_mask2channels
from .spm_eeg_merge import spm_eeg_merge
from .spm_eeg_meshnative2mni import spm_eeg_meshnative2mni
from .spm_eeg_modality_ui import spm_eeg_modality_ui
from .spm_eeg_montage import spm_eeg_montage
from .spm_eeg_montage_ui import spm_eeg_montage_ui
from .spm_eeg_morlet import spm_eeg_morlet
from .spm_eeg_planarchannelset import spm_eeg_planarchannelset
from .spm_eeg_plotScalpData import spm_eeg_plotScalpData
from .spm_eeg_prep import spm_eeg_prep
from .spm_eeg_prep_ui import spm_eeg_prep_ui
from .spm_eeg_project3D import spm_eeg_project3D
from .spm_eeg_read_bsa import spm_eeg_read_bsa
from .spm_eeg_reduce import spm_eeg_reduce
from .spm_eeg_reduce_cva import spm_eeg_reduce_cva
from .spm_eeg_reduce_imagcsd import spm_eeg_reduce_imagcsd
from .spm_eeg_reduce_pca import spm_eeg_reduce_pca
from .spm_eeg_reduce_pca_adapt import spm_eeg_reduce_pca_adapt
from .spm_eeg_reduce_whiten import spm_eeg_reduce_whiten
from .spm_eeg_regressors import spm_eeg_regressors
from .spm_eeg_regressors_chandata import spm_eeg_regressors_chandata
from .spm_eeg_regressors_movement_ctf import spm_eeg_regressors_movement_ctf
from .spm_eeg_regressors_tfphase import spm_eeg_regressors_tfphase
from .spm_eeg_regressors_tfpower import spm_eeg_regressors_tfpower
from .spm_eeg_remove_bad_trials import spm_eeg_remove_bad_trials
from .spm_eeg_render import spm_eeg_render
from .spm_eeg_review import spm_eeg_review
from .spm_eeg_review_callbacks import spm_eeg_review_callbacks
from .spm_eeg_review_switchDisplay import spm_eeg_review_switchDisplay
from .spm_eeg_review_uis import spm_eeg_review_uis
from .spm_eeg_robust_averaget import spm_eeg_robust_averaget
from .spm_eeg_select_event_ui import spm_eeg_select_event_ui
from .spm_eeg_simulate import spm_eeg_simulate
from .spm_eeg_simulate_frominv import spm_eeg_simulate_frominv
from .spm_eeg_smoothmesh_mm import spm_eeg_smoothmesh_mm
from .spm_eeg_spatial_confounds import spm_eeg_spatial_confounds
from .spm_eeg_specest_hilbert import spm_eeg_specest_hilbert
from .spm_eeg_specest_morlet import spm_eeg_specest_morlet
from .spm_eeg_specest_mtmconvol import spm_eeg_specest_mtmconvol
from .spm_eeg_specest_mtmfft import spm_eeg_specest_mtmfft
from .spm_eeg_spmft_chan_dictionary import spm_eeg_spmft_chan_dictionary
from .spm_eeg_tf import spm_eeg_tf
from .spm_eeg_tf_rescale import spm_eeg_tf_rescale
from .spm_eeg_wrap_dipfit_vbecd import spm_eeg_wrap_dipfit_vbecd
from .spm_eeg_wrap_momfit_vbecd import spm_eeg_wrap_momfit_vbecd
from .spm_ekf import spm_ekf
from .spm_en import spm_en
from .spm_epharm import spm_epharm
from .spm_erode import spm_erode
from .spm_est_V import spm_est_V
from .spm_est_non_sphericity import spm_est_non_sphericity
from .spm_est_smoothness import spm_est_smoothness
from .spm_existfile import spm_existfile
from .spm_expm import spm_expm
from .spm_extract_files import spm_extract_files
from .spm_extrapolate_def import spm_extrapolate_def
from .spm_fMRI_design import spm_fMRI_design
from .spm_field import spm_field
from .spm_fieldindices import spm_fieldindices
from .spm_figure import spm_figure
from .spm_file import spm_file
from .spm_file_ext import spm_file_ext
from .spm_file_merge import spm_file_merge
from .spm_file_split import spm_file_split
from .spm_fileparts import spm_fileparts
from .spm_filter import spm_filter
from .spm_find_pC import spm_find_pC
from .spm_flip_analyze_images import spm_flip_analyze_images
from .spm_fmin import spm_fmin
from .spm_fmri_concatenate import spm_fmri_concatenate
from .spm_fmri_spm_ui import spm_fmri_spm_ui
from .spm_fn_reml import spm_fn_reml
from .spm_fp import spm_fp
from .spm_fp_display_density import spm_fp_display_density
from .spm_fp_display_nullclines import spm_fp_display_nullclines
from .spm_fp_fmin import spm_fp_fmin
from .spm_fp_fun import spm_fp_fun
from .spm_fs_fmri_csd import spm_fs_fmri_csd
from .spm_funcheck import spm_funcheck
from .spm_funfun import spm_funfun
from .spm_fx_fmri import spm_fx_fmri
from .spm_fx_fmri_linear import spm_fx_fmri_linear
from .spm_fx_hdm import spm_fx_hdm
from .spm_fx_lz import spm_fx_lz
from .spm_fx_poly import spm_fx_poly
from .spm_gamrnd import spm_gamrnd
from .spm_gen_fmri import spm_gen_fmri
from .spm_getSPM import spm_getSPM
from .spm_get_anatomical_layout import spm_get_anatomical_layout
from .spm_get_bbox import spm_get_bbox
from .spm_get_bf import spm_get_bf
from .spm_get_closest_affine import spm_get_closest_affine
from .spm_get_data import spm_get_data
from .spm_get_dataset import spm_get_dataset
from .spm_get_defaults import spm_get_defaults
from .spm_get_lm import spm_get_lm
from .spm_get_matdim import spm_get_matdim
from .spm_get_ons import spm_get_ons
from .spm_get_space import spm_get_space
from .spm_get_vc import spm_get_vc
from .spm_get_volumes import spm_get_volumes
from .spm_glass import spm_glass
from .spm_global import spm_global
from .spm_gn_fmin import spm_gn_fmin
from .spm_graph import spm_graph
from .spm_graph_ui import spm_graph_ui
from .spm_grid import spm_grid
from .spm_gx_fmri import spm_gx_fmri
from .spm_gx_fmri_linear import spm_gx_fmri_linear
from .spm_gx_hdm import spm_gx_hdm
from .spm_gx_state_fmri import spm_gx_state_fmri
from .spm_hanning import spm_hanning
from .spm_hdm_priors import spm_hdm_priors
from .spm_hdm_ui import spm_hdm_ui
from .spm_help import spm_help
from .spm_hilbert import spm_hilbert
from .spm_hist import spm_hist
from .spm_hist2 import spm_hist2
from .spm_hist_smooth import spm_hist_smooth
from .spm_hrf import spm_hrf
from .spm_image import spm_image
from .spm_imatrix import spm_imatrix
from .spm_imcalc import spm_imcalc
from .spm_ind2sub import spm_ind2sub
from .spm_inline2func import spm_inline2func
from .spm_input import spm_input
from .spm_int import spm_int
from .spm_int_B import spm_int_B
from .spm_int_D import spm_int_D
from .spm_int_E import spm_int_E
from .spm_int_J import spm_int_J
from .spm_int_L import spm_int_L
from .spm_int_ode import spm_int_ode
from .spm_int_sde import spm_int_sde
from .spm_interp import spm_interp
from .spm_inv import spm_inv
from .spm_invBcdf import spm_invBcdf
from .spm_invFcdf import spm_invFcdf
from .spm_invGcdf import spm_invGcdf
from .spm_invIcdf import spm_invIcdf
from .spm_invNcdf import spm_invNcdf
from .spm_invPcdf import spm_invPcdf
from .spm_invTcdf import spm_invTcdf
from .spm_invXcdf import spm_invXcdf
from .spm_inv_phi import spm_inv_phi
from .spm_inv_spd import spm_inv_spd
from .spm_ipharm import spm_ipharm
from .spm_iwft import spm_iwft
from .spm_jobman import spm_jobman
from .spm_jsonread import spm_jsonread
from .spm_jsonwrite import spm_jsonwrite
from .spm_kernels import spm_kernels
from .spm_kl_dirichlet import spm_kl_dirichlet
from .spm_kl_gamma import spm_kl_gamma
from .spm_kl_normal import spm_kl_normal
from .spm_kl_normald import spm_kl_normald
from .spm_kl_wishart import spm_kl_wishart
from .spm_kron import spm_kron
from .spm_krutil import spm_krutil
from .spm_large_dcm_reduce import spm_large_dcm_reduce
from .spm_length import spm_length
from .spm_lg_gamma import spm_lg_gamma
from .spm_list import spm_list
from .spm_load import spm_load
from .spm_load_priors8 import spm_load_priors8
from .spm_log import spm_log
from .spm_log_evidence import spm_log_evidence
from .spm_log_evidence_reduce import spm_log_evidence_reduce
from .spm_logdet import spm_logdet
from .spm_lorenz_k import spm_lorenz_k
from .spm_lotka_volterra import spm_lotka_volterra
from .spm_maff8 import spm_maff8
from .spm_make_contrasts import spm_make_contrasts
from .spm_marginal import spm_marginal
from .spm_mask import spm_mask
from .spm_match_str import spm_match_str
from .spm_matrix import spm_matrix
from .spm_max import spm_max
from .spm_mb_ui import spm_mb_ui
from .spm_meanby import spm_meanby
from .spm_mesh import spm_mesh
from .spm_mesh_adjacency import spm_mesh_adjacency
from .spm_mesh_area import spm_mesh_area
from .spm_mesh_borders import spm_mesh_borders
from .spm_mesh_bounding_volume import spm_mesh_bounding_volume
from .spm_mesh_calc import spm_mesh_calc
from .spm_mesh_clusters import spm_mesh_clusters
from .spm_mesh_contour import spm_mesh_contour
from .spm_mesh_cube import spm_mesh_cube
from .spm_mesh_curvature import spm_mesh_curvature
from .spm_mesh_detect import spm_mesh_detect
from .spm_mesh_dist import spm_mesh_dist
from .spm_mesh_distmtx import spm_mesh_distmtx
from .spm_mesh_edges import spm_mesh_edges
from .spm_mesh_euler import spm_mesh_euler
from .spm_mesh_geodesic import spm_mesh_geodesic
from .spm_mesh_get_lm import spm_mesh_get_lm
from .spm_mesh_inflate import spm_mesh_inflate
from .spm_mesh_inside import spm_mesh_inside
from .spm_mesh_isoline import spm_mesh_isoline
from .spm_mesh_isosurface import spm_mesh_isosurface
from .spm_mesh_join import spm_mesh_join
from .spm_mesh_label import spm_mesh_label
from .spm_mesh_laplacian import spm_mesh_laplacian
from .spm_mesh_mass_matrix import spm_mesh_mass_matrix
from .spm_mesh_max import spm_mesh_max
from .spm_mesh_neighbours import spm_mesh_neighbours
from .spm_mesh_normals import spm_mesh_normals
from .spm_mesh_polyhedron import spm_mesh_polyhedron
from .spm_mesh_project import spm_mesh_project
from .spm_mesh_ray_intersect import spm_mesh_ray_intersect
from .spm_mesh_ray_triangle import spm_mesh_ray_triangle
from .spm_mesh_reduce import spm_mesh_reduce
from .spm_mesh_refine import spm_mesh_refine
from .spm_mesh_render import spm_mesh_render
from .spm_mesh_resels import spm_mesh_resels
from .spm_mesh_sdf import spm_mesh_sdf
from .spm_mesh_select import spm_mesh_select
from .spm_mesh_smooth import spm_mesh_smooth
from .spm_mesh_sphere import spm_mesh_sphere
from .spm_mesh_split import spm_mesh_split
from .spm_mesh_to_grid import spm_mesh_to_grid
from .spm_mesh_transform import spm_mesh_transform
from .spm_mesh_utils import spm_mesh_utils
from .spm_mesh_volume import spm_mesh_volume
from .spm_mesh_voxelise import spm_mesh_voxelise
from .spm_mfx import spm_mfx
from .spm_minmax import spm_minmax
from .spm_mip import spm_mip
from .spm_mip_ui import spm_mip_ui
from .spm_mkdir import spm_mkdir
from .spm_mldivide import spm_mldivide
from .spm_mnc2nifti import spm_mnc2nifti
from .spm_morlet import spm_morlet
from .spm_morlet_conv import spm_morlet_conv
from .spm_mrdivide import spm_mrdivide
from .spm_mrf import spm_mrf
from .spm_mtx_cos import spm_mtx_cos
from .spm_multrnd import spm_multrnd
from .spm_mvNpdf import spm_mvNpdf
from .spm_mvb import spm_mvb
from .spm_mvb_G import spm_mvb_G
from .spm_mvb_R2 import spm_mvb_R2
from .spm_mvb_U import spm_mvb_U
from .spm_mvb_bmc import spm_mvb_bmc
from .spm_mvb_cvk import spm_mvb_cvk
from .spm_mvb_cvk2 import spm_mvb_cvk2
from .spm_mvb_cvk_display import spm_mvb_cvk_display
from .spm_mvb_display import spm_mvb_display
from .spm_mvb_estimate import spm_mvb_estimate
from .spm_mvb_p import spm_mvb_p
from .spm_mvb_ui import spm_mvb_ui
from .spm_nCr import spm_nCr
from .spm_ncFcdf import spm_ncFcdf
from .spm_ncFpdf import spm_ncFpdf
from .spm_ncTcdf import spm_ncTcdf
from .spm_ncTpdf import spm_ncTpdf
from .spm_ndgrid import spm_ndgrid
from .spm_ness import spm_ness
from .spm_ness_GN import spm_ness_GN
from .spm_ness_J import spm_ness_J
from .spm_ness_Lap import spm_ness_Lap
from .spm_ness_N2Sp import spm_ness_N2Sp
from .spm_ness_Sp2N import spm_ness_Sp2N
from .spm_ness_Sp2p import spm_ness_Sp2p
from .spm_ness_U import spm_ness_U
from .spm_ness_cond import spm_ness_cond
from .spm_ness_flows import spm_ness_flows
from .spm_ness_hd import spm_ness_hd
from .spm_ness_m2S import spm_ness_m2S
from .spm_ness_p2Sp import spm_ness_p2Sp
from .spm_nlsi import spm_nlsi
from .spm_nlsi_AI import spm_nlsi_AI
from .spm_nlsi_GN import spm_nlsi_GN
from .spm_nlsi_GN_H import spm_nlsi_GN_H
from .spm_nlsi_LS import spm_nlsi_LS
from .spm_nlsi_N import spm_nlsi_N
from .spm_nlsi_Newton import spm_nlsi_Newton
from .spm_non_sphericity import spm_non_sphericity
from .spm_normrnd import spm_normrnd
from .spm_opm_amm import spm_opm_amm
from .spm_orientations import spm_orientations
from .spm_orth import spm_orth
from .spm_orthpoly import spm_orthpoly
from .__spm_orthviews import (
    spm_ov_browser,
    spm_ov_contour,
    spm_ov_display,
    spm_ov_goto_max,
    spm_ov_mesh,
    spm_ov_movie,
    spm_ov_reorient,
    spm_ov_rgb,
    spm_ov_roi,
    spm_ov_save,
    spm_ovhelper_3Dreg,
)
from .spm_orthviews import spm_orthviews
from .spm_padarray import spm_padarray
from .spm_parrec2nifti import spm_parrec2nifti
from .spm_peb_ppi import spm_peb_ppi
from .spm_percentile import spm_percentile
from .spm_perm_mtx import spm_perm_mtx
from .spm_permute_kron import spm_permute_kron
from .spm_pf import spm_pf
from .spm_phase_shuffle import spm_phase_shuffle
from .spm_phi import spm_phi
from .spm_phi_dot import spm_phi_dot
from .spm_pinv import spm_pinv
from .spm_platform import spm_platform
from .spm_plot_ci import spm_plot_ci
from .spm_plot_convergence import spm_plot_convergence
from .spm_polymtx import spm_polymtx
from .spm_powell import spm_powell
from .spm_preproc import spm_preproc
from .spm_preproc8 import spm_preproc8
from .spm_preproc_run import spm_preproc_run
from .spm_preproc_write8 import spm_preproc_write8
from .spm_print import spm_print
from .spm_progress_bar import spm_progress_bar
from .spm_project import spm_project
from .spm_psi import spm_psi
from .spm_rand_mar import spm_rand_mar
from .spm_rand_power_law import spm_rand_power_law
from .spm_read_netcdf import spm_read_netcdf
from .spm_read_vols import spm_read_vols
from .spm_realign import spm_realign
from .spm_regions import spm_regions
from .spm_reml import spm_reml
from .spm_reml_A import spm_reml_A
from .spm_reml_ancova import spm_reml_ancova
from .spm_reml_sc import spm_reml_sc
from .spm_render import spm_render
from .spm_render_vol import spm_render_vol
from .spm_reorder_contrasts import spm_reorder_contrasts
from .spm_resels import spm_resels
from .spm_resels_vol import spm_resels_vol
from .spm_reslice import spm_reslice
from .spm_results_nidm import spm_results_nidm
from .spm_results_ui import spm_results_ui
from .spm_rmpath import spm_rmpath
from .spm_robust_average import spm_robust_average
from .spm_robust_glm import spm_robust_glm
from .spm_s2csd import spm_s2csd
from .spm_sample_priors8 import spm_sample_priors8
from .spm_sample_vol import spm_sample_vol
from .spm_save import spm_save
from .spm_sde_dx import spm_sde_dx
from .spm_sdot import spm_sdot
from .spm_searchlight import spm_searchlight
from .spm_sections import spm_sections
from .spm_select import spm_select
from .spm_sepmul3d import spm_sepmul3d
from .spm_shp_get_model import spm_shp_get_model
from .spm_shp_get_transforms import spm_shp_get_transforms
from .spm_shp_install import spm_shp_install
from .spm_shp_project_velocity import spm_shp_project_velocity
from .spm_shp_sample_brains import spm_shp_sample_brains
from .spm_shp_sample_deformation import spm_shp_sample_deformation
from .spm_shp_transform_mesh import spm_shp_transform_mesh
from .spm_shp_transform_volume import spm_shp_transform_volume
from .spm_shp_warps import spm_shp_warps
from .spm_sixel import spm_sixel
from .spm_slice_timing import spm_slice_timing
from .spm_slice_vol import spm_slice_vol
from .spm_slm import spm_slm
from .spm_smohist import spm_smohist
from .spm_smooth import spm_smooth
from .spm_smoothkern import spm_smoothkern
from .spm_smoothto8bit import spm_smoothto8bit
from .spm_softmax import spm_softmax
from .spm_soreduce import spm_soreduce
from .spm_sp import spm_sp
from .spm_sp_reml import spm_sp_reml
from .spm_sparse_regression import spm_sparse_regression
from .spm_speye import spm_speye
from .spm_spm import spm_spm
from .spm_spm_Bayes import spm_spm_Bayes
from .spm_spm_Bayes_CY import spm_spm_Bayes_CY
from .spm_spm_Bayes_specify import spm_spm_Bayes_specify
from .spm_sptop import spm_sptop
from .spm_spy import spm_spy
from .spm_sqrtm import spm_sqrtm
from .spm_squeeze import spm_squeeze
from .spm_ssm2s import spm_ssm2s
from .spm_standalone import spm_standalone
from .spm_str_manip import spm_str_manip
from .spm_subfun import spm_subfun
from .spm_sum import spm_sum
from .spm_summarise import spm_summarise
from .spm_surf import spm_surf
from .spm_svd import spm_svd
from .spm_swarp import spm_swarp
from .spm_t2z import spm_t2z
from .spm_tests import spm_tests
from .spm_timeseries_resample import spm_timeseries_resample
from .spm_trace import spm_trace
from .spm_transverse import spm_transverse
from .spm_type import spm_type
from .spm_u import spm_u
from .spm_uc import spm_uc
from .spm_uc_Bonf import spm_uc_Bonf
from .spm_uc_FDR import spm_uc_FDR
from .spm_uc_RF import spm_uc_RF
from .spm_uc_clusterFDR import spm_uc_clusterFDR
from .spm_uc_peakFDR import spm_uc_peakFDR
from .spm_uitab import spm_uitab
from .spm_uncat import spm_uncat
from .spm_unlink import spm_unlink
from .spm_unvec import spm_unvec
from .spm_update import spm_update
from .spm_uw_apply import spm_uw_apply
from .spm_uw_estimate import spm_uw_estimate
from .spm_uw_get_image_def import spm_uw_get_image_def
from .spm_uw_show import spm_uw_show
from .spm_vb_F import spm_vb_F
from .spm_vb_Fn import spm_vb_Fn
from .spm_vb_a import spm_vb_a
from .spm_vb_adjacency import spm_vb_adjacency
from .spm_vb_alpha import spm_vb_alpha
from .spm_vb_beta import spm_vb_beta
from .spm_vb_contrasts import spm_vb_contrasts
from .spm_vb_edgeweights import spm_vb_edgeweights
from .spm_vb_gamma import spm_vb_gamma
from .spm_vb_get_Ab import spm_vb_get_Ab
from .spm_vb_get_Gn import spm_vb_get_Gn
from .spm_vb_get_R import spm_vb_get_R
from .spm_vb_glmar import spm_vb_glmar
from .spm_vb_graphcut import spm_vb_graphcut
from .spm_vb_incidence import spm_vb_incidence
from .spm_vb_init_block import spm_vb_init_block
from .spm_vb_lambda import spm_vb_lambda
from .spm_vb_logbf import spm_vb_logbf
from .spm_vb_models import spm_vb_models
from .spm_vb_neighbors import spm_vb_neighbors
from .spm_vb_ppm_anova import spm_vb_ppm_anova
from .spm_vb_regionF import spm_vb_regionF
from .spm_vb_robust import spm_vb_robust
from .spm_vb_roi_anova import spm_vb_roi_anova
from .spm_vb_roi_basis import spm_vb_roi_basis
from .spm_vb_set_priors import spm_vb_set_priors
from .spm_vb_spatial_precision import spm_vb_spatial_precision
from .spm_vb_taylor_R import spm_vb_taylor_R
from .spm_vb_w import spm_vb_w
from .spm_vec import spm_vec
from .spm_vecfun import spm_vecfun
from .spm_vol import spm_vol
from .spm_vol_nifti import spm_vol_nifti
from .spm_voronoi import spm_voronoi
from .spm_wft import spm_wft
from .spm_write_filtered import spm_write_filtered
from .spm_write_plane import spm_write_plane
from .spm_write_residuals import spm_write_residuals
from .spm_write_vol import spm_write_vol
from .spm_z2p import spm_z2p
from .spm_zeros import spm_zeros
from .__tests import (
    ROBOT_DCM_EEG,
    ROBOT_DCM_fMRI,
    ROBOT_DEM,
    end2end_attention,
    end2end_restingfMRI,
    spm_eeg_test_coverage,
    test_checkcode,
    test_gifti,
    test_regress_fmri_glm_dcm,
    test_regress_fmri_group,
    test_regress_spm_dcm_fmri,
    test_regress_spm_distort_mesh,
    test_regress_spm_opm,
    test_spm,
    test_spm_BMS_gibbs,
    test_spm_Ce,
    test_spm_Ncdf,
    test_spm_bireduce,
    test_spm_cat_struct,
    test_spm_cfg_dcm_est,
    test_spm_cfg_dcm_fmri,
    test_spm_cfg_dcm_peb,
    test_spm_create_vol,
    test_spm_dcm_bma,
    test_spm_dcm_bmr,
    test_spm_dcm_bmr_all,
    test_spm_dcm_bpa,
    test_spm_dcm_fit,
    test_spm_dcm_fmri_check,
    test_spm_dcm_fmri_csd,
    test_spm_dcm_identify,
    test_spm_dcm_loo,
    test_spm_dcm_peb,
    test_spm_dcm_peb_bmc,
    test_spm_dcm_peb_bmc_fam,
    test_spm_dcm_peb_review,
    test_spm_dcm_peb_to_gcm,
    test_spm_dcm_post_hoc,
    test_spm_dcm_simulate,
    test_spm_dcm_specify,
    test_spm_dctmtx,
    test_spm_eeg_average,
    test_spm_eeg_bc,
    test_spm_eeg_crop,
    test_spm_eeg_ffilter,
    test_spm_eeg_filter,
    test_spm_eeg_grandmean,
    test_spm_eeg_load,
    test_spm_eeg_merge,
    test_spm_fileparts,
    test_spm_filter,
    test_spm_gamrnd,
    test_spm_get_data,
    test_spm_get_lm,
    test_spm_invNcdf,
    test_spm_jsonread,
    test_spm_jsonwrite,
    test_spm_mar,
    test_spm_mesh_adjacency,
    test_spm_mesh_area,
    test_spm_mesh_borders,
    test_spm_mesh_contour,
    test_spm_mesh_dist,
    test_spm_mesh_edges,
    test_spm_mesh_euler,
    test_spm_mesh_geodesic,
    test_spm_mesh_get_lm,
    test_spm_mesh_label,
    test_spm_mesh_laplacian,
    test_spm_mesh_neighbours,
    test_spm_mesh_normals,
    test_spm_mesh_ray_intersect,
    test_spm_mesh_reduce,
    test_spm_mesh_refine,
    test_spm_mesh_sdf,
    test_spm_mesh_smooth,
    test_spm_mesh_sphere,
    test_spm_mesh_volume,
    test_spm_ncFcdf,
    test_spm_ncFpdf,
    test_spm_ncTcdf,
    test_spm_ncTpdf,
    test_spm_openmp,
    test_spm_opm_create,
    test_spm_opm_epoch_trigger,
    test_spm_opm_headmodel,
    test_spm_opm_hfc,
    test_spm_opm_psd,
    test_spm_opm_rpsd,
    test_spm_opm_sim,
    test_spm_opm_vslm,
    test_spm_platform,
    test_spm_plot_ci,
    test_spm_run_dcm_bms,
    test_spm_sum,
    test_spm_trace,
    test_spm_update,
    test_spm_z2p,
)
from .__toolbox import (
    dartel3,
    optimN,
    optimNn,
    optim_compat,
    spm_dartel_dotprods,
    spm_dartel_import,
    spm_dartel_invnorm,
    spm_dartel_jacobian,
    spm_dartel_kernel,
    spm_dartel_norm,
    spm_dartel_norm_fun,
    spm_dartel_resids,
    spm_dartel_smooth,
    spm_dartel_template,
    spm_dartel_warp,
    spm_klaff,
    spm_norm_population,
    tbx_cfg_dartel,
    bf_copy,
    bf_data,
    bf_features,
    bf_features_contcov,
    bf_features_cov,
    bf_features_cov_bysamples,
    bf_features_csd,
    bf_features_identity,
    bf_features_regmulticov,
    bf_features_tdcov,
    bf_features_vbfa,
    bf_group,
    bf_group_GALA,
    bf_group_batch,
    bf_group_functionalROI,
    bf_inverse,
    bf_inverse_champagne,
    bf_inverse_deflect,
    bf_inverse_dics,
    bf_inverse_ebb,
    bf_inverse_eloreta,
    bf_inverse_lcmv,
    bf_inverse_lcmv_multicov,
    bf_inverse_minimumnorm,
    bf_inverse_nutmeg,
    bf_isfield,
    bf_load,
    bf_output,
    bf_output_PLI,
    bf_output_image_cfGLM,
    bf_output_image_dics,
    bf_output_image_filtcorr,
    bf_output_image_gain,
    bf_output_image_kurtosis,
    bf_output_image_mv,
    bf_output_image_pac,
    bf_output_image_powcorr,
    bf_output_image_power,
    bf_output_image_sensitivity,
    bf_output_montage,
    bf_output_sourcedata_robust,
    bf_regularise_clifftrunc,
    bf_regularise_mantrunc,
    bf_regularise_manual,
    bf_regularise_minkatrunc,
    bf_regularise_roi,
    bf_regularise_tichonov_rankdef,
    bf_save,
    bf_save_path,
    bf_sources,
    bf_sources_grid,
    bf_sources_grid_phantom,
    bf_sources_mesh,
    bf_sources_mni_coords,
    bf_sources_scalp,
    bf_sources_voi,
    bf_stat_evoked_t,
    bf_std_fields,
    bf_view,
    bf_view_glass,
    bf_view_surface,
    bf_wizard_data,
    bf_wizard_features,
    bf_wizard_headmodel,
    bf_wizard_inverse,
    bf_wizard_output,
    bf_wizard_sources,
    bf_wizard_view,
    bf_wizard_write,
    bf_write,
    bf_write_gifti,
    bf_write_nifti,
    bf_write_spmeeg,
    spm_DAiSS,
    spm_beamforming,
    tbx_cfg_bf,
    ADEM_SHC_demo,
    ADEM_cost_SHC,
    ADEM_cued_response,
    ADEM_eyeblink,
    ADEM_learning,
    ADEM_lorenz,
    ADEM_lorenz_entropy,
    ADEM_lorenz_surprise,
    ADEM_motor,
    ADEM_mountaincar_loss,
    ADEM_observe,
    ADEM_occlusion,
    ADEM_occulomotor_delays,
    ADEM_plaid,
    ADEM_pursuit,
    ADEM_reaching,
    ADEM_salience,
    ADEM_sample_image,
    ADEM_visual,
    ADEM_writing,
    ALAP_demo_attenuation,
    DATA_COVID_JHU,
    DATA_COVID_UK,
    DATA_COVID_US,
    DATA_WID_data,
    DEMO_AI_NLSI,
    DEMO_BAYES_FACTORS,
    DEMO_BMR_PEB,
    DEMO_CVA_RSA,
    DEMO_DCM_MB,
    DEMO_DCM_PEB,
    DEMO_DCM_PEB_FIT,
    DEMO_GROUP_PEB,
    DEMO_Lindley_paradox,
    DEMO_MDP_Stroop,
    DEMO_MDP_Understanding,
    DEMO_MDP_maze,
    DEMO_MDP_maze_X,
    DEMO_MDP_questions,
    DEMO_MDP_voice,
    DEMO_SLR,
    DEMO_niche_construction,
    DEM_CLIMATE_India,
    DEM_COVID,
    DEM_COVID_AGE,
    DEM_COVID_COUNTRY,
    DEM_COVID_DASH,
    DEM_COVID_I,
    DEM_COVID_LTLA,
    DEM_COVID_S,
    DEM_COVID_T,
    DEM_COVID_UK,
    DEM_COVID_UK4,
    DEM_COVID_UTLA,
    DEM_COVID_WID,
    DEM_COVID_X,
    DEM_Dispatches,
    DEM_FEP_Least_Action,
    DEM_FEP_Lorenz,
    DEM_HB_and_LE,
    DEM_Immune,
    DEM_MDP_decision,
    DEM_SARS,
    DEM_SARS_I,
    DEM_Stephen,
    DEM_birdsong,
    DEM_cells,
    DEM_cells_cells,
    DEM_coupled_oscillators,
    DEM_dSprites,
    DEM_demo,
    DEM_demo_ALAP,
    DEM_demo_Bayesian_Model_Reduction,
    DEM_demo_Cornsweet,
    DEM_demo_DCM_LAP,
    DEM_demo_DEM,
    DEM_demo_DFP,
    DEM_demo_EM,
    DEM_demo_GF_and_KF,
    DEM_demo_GLM,
    DEM_demo_Gabor,
    DEM_demo_LAP,
    DEM_demo_Lagrangian,
    DEM_demo_Lagrangian_flow,
    DEM_demo_Lorenz,
    DEM_demo_MDP_DEM,
    DEM_demo_MDP_X,
    DEM_demo_MDP_XX,
    DEM_demo_MDP_fit,
    DEM_demo_MDP_fit_fields,
    DEM_demo_MDP_habits,
    DEM_demo_MDP_maze,
    DEM_demo_MDP_reading,
    DEM_demo_MDP_rule,
    DEM_demo_MDP_search,
    DEM_demo_MMN,
    DEM_demo_MMN_deviance,
    DEM_demo_MMN_gen,
    DEM_demo_OU,
    DEM_demo_PEB,
    DEM_demo_Posner,
    DEM_demo_SOC,
    DEM_demo_connectivity_fMRI,
    DEM_demo_contact_lens,
    DEM_demo_convolution,
    DEM_demo_convolution_LAP,
    DEM_demo_dendrite,
    DEM_demo_double_well,
    DEM_demo_doublewell_LAP,
    DEM_demo_duet,
    DEM_demo_fMRI_HMM,
    DEM_demo_fMRI_PEB,
    DEM_demo_face_inference,
    DEM_demo_factor_analysis,
    DEM_demo_filtering,
    DEM_demo_hdm,
    DEM_demo_hdm_LAP,
    DEM_demo_hdm_SCK,
    DEM_demo_hierarchical_optmisation,
    DEM_demo_induced_fMRI,
    DEM_demo_large_fMRI,
    DEM_demo_lorenz_LAP,
    DEM_demo_modes_fMRI,
    DEM_demo_ontology,
    DEM_demo_psychosis,
    DEM_demo_song_inference,
    DEM_demo_song_omission,
    DEM_demo_song_priors,
    DEM_demo_texture,
    DEM_evidence_accumulation,
    DEM_get_faces,
    DEM_morphogenesis,
    DEM_path_integrals,
    DEM_psychophysics,
    DEM_self_entropy,
    DEM_sharing,
    DEM_spatial_deconvolution,
    DEM_surveillance,
    DEM_vaccination,
    DFP_demo_double_well,
    DFP_demo_hdm,
    FEP_MB_demo,
    FEP_Manifold,
    FEP_fluctuations,
    FEP_information_length,
    FEP_lorenz_surprise,
    FEP_physics,
    FEP_self_entropy,
    KLDemo,
    MDP_DEM_Mixed_Models_Movement,
    MDP_DEM_Oculomotion_Pharma_demo,
    MDP_DEM_Oculomotion_demo,
    MDP_Heart_Beat,
    Markov_blankets_and_NESS,
    expmall,
    ndstest,
    spm_ADEM_cue_rt,
    spm_ADEM_set_rt,
    spm_CLIMATE_ci,
    spm_CLIMATE_gen,
    spm_CLIMATE_plot,
    spm_CLIMATE_priors,
    spm_COVID,
    spm_COVID_B,
    spm_COVID_BMR,
    spm_COVID_PV,
    spm_COVID_R_cii,
    spm_COVID_S,
    spm_COVID_SB,
    spm_COVID_T,
    spm_COVID_TS,
    spm_COVID_US,
    spm_COVID_Y,
    spm_COVID_ci,
    spm_COVID_dashboard,
    spm_COVID_gen,
    spm_COVID_plot,
    spm_COVID_priors,
    spm_COVID_priors_R,
    spm_COVID_table,
    spm_DEM_ButtonDownFcn,
    spm_DEM_EEG,
    spm_DEM_M,
    spm_DEM_MEG,
    spm_DEM_T,
    spm_DEM_basis,
    spm_DEM_movie,
    spm_DEM_play,
    spm_DEM_play_song,
    spm_DEM_qC,
    spm_Lap2Lorenz,
    spm_MDP,
    spm_MDP_DEM,
    spm_MDP_DP,
    spm_MDP_F,
    spm_MDP_G,
    spm_MDP_L,
    spm_MDP_VB,
    spm_MDP_VB_ERP,
    spm_MDP_VB_LFP,
    spm_MDP_VB_X,
    spm_MDP_VB_XX,
    spm_MDP_VB_XXX,
    spm_MDP_VB_game,
    spm_MDP_VB_sleep,
    spm_MDP_VB_trial,
    spm_MDP_VB_update,
    spm_MDP_check,
    spm_MDP_factor_graph,
    spm_MDP_game,
    spm_MDP_game_KL,
    spm_MDP_game_optimism,
    spm_MDP_link,
    spm_MDP_log_evidence,
    spm_MDP_mountain_car,
    spm_MDP_offer,
    spm_MDP_plot,
    spm_MDP_size,
    spm_MDP_structure_learning,
    spm_MDP_trust,
    spm_MDP_urn,
    spm_NESS_constraints,
    spm_SARS_ci,
    spm_SARS_gen,
    spm_SARS_plot,
    spm_SARS_priors,
    spm_SARS_priors_B,
    spm_SCK,
    spm_SHC_fx,
    spm_cornsweet,
    spm_cost_SHC_fx,
    spm_cost_SHC_fxa,
    spm_cost_SHC_path,
    spm_cost_fx,
    spm_cost_fxa,
    spm_dem_ERP,
    spm_dem_cue_movie,
    spm_dem_initialise,
    spm_dem_mdp_movie,
    spm_dem_occlusion_movie,
    spm_dem_pursuit_movie,
    spm_dem_reach_movie,
    spm_dem_reach_plot,
    spm_dem_reach_x2J,
    spm_dem_search_movie,
    spm_dem_search_plot,
    spm_dem_search_trajectory,
    spm_dem_set_movie,
    spm_diff_all,
    spm_find_internal,
    spm_fx_Gabor,
    spm_fx_Lagrangian,
    spm_fx_adem_cue,
    spm_fx_adem_pursuit,
    spm_fx_adem_reach,
    spm_fx_adem_salience,
    spm_fx_adem_write,
    spm_fx_dem_cue,
    spm_fx_dem_observe,
    spm_fx_dem_pursuit,
    spm_fx_dem_reach,
    spm_fx_dem_salience,
    spm_fx_dem_write,
    spm_fx_hdm_sck,
    spm_fx_mountaincar,
    spm_fx_mountaincar_Q,
    spm_gamma_log_evidence,
    spm_gx_Gabor,
    spm_gx_SHC,
    spm_gx_adem_cue,
    spm_gx_adem_pursuit,
    spm_gx_adem_reach,
    spm_gx_adem_salience,
    spm_gx_adem_write,
    spm_gx_dem_cue,
    spm_gx_dem_pursuit,
    spm_gx_dem_reach,
    spm_gx_dem_salience,
    spm_gx_dem_write,
    spm_gx_hdm_sck,
    spm_ho_gm,
    spm_ho_poly,
    spm_immune,
    spm_immune_gen,
    spm_immune_plot,
    spm_immune_priors,
    spm_mc_fx,
    spm_mc_fx_1,
    spm_mc_fx_2,
    spm_mc_fx_3,
    spm_mc_fx_4,
    spm_mc_fx_5,
    spm_mc_fxa_4,
    spm_mc_fxa_5,
    spm_mc_loss_C,
    spm_mc_loss_G,
    spm_meta_model,
    spm_mountaincar_Q,
    spm_mountaincar_fun,
    spm_mountaincar_movie,
    spm_multinomial_log_evidence,
    spm_salience_map,
    spm_voice,
    spm_voice_FS,
    spm_voice_P300,
    spm_voice_Q,
    spm_voice_check,
    spm_voice_dct,
    spm_voice_ff,
    spm_voice_filter,
    spm_voice_frequency,
    spm_voice_fundamental,
    spm_voice_get_LEX,
    spm_voice_get_next,
    spm_voice_get_word,
    spm_voice_get_xY,
    spm_voice_i,
    spm_voice_iQ,
    spm_voice_identity,
    spm_voice_iff,
    spm_voice_likelihood,
    spm_voice_onset,
    spm_voice_onsets,
    spm_voice_read,
    spm_voice_repeat,
    spm_voice_segmentation,
    spm_voice_speak,
    spm_voice_test,
    spm_voice_warp,
    FieldMap,
    FieldMap_Run,
    FieldMap_applyvdm,
    FieldMap_create,
    FieldMap_preprocess,
    pm_angvar,
    pm_brain_mask,
    pm_create_connectogram,
    pm_diff,
    pm_estimate_ramp,
    pm_ff_unwrap,
    pm_get_defaults,
    pm_initial_regions,
    pm_invert_phasemap,
    pm_make_fieldmap,
    pm_mask,
    pm_merge_regions,
    pm_merge_regions_m,
    pm_pad,
    pm_restore_ramp,
    pm_seed,
    pm_smooth_phasemap,
    pm_unwrap,
    tbx_cfg_fieldmap,
    spm_compute_avg_mat,
    spm_dexpm,
    spm_groupwise_ls,
    spm_meanm,
    spm_noise_estimate,
    spm_pairwise,
    spm_rice_mixture,
    spm_series_align,
    tbx_cfg_longitudinal,
    fil_fit,
    fil_install,
    fil_io,
    fil_label,
    fil_prec,
    fil_prune,
    fil_push_train_data,
    fil_subvol,
    fil_train,
    spm_label,
    spm_mb_appearance,
    spm_mb_classes,
    spm_mb_fit,
    spm_mb_gmm,
    spm_mb_init,
    spm_mb_io,
    spm_mb_merge,
    spm_mb_output,
    spm_mb_shape,
    spm_mbnorm,
    tbx_cfg_mb,
    spm_MEEGtools,
    spm_create_labels,
    spm_eeg_bst_fooof,
    spm_eeg_cont_power,
    spm_eeg_ctf_synth_gradiometer,
    spm_eeg_dipole_waveforms,
    spm_eeg_erp_correction,
    spm_eeg_ffilter,
    spm_eeg_fix_ctf_headloc,
    spm_eeg_ft_artefact_visual,
    spm_eeg_ft_datareg_manual,
    spm_eeg_ft_megplanar,
    spm_eeg_ft_multitaper_coherence,
    spm_eeg_headplot,
    spm_eeg_img2maps,
    spm_eeg_interpolate_artefact,
    spm_eeg_inv_optireg,
    spm_eeg_megheadloc,
    spm_eeg_recode_epoched_ctf,
    spm_eeg_remove_jumps,
    spm_eeg_remove_spikes,
    spm_eeg_reref_eeg,
    spm_eeg_split_conditions,
    spm_eeg_tms_correct,
    spm_eeg_transform_cap,
    spm_eeg_var_measures,
    spm_mesh_pack_points,
    spm_opm_create,
    spm_opm_epoch_trigger,
    spm_opm_headmodel,
    spm_opm_hfc,
    spm_opm_opreg,
    spm_opm_plotScalpData,
    spm_opm_psd,
    spm_opm_read_lvm,
    spm_opm_rpsd,
    spm_opm_sim,
    spm_opm_synth_gradiometer,
    spm_opm_vslm,
    spm_dcm_nvc,
    spm_dcm_nvc_nd,
    spm_dcm_nvc_priors,
    spm_dcm_nvc_specify,
    spm_fx_cmc_tfm_gen,
    spm_gen_par,
    spm_nvc_gen,
    DEMO_dcm_fmri_nnm,
    DEMO_model_reduction_ERP,
    DEMO_tvec_csd_sim,
    DEMO_tvec_erp_mmn,
    DEMO_tvec_erp_sim,
    spm_csd_mtf_plot_pole_zero,
    spm_dcm_x_neural_NMDA,
    spm_fx_NMDA,
    spm_fx_mfm_NMDA,
    spm_lfp_mtf_sample,
    spm_nmm_priors_NMDA,
    spm_x_mfm_NMDA,
    Neural_demo,
    ROBOT_NMM,
    spm_csd_demo,
    spm_dcm_Granger_asymmetry_demo,
    spm_dcm_Granger_demo,
    spm_dcm_prior_responses,
    spm_delays_demo,
    spm_demo_proceed,
    spm_erp2csd_demo,
    spm_freqs,
    spm_fx_hh,
    spm_fx_lfp,
    spm_fx_mfm_ensemble,
    spm_gx_hh,
    spm_gx_mfm,
    spm_ind_demo,
    spm_induced_optimise,
    spm_induced_optimise_parameters,
    spm_lfp_demo,
    spm_lfp_log,
    spm_lfp_mtf,
    spm_lfp_priors,
    spm_lfp_sqrt,
    spm_mfa,
    spm_mfa_G,
    spm_mfa_bi,
    spm_mfa_bi_multi,
    spm_mfa_demo,
    spm_mfm_demo,
    spm_mtf_demo,
    spm_neil,
    spm_nested_oscillations_demo,
    spm_nmda_priors,
    spm_opt_bfun,
    spm_seizure_demo,
    spm_sigmoid_demo,
    spm_affreg,
    spm_brainwarp,
    spm_cfg_normalise,
    spm_get_orig_coord,
    spm_normalise,
    spm_normalise_disp,
    spm_run_normalise,
    spm_write_sn,
    spm_cfg_preproc,
    spm_invdef,
    spm_load_priors,
    spm_maff,
    spm_prep2sn,
    spm_preproc_write,
    spm_run_preproc,
    spm_sample_priors,
    spm_SEM_gen,
    spm_SEM_gen_full,
    spm_dcm_spem,
    spm_dcm_spem_data,
    spm_dcm_spem_results,
    spm_sextract,
    spm_srender,
    tbx_cfg_render,
    covLin,
    spm_GPclass,
    spm_def2sparse,
    spm_dotprods2,
    spm_lincom,
    spm_shoot3d,
    spm_shoot3di,
    spm_shoot_blur,
    spm_shoot_defaults,
    spm_shoot_divergence,
    spm_shoot_greens,
    spm_shoot_kernel,
    spm_shoot_norm,
    spm_shoot_scalmom,
    spm_shoot_template,
    spm_shoot_update,
    spm_shoot_warp,
    tbx_cfg_shoot,
    lbessi,
    pp_settings,
    pull,
    pullg,
    push,
    spm_TVdenoise,
    spm_TVdenoise2,
    spm_TVdenoise_config,
    spm_dctdst,
    spm_run_denoise,
    spm_scope,
    spm_scope_config,
    spm_slice2vol,
    spm_slice2vol_config,
    spm_slice2vol_estimate,
    spm_slice2vol_reslice,
    spm_topup,
    spm_topup_config,
    tbx_cfg_spatial,
    tbx_cfg_tsss,
    tsss_config,
    tsss_config_momentspace,
    tsss_spm_enm,
    tsss_spm_momentspace,
    estimate_greens_mmclab,
    spm_dcm_fnirs_estimate,
    spm_dcm_fnirs_params,
    spm_dcm_fnirs_priors,
    spm_dcm_fnirs_specify,
    spm_dcm_fnirs_viewer_result,
    spm_fnirs_sensitivity,
    spm_fnirs_viewer_sensor,
    spm_fnirs_wavg,
    spm_fx_fnirs,
    spm_gx_fnirs,
    spm_gx_state_fnirs,
    spm_L_priors,
    spm_api_erp,
    spm_api_nmm,
    spm_bgt_priors,
    spm_cmc_priors,
    spm_cmm_NMDA_priors,
    spm_cmm_priors,
    spm_csd_chf,
    spm_csd_int,
    spm_csd_int_IS,
    spm_csd_mtf,
    spm_csd_mtf_gu,
    spm_dcm_csd,
    spm_dcm_csd_data,
    spm_dcm_csd_plot,
    spm_dcm_csd_priors,
    spm_dcm_csd_results,
    spm_dcm_csd_source_optimise,
    spm_dcm_csd_source_plot,
    spm_dcm_dem,
    spm_dcm_eeg_channelmodes,
    spm_dcm_erp,
    spm_dcm_erp_bma,
    spm_dcm_erp_data,
    spm_dcm_erp_dipfit,
    spm_dcm_erp_plot,
    spm_dcm_erp_results,
    spm_dcm_erp_sensitivity,
    spm_dcm_erp_update,
    spm_dcm_erp_viewspatial,
    spm_dcm_ind,
    spm_dcm_ind_data,
    spm_dcm_ind_results,
    spm_dcm_local_minima,
    spm_dcm_lock,
    spm_dcm_neural_priors,
    spm_dcm_neural_x,
    spm_dcm_nfm,
    spm_dcm_phase,
    spm_dcm_phase_data,
    spm_dcm_phase_results,
    spm_dcm_search_eeg,
    spm_dcm_ssr,
    spm_dcm_ssr_data,
    spm_dcm_ssr_results,
    spm_dcm_symm,
    spm_dcm_tfm,
    spm_dcm_tfm_data,
    spm_dcm_tfm_data_nopad,
    spm_dcm_tfm_image,
    spm_dcm_tfm_multimodal,
    spm_dcm_tfm_response,
    spm_dcm_tfm_results,
    spm_dcm_tfm_transfer,
    spm_dcm_virtual_electrodes,
    spm_dcm_x_neural,
    spm_eeg_inv_ecd_DrawDip,
    spm_epileptor_demo,
    spm_erp_L,
    spm_erp_priors,
    spm_erp_u,
    spm_fp_cmc_tfm,
    spm_fs_csd,
    spm_fx_bgt,
    spm_fx_cmc,
    spm_fx_cmc_2014,
    spm_fx_cmc_tfm,
    spm_fx_cmm,
    spm_fx_cmm_NMDA,
    spm_fx_erp,
    spm_fx_gen,
    spm_fx_ind,
    spm_fx_mfm,
    spm_fx_mfm_D,
    spm_fx_mmc,
    spm_fx_nmda,
    spm_fx_null,
    spm_fx_phase,
    spm_fx_sep,
    spm_fx_tfm,
    spm_fx_tfm_P,
    spm_fy_erp,
    spm_gen_Q,
    spm_gen_erp,
    spm_gen_ind,
    spm_gen_phase,
    spm_gx_erp,
    spm_ind_priors,
    spm_int_U,
    spm_lx_dem,
    spm_lx_erp,
    spm_lx_ind,
    spm_lx_phase,
    spm_mg_switch,
    spm_mmc_priors,
    spm_nfm_mtf,
    spm_nfm_priors,
    spm_nmm_priors,
    spm_null_priors,
    spm_phase_priors,
    spm_ssr_priors,
    spm_tfm_priors,
    spm_x_cmc,
    spm_x_cmm,
    spm_x_cmm_NMDA,
    spm_x_erp,
    spm_x_lfp,
    spm_x_mfm,
    spm_x_nmda,
    spm_x_nmm,
    mci_compare_forward,
    mci_compare_gradients,
    mci_compare_jacobians,
    mci_compare_setup,
    spm_mci_adjoint,
    spm_mci_adjoint_int,
    spm_mci_adjoint_sun,
    spm_mci_flow_sun,
    spm_mci_flow_t,
    spm_mci_fwd,
    spm_mci_grad_curve,
    spm_mci_joint,
    spm_mci_joint_grad,
    spm_mci_sens,
    spm_mci_sens_init,
    spm_mci_sens_sun,
    spm_mci_ais,
    spm_mci_ais_single,
    spm_mci_ais_single_vl,
    spm_mci_check,
    spm_mci_diag,
    spm_mci_diff,
    spm_mci_ess,
    spm_mci_fixed,
    spm_mci_glike,
    spm_mci_glike_deriv,
    spm_mci_gprior_deriv,
    spm_mci_init_flow,
    spm_mci_isvl,
    spm_mci_lgv,
    spm_mci_lgv_vl,
    spm_mci_like_ind,
    spm_mci_mfx,
    spm_mci_mfx_dynamic,
    spm_mci_mh,
    spm_mci_mh_update,
    spm_mci_minit,
    spm_mci_mvnpost,
    spm_mci_mvntest,
    spm_mci_obsnoise,
    spm_mci_phm,
    spm_mci_pop,
    spm_mci_popdef,
    spm_mci_post,
    spm_mci_postslices,
    spm_mci_priors,
    spm_mci_quantiles,
    spm_mci_random,
    spm_mci_report,
    spm_mci_stat,
    spm_mci_switch,
    spm_mci_switch_prep,
    spm_mci_update_cov,
    spm_mci_vw_init,
    spm_mvtpdf,
    spm_nwcov,
    spm_nwpost,
    spm_nwrnd,
    spm_wishrnd,
    mci_approach_deriv,
    mci_approach_gen,
    mci_approach_like,
    mci_approach_struct,
    mci_discount_act,
    mci_discount_deriv,
    mci_discount_gen,
    mci_discount_like,
    mci_discount_struct,
    mci_pb_deriv,
    mci_pb_gen,
    mci_pb_like,
    mci_pb_struct,
    mci_exp_init,
    mci_interp_init,
    mci_lds_dfdx,
    mci_lds_fx,
    mci_lds_gen,
    mci_lds_group_data,
    mci_lds_gx,
    mci_lds_lat2par,
    mci_lds_par2lat,
    mci_lds_params,
    mci_lds_plot_params,
    mci_lds_struct,
    mci_linear_deriv,
    mci_linear_gen,
    mci_linear_like,
    mci_linear_post,
    mci_linear_struct,
    mci_linsqr_deriv,
    mci_linsqr_gen,
    mci_linsqr_like,
    mci_linsqr_struct,
    mci_logistic_act,
    mci_logistic_deriv,
    mci_logistic_gen,
    mci_logistic_like,
    mci_logistic_struct,
    mci_nmm_fx_delay,
    mci_nmm_gen,
    mci_nmm_params,
    mci_nmm_r2_gx,
    mci_nmm_r2p2_dfdp,
    mci_nmm_r2p2_dfdx,
    mci_nmm_r2p2_fx,
    mci_nmm_r2p6_fx,
    mci_nmm_struct,
    mci_phase_dfdp,
    mci_phase_dfdx,
    mci_phase_fx,
    mci_phase_gx,
    mci_phase_init,
    mci_rphase_dfdp,
    mci_rphase_dfdx,
    mci_rphase_fx,
    mci_rphase_gen,
    mci_rphase_struct,
    mci_ramsay_fx,
    mci_ramsay_gen,
    mci_ramsay_gx,
    mci_ramsay_struct,
    mci_plot_surface,
    spm_MNpdf,
    spm_boxcars,
    spm_glm,
    spm_kmeans,
    spm_kmeans1,
    spm_mix,
    spm_mix_demo1d,
    spm_rglm,
    spm_samp_gauss,
    spm_samp_mix,
    spm_cva_compare,
    spm_cva_prob,
    spm_mlm_bayes,
    spm_mlm_makecon,
    spm_mlm_posthoc,
    spm_pca_order,
    spm_vpca,
    spm_vpca_f,
    spm_vpca_init,
    spm_vpca_update,
    spm_ar,
    spm_ar_freq,
    spm_ar_pred,
    spm_ccf2coh,
    spm_ccf2cor,
    spm_ccf2csd,
    spm_ccf2gew,
    spm_ccf2mar,
    spm_csd,
    spm_csd2ccf,
    spm_csd2coh,
    spm_csd2gew,
    spm_csd2mar,
    spm_dcm2ssm,
    spm_dpss,
    spm_dtf2gew,
    spm_get_omega,
    spm_granger,
    spm_ker2ccf,
    spm_ker2coh,
    spm_ker2csd,
    spm_ker2mtf,
    spm_kl_eig_normal,
    spm_mar,
    spm_mar2ccf,
    spm_mar2coh,
    spm_mar2csd,
    spm_mar2gew,
    spm_mar_conn,
    spm_mar_gen,
    spm_mar_pred,
    spm_mar_prior,
    spm_mar_spectra,
    spm_mmtspec,
    spm_mtf2ccf,
    spm_mtf2coh,
    spm_mtf2csd,
    spm_mtf2gew,
    spm_rar,
    spm_spectral_plot,
    spm_ssm2ccf,
    spm_ssm2coh,
    spm_ssm2csd,
    spm_ssm2ker,
    spm_ssm2mtf,
    spm_wavspec,
)


__all__ = [
    "Runtime",
    "MatlabClass",
    "MatlabFunction",
    "Cell",
    "Struct",
    "Array",
    "SparseArray",
    "__version__",
    "file_array",
    "gifti",
    "meeg",
    "nifti",
    "slover",
    "xmltree",
    "loadxml",
    "savexml",
    "spm_add",
    "spm_adjmean_fmri_ui",
    "spm_adjmean_ui",
    "spm_atranspa",
    "spm_chi2_plot",
    "spm_digamma",
    "spm_dirichlet",
    "spm_eeval",
    "spm_fMRI_design_show",
    "spm_imcalc_ui",
    "spm_load_float",
    "spm_matlab_version_chk",
    "spm_mean",
    "spm_mean_ui",
    "spm_read_hdr",
    "spm_resss",
    "spm_spm_ui",
    "spm_tbx_config2cfg",
    "cfg_mlbatch_appcfg",
    "spm_cfg",
    "spm_cfg_bbox",
    "spm_cfg_bms_map",
    "spm_cfg_cat",
    "spm_cfg_cdir",
    "spm_cfg_checkreg",
    "spm_cfg_con",
    "spm_cfg_coreg",
    "spm_cfg_dcm_bms",
    "spm_cfg_dcm_est",
    "spm_cfg_dcm_fmri",
    "spm_cfg_dcm_meeg",
    "spm_cfg_dcm_peb",
    "spm_cfg_deface",
    "spm_cfg_deformations",
    "spm_cfg_dicom",
    "spm_cfg_disp",
    "spm_cfg_ecat",
    "spm_cfg_eeg",
    "spm_cfg_eeg_artefact",
    "spm_cfg_eeg_average",
    "spm_cfg_eeg_avgfreq",
    "spm_cfg_eeg_avgtime",
    "spm_cfg_eeg_bc",
    "spm_cfg_eeg_cfc",
    "spm_cfg_eeg_channel_selector",
    "spm_cfg_eeg_collapse_timefreq",
    "spm_cfg_eeg_combineplanar",
    "spm_cfg_eeg_contrast",
    "spm_cfg_eeg_convert",
    "spm_cfg_eeg_convert2images",
    "spm_cfg_eeg_copy",
    "spm_cfg_eeg_correct_sensor_data",
    "spm_cfg_eeg_crop",
    "spm_cfg_eeg_delete",
    "spm_cfg_eeg_dipfit",
    "spm_cfg_eeg_downsample",
    "spm_cfg_eeg_epochs",
    "spm_cfg_eeg_filter",
    "spm_cfg_eeg_firstlevel",
    "spm_cfg_eeg_fuse",
    "spm_cfg_eeg_grandmean",
    "spm_cfg_eeg_inv_coregshift",
    "spm_cfg_eeg_inv_extract",
    "spm_cfg_eeg_inv_headmodel",
    "spm_cfg_eeg_inv_headmodelhelmet",
    "spm_cfg_eeg_inv_invert",
    "spm_cfg_eeg_inv_invertiter",
    "spm_cfg_eeg_inv_mix",
    "spm_cfg_eeg_inv_optimize",
    "spm_cfg_eeg_inv_patchdef",
    "spm_cfg_eeg_inv_post",
    "spm_cfg_eeg_inv_prepro",
    "spm_cfg_eeg_inv_priors",
    "spm_cfg_eeg_inv_results",
    "spm_cfg_eeg_inv_sensorshift",
    "spm_cfg_eeg_inv_simulate",
    "spm_cfg_eeg_merge",
    "spm_cfg_eeg_momentfit",
    "spm_cfg_eeg_montage",
    "spm_cfg_eeg_opmsetup",
    "spm_cfg_eeg_prepare",
    "spm_cfg_eeg_reduce",
    "spm_cfg_eeg_regressors",
    "spm_cfg_eeg_remove_bad_trials",
    "spm_cfg_eeg_review",
    "spm_cfg_eeg_shp_distort",
    "spm_cfg_eeg_shp_gainmat",
    "spm_cfg_eeg_spatial_confounds",
    "spm_cfg_eeg_tf",
    "spm_cfg_eeg_tf_rescale",
    "spm_cfg_exp_frames",
    "spm_cfg_factorial_design",
    "spm_cfg_fmri_data",
    "spm_cfg_fmri_design",
    "spm_cfg_fmri_est",
    "spm_cfg_fmri_spec",
    "spm_cfg_imcalc",
    "spm_cfg_md",
    "spm_cfg_mfx",
    "spm_cfg_minc",
    "spm_cfg_model_review",
    "spm_cfg_norm",
    "spm_cfg_opm_create",
    "spm_cfg_opm_epoch_trigger",
    "spm_cfg_opm_read_lvm",
    "spm_cfg_opm_synth_gradiometer",
    "spm_cfg_parrec",
    "spm_cfg_ppi",
    "spm_cfg_preproc8",
    "spm_cfg_print",
    "spm_cfg_realign",
    "spm_cfg_realignunwarp",
    "spm_cfg_render",
    "spm_cfg_reorient",
    "spm_cfg_results",
    "spm_cfg_sendmail",
    "spm_cfg_setlevel",
    "spm_cfg_smooth",
    "spm_cfg_split",
    "spm_cfg_st",
    "spm_cfg_static_tools",
    "spm_cfg_tissue_volumes",
    "spm_cfg_voi",
    "spm_make_standalone",
    "spm_markdown",
    "spm_rewrite_job",
    "spm_run_bms_map",
    "spm_run_bms_vis",
    "spm_run_con",
    "spm_run_coreg",
    "spm_run_dcm_bms",
    "spm_run_dcm_bms_vis",
    "spm_run_dicom",
    "spm_run_factorial_design",
    "spm_run_fmri_data",
    "spm_run_fmri_est",
    "spm_run_fmri_spec",
    "spm_run_norm",
    "spm_run_realign",
    "spm_run_realignunwarp",
    "spm_run_reorient",
    "spm_run_results",
    "spm_run_setlevel",
    "spm_run_smooth",
    "spm_run_st",
    "spm_run_tissue_volumes",
    "spm_run_voi",
    "bemcp_example",
    "addCTFtrial",
    "getCTFdata",
    "readCPersist",
    "readCTFMRI",
    "readCTFds",
    "readCTFhdm",
    "setCTFDataBalance",
    "writeCTFMRI",
    "writeCTFds",
    "writeCTFhdm",
    "writeMarkerFile",
    "writeRes4",
    "read_eep_avr",
    "read_eep_cnt",
    "read_eep_rej",
    "read_eep_trg",
    "read_eep_trial",
    "write_eep_avr",
    "write_eep_cnt",
    "besa2fieldtrip",
    "bis2fieldtrip",
    "ft_connectivity_cancorr",
    "ft_connectivity_corr",
    "ft_connectivity_csd2transfer",
    "ft_connectivity_dtf",
    "ft_connectivity_granger",
    "ft_connectivity_mim",
    "ft_connectivity_mutualinformation",
    "ft_connectivity_pdc",
    "ft_connectivity_plm",
    "ft_connectivity_powcorr_ortho",
    "ft_connectivity_ppc",
    "ft_connectivity_psi",
    "ft_connectivity_wpli",
    "data2bids",
    "edf2fieldtrip",
    "uimage",
    "uimagesc",
    "rgb2hsv",
    "boxcar",
    "flattopwin",
    "hanning",
    "hilbert",
    "binocdf",
    "binopdf",
    "common_size",
    "mvnrnd",
    "nanvar",
    "range_",
    "tcdf",
    "tinv",
    "fieldtrip2besa",
    "fieldtrip2bis",
    "fieldtrip2ctf",
    "fieldtrip2fiff",
    "fieldtrip2homer",
    "fieldtrip2spss",
    "ft_chantype",
    "ft_chanunit",
    "ft_create_buffer",
    "ft_destroy_buffer",
    "ft_filetype",
    "ft_filter_event",
    "ft_flush_data",
    "ft_flush_event",
    "ft_flush_header",
    "ft_poll_buffer",
    "ft_read_atlas",
    "ft_read_cifti",
    "ft_read_data",
    "ft_read_event",
    "ft_read_header",
    "ft_read_headmodel",
    "ft_read_headshape",
    "ft_read_json",
    "ft_read_mri",
    "ft_read_sens",
    "ft_read_spike",
    "ft_read_tsv",
    "ft_read_vol",
    "ft_write_cifti",
    "ft_write_data",
    "ft_write_event",
    "ft_write_headshape",
    "ft_write_json",
    "ft_write_mri",
    "ft_write_sens",
    "ft_write_spike",
    "ft_write_tsv",
    "ft_apply_montage",
    "ft_compute_leadfield",
    "ft_convert_units",
    "ft_determine_units",
    "ft_estimate_units",
    "ft_headmodel_asa",
    "ft_headmodel_bemcp",
    "ft_headmodel_concentricspheres",
    "ft_headmodel_dipoli",
    "ft_headmodel_duneuro",
    "ft_headmodel_fns",
    "ft_headmodel_halfspace",
    "ft_headmodel_infinite",
    "ft_headmodel_interpolate",
    "ft_headmodel_localspheres",
    "ft_headmodel_openmeeg",
    "ft_headmodel_simbio",
    "ft_headmodel_singleshell",
    "ft_headmodel_singlesphere",
    "ft_headmodel_slab",
    "ft_headmodeltype",
    "ft_inside_headmodel",
    "ft_prepare_vol_sens",
    "ft_senslabel",
    "ft_senstype",
    "ft_sourcedepth",
    "ft_analysispipeline",
    "ft_annotate",
    "ft_anonymizedata",
    "ft_appenddata",
    "ft_appendfreq",
    "ft_appendlayout",
    "ft_appendsens",
    "ft_appendsource",
    "ft_appendspike",
    "ft_appendtimelock",
    "ft_artifact_clip",
    "ft_artifact_ecg",
    "ft_artifact_eog",
    "ft_artifact_jump",
    "ft_artifact_muscle",
    "ft_artifact_nan",
    "ft_artifact_threshold",
    "ft_artifact_tms",
    "ft_artifact_zvalue",
    "ft_audiovideobrowser",
    "ft_badchannel",
    "ft_baddata",
    "ft_badsegment",
    "ft_channelnormalise",
    "ft_channelrepair",
    "ft_clusterplot",
    "ft_combineplanar",
    "ft_componentanalysis",
    "ft_conjunctionanalysis",
    "ft_connectivityanalysis",
    "ft_connectivityplot",
    "ft_connectivitysimulation",
    "ft_crossfrequencyanalysis",
    "ft_databrowser",
    "ft_defacemesh",
    "ft_defacevolume",
    "ft_defaults",
    "ft_definetrial",
    "ft_denoise_amm",
    "ft_denoise_dssp",
    "ft_denoise_hfc",
    "ft_denoise_pca",
    "ft_denoise_prewhiten",
    "ft_denoise_ssp",
    "ft_denoise_sss",
    "ft_denoise_synthetic",
    "ft_denoise_tsr",
    "ft_detect_movement",
    "ft_dipolefitting",
    "ft_dipolesimulation",
    "ft_electrodeplacement",
    "ft_electroderealign",
    "ft_electrodermalactivity",
    "ft_eventtiminganalysis",
    "ft_examplefunction",
    "ft_freqanalysis",
    "ft_freqanalysis_mvar",
    "ft_freqbaseline",
    "ft_freqdescriptives",
    "ft_freqgrandaverage",
    "ft_freqinterpolate",
    "ft_freqsimulation",
    "ft_freqstatistics",
    "ft_geometryplot",
    "ft_globalmeanfield",
    "ft_headcircumference",
    "ft_headmovement",
    "ft_heartrate",
    "ft_interactiverealign",
    "ft_interpolatenan",
    "ft_lateralizedpotential",
    "ft_layoutplot",
    "ft_math",
    "ft_megplanar",
    "ft_megrealign",
    "ft_meshrealign",
    "ft_movieplotER",
    "ft_movieplotTFR",
    "ft_multiplotCC",
    "ft_multiplotER",
    "ft_multiplotTFR",
    "ft_mvaranalysis",
    "ft_neighbourplot",
    "ft_networkanalysis",
    "ft_prepare_headmodel",
    "ft_prepare_layout",
    "ft_prepare_leadfield",
    "ft_prepare_mesh",
    "ft_prepare_montage",
    "ft_prepare_neighbours",
    "ft_prepare_sourcemodel",
    "ft_preprocessing",
    "ft_recodeevent",
    "ft_redefinetrial",
    "ft_regressconfound",
    "ft_rejectartifact",
    "ft_rejectcomponent",
    "ft_rejectvisual",
    "ft_removetemplateartifact",
    "ft_reproducescript",
    "ft_resampledata",
    "ft_respiration",
    "ft_scalpcurrentdensity",
    "ft_singleplotER",
    "ft_singleplotTFR",
    "ft_sliceinterp",
    "ft_sourceanalysis",
    "ft_sourcedescriptives",
    "ft_sourcegrandaverage",
    "ft_sourceinterpolate",
    "ft_sourcemovie",
    "ft_sourceparcellate",
    "ft_sourceplot",
    "ft_sourceplot_interactive",
    "ft_sourcestatistics",
    "ft_sourcewrite",
    "ft_statistics_analytic",
    "ft_statistics_crossvalidate",
    "ft_statistics_montecarlo",
    "ft_statistics_mvpa",
    "ft_statistics_stats",
    "ft_steadystatesimulation",
    "ft_stratify",
    "ft_timelockanalysis",
    "ft_timelockbaseline",
    "ft_timelockgrandaverage",
    "ft_timelocksimulation",
    "ft_timelockstatistics",
    "ft_topoplotCC",
    "ft_topoplotER",
    "ft_topoplotIC",
    "ft_topoplotTFR",
    "ft_virtualchannel",
    "ft_volumebiascorrect",
    "ft_volumedownsample",
    "ft_volumelookup",
    "ft_volumenormalise",
    "ft_volumerealign",
    "ft_volumereslice",
    "ft_volumesegment",
    "ft_volumewrite",
    "ft_wizard",
    "homer2fieldtrip",
    "imotions2fieldtrip",
    "ft_inverse_dics",
    "ft_inverse_dipolefit",
    "ft_inverse_eloreta",
    "ft_inverse_harmony",
    "ft_inverse_lcmv",
    "ft_inverse_mne",
    "ft_inverse_music",
    "ft_inverse_pcc",
    "ft_inverse_rv",
    "ft_inverse_sam",
    "ft_inverse_sloreta",
    "loreta2fieldtrip",
    "nutmeg2fieldtrip",
    "ft_colormap",
    "ft_plot_axes",
    "ft_plot_box",
    "ft_plot_cloud",
    "ft_plot_crosshair",
    "ft_plot_dipole",
    "ft_plot_headmodel",
    "ft_plot_headshape",
    "ft_plot_layout",
    "ft_plot_line",
    "ft_plot_matrix",
    "ft_plot_mesh",
    "ft_plot_montage",
    "ft_plot_ortho",
    "ft_plot_patch",
    "ft_plot_sens",
    "ft_plot_slice",
    "ft_plot_text",
    "ft_plot_topo",
    "ft_plot_topo3d",
    "ft_plot_vector",
    "ft_select_box",
    "ft_select_channel",
    "ft_select_point",
    "ft_select_point3d",
    "ft_select_range",
    "ft_select_voxel",
    "ft_uilayout",
    "ft_preproc_bandpassfilter",
    "ft_preproc_bandstopfilter",
    "ft_preproc_baselinecorrect",
    "ft_preproc_denoise",
    "ft_preproc_derivative",
    "ft_preproc_detrend",
    "ft_preproc_dftfilter",
    "ft_preproc_highpassfilter",
    "ft_preproc_hilbert",
    "ft_preproc_lowpassfilter",
    "ft_preproc_medianfilter",
    "ft_preproc_online_downsample_apply",
    "ft_preproc_online_downsample_init",
    "ft_preproc_online_filter_apply",
    "ft_preproc_online_filter_init",
    "ft_preproc_padding",
    "ft_preproc_polyremoval",
    "ft_preproc_rectify",
    "ft_preproc_rereference",
    "ft_preproc_resample",
    "ft_preproc_slidingrange",
    "ft_preproc_smooth",
    "ft_preproc_standardize",
    "spass2fieldtrip",
    "ft_specest_hilbert",
    "ft_specest_irasa",
    "ft_specest_mtmconvol",
    "ft_specest_mtmfft",
    "ft_specest_neuvar",
    "ft_specest_tfr",
    "ft_specest_wavelet",
    "spm2fieldtrip",
    "det2x2",
    "det3x3",
    "getpid",
    "inv2x2",
    "inv3x3",
    "lmoutr",
    "ltrisect",
    "meg_leadfield1",
    "mtimes2x2",
    "mtimes3x3",
    "mxDeserialize",
    "mxSerialize",
    "plgndr",
    "plinproj",
    "ptriproj",
    "read_16bit",
    "read_24bit",
    "read_ctf_shm",
    "rfbevent",
    "routlm",
    "sandwich2x2",
    "sandwich3x3",
    "solid_angle",
    "splint_gh",
    "write_ctf_shm",
    "ft_statfun_actvsblT",
    "ft_statfun_bayesfactor",
    "ft_statfun_cohensd",
    "ft_statfun_correlationT",
    "ft_statfun_depsamplesFmultivariate",
    "ft_statfun_depsamplesFunivariate",
    "ft_statfun_depsamplesT",
    "ft_statfun_depsamplesregrT",
    "ft_statfun_diff",
    "ft_statfun_diff_itc",
    "ft_statfun_gcmi",
    "ft_statfun_indepsamplesF",
    "ft_statfun_indepsamplesT",
    "ft_statfun_indepsamplesZcoh",
    "ft_statfun_indepsamplesregrT",
    "ft_statfun_mean",
    "ft_statfun_pooledT",
    "ft_statfun_roc",
    "ft_trialfun_balert",
    "ft_trialfun_bids",
    "ft_trialfun_brainvision_segmented",
    "ft_trialfun_edf",
    "ft_trialfun_emgdetect",
    "ft_trialfun_example1",
    "ft_trialfun_example2",
    "ft_trialfun_general",
    "ft_trialfun_gui",
    "ft_trialfun_hed",
    "ft_trialfun_imotions",
    "ft_trialfun_neuromagSTI016fix",
    "ft_trialfun_realtime",
    "ft_trialfun_show",
    "ft_trialfun_trial",
    "ft_trialfun_twoclass_classification",
    "appendstruct",
    "copyfields",
    "dccnpath",
    "ft_affinecoordinates",
    "ft_average_sens",
    "ft_cfg2keyval",
    "ft_channelcombination",
    "ft_channelselection",
    "ft_checkconfig",
    "ft_checkdata",
    "ft_checkopt",
    "ft_compile_mex",
    "ft_compile_standalone",
    "ft_convert_coordsys",
    "ft_datatype",
    "ft_datatype_comp",
    "ft_datatype_dip",
    "ft_datatype_freq",
    "ft_datatype_headmodel",
    "ft_datatype_mvar",
    "ft_datatype_parcellation",
    "ft_datatype_raw",
    "ft_datatype_segmentation",
    "ft_datatype_sens",
    "ft_datatype_source",
    "ft_datatype_spike",
    "ft_datatype_timelock",
    "ft_datatype_volume",
    "ft_debug",
    "ft_determine_coordsys",
    "ft_documentationconfiguration",
    "ft_documentationreference",
    "ft_error",
    "ft_fetch_data",
    "ft_fetch_event",
    "ft_fetch_header",
    "ft_findcfg",
    "ft_getopt",
    "ft_hash",
    "ft_hastoolbox",
    "ft_headcoordinates",
    "ft_info",
    "ft_keyval2cfg",
    "ft_notice",
    "ft_platform_supports",
    "ft_postamble",
    "ft_preamble",
    "ft_progress",
    "ft_save_workspace",
    "ft_scalingfactor",
    "ft_selectdata",
    "ft_setopt",
    "ft_source2full",
    "ft_source2grid",
    "ft_source2sparse",
    "ft_standalone",
    "ft_struct2char",
    "ft_struct2double",
    "ft_struct2single",
    "ft_struct2string",
    "ft_test",
    "ft_trackusage",
    "ft_transform_geometry",
    "ft_transform_headmodel",
    "ft_transform_headshape",
    "ft_transform_sens",
    "ft_transform_vol",
    "ft_version",
    "ft_warning",
    "ft_warp_apply",
    "ft_warp_error",
    "ft_warp_optim",
    "getsubfield",
    "hasyokogawa",
    "issubfield",
    "istrue",
    "keepfields",
    "keyval",
    "keyvalcheck",
    "markdown2matlab",
    "match_str",
    "match_val",
    "matlab2markdown",
    "memtic",
    "memtoc",
    "nearest",
    "printstruct",
    "removefields",
    "renamefields",
    "rmsubfield",
    "setsubfield",
    "strel_bol",
    "tokenize",
    "xdf2fieldtrip",
    "fiff_copy_tree",
    "fiff_define_constants",
    "fiff_dir_tree_find",
    "fiff_end_block",
    "fiff_end_file",
    "fiff_find_evoked",
    "fiff_finish_writing_raw",
    "fiff_invert_transform",
    "fiff_list_dir_tree",
    "fiff_make_ch_rename",
    "fiff_make_dir_tree",
    "fiff_open",
    "fiff_pick_channels",
    "fiff_pick_channels_evoked",
    "fiff_pick_info",
    "fiff_pick_types",
    "fiff_pick_types_evoked",
    "fiff_read_bad_channels",
    "fiff_read_coord_trans",
    "fiff_read_ctf_comp",
    "fiff_read_epochs",
    "fiff_read_events",
    "fiff_read_evoked",
    "fiff_read_evoked_all",
    "fiff_read_extended_ch_info",
    "fiff_read_hpi_result",
    "fiff_read_meas_info",
    "fiff_read_mri",
    "fiff_read_named_matrix",
    "fiff_read_proj",
    "fiff_read_raw_segment",
    "fiff_read_raw_segment_times",
    "fiff_read_tag",
    "fiff_read_tag_info",
    "fiff_rename_comp",
    "fiff_rename_list",
    "fiff_reset_ch_pos",
    "fiff_setup_read_raw",
    "fiff_split_name_list",
    "fiff_start_block",
    "fiff_start_file",
    "fiff_start_writing_raw",
    "fiff_transform_eeg_chs",
    "fiff_transform_meg_chs",
    "fiff_write_ch_info",
    "fiff_write_ch_infos",
    "fiff_write_complex",
    "fiff_write_complex_matrix",
    "fiff_write_coord_trans",
    "fiff_write_ctf_comp",
    "fiff_write_dau16",
    "fiff_write_dig_file",
    "fiff_write_dig_point",
    "fiff_write_double",
    "fiff_write_double_complex",
    "fiff_write_double_complex_matrix",
    "fiff_write_double_matrix",
    "fiff_write_epochs",
    "fiff_write_events",
    "fiff_write_evoked",
    "fiff_write_float",
    "fiff_write_float_matrix",
    "fiff_write_float_sparse_ccs",
    "fiff_write_float_sparse_rcs",
    "fiff_write_id",
    "fiff_write_int",
    "fiff_write_int_matrix",
    "fiff_write_name_list",
    "fiff_write_named_matrix",
    "fiff_write_proj",
    "fiff_write_raw_buffer",
    "fiff_write_raw_segment",
    "fiff_write_raw_segment_times",
    "fiff_write_short",
    "fiff_write_string",
    "mne_add_coil_defs",
    "mne_babyMEG_dig_trig",
    "mne_block_diag",
    "mne_combine_xyz",
    "mne_compensate_to",
    "mne_ex_average_epochs",
    "mne_ex_cancel_noise",
    "mne_ex_compute_inverse",
    "mne_ex_data_sets",
    "mne_ex_evoked_grad_amp",
    "mne_ex_read_epochs",
    "mne_ex_read_evoked",
    "mne_ex_read_raw",
    "mne_ex_read_write_raw",
    "mne_ex_rt",
    "mne_file_name",
    "mne_find_channel",
    "mne_find_events",
    "mne_find_source_space_hemi",
    "mne_fread3",
    "mne_fwrite3",
    "mne_get_current_comp",
    "mne_label_time_courses",
    "mne_license",
    "mne_load_coil_def",
    "mne_make_combined_event_file",
    "mne_make_compensator",
    "mne_make_projector",
    "mne_make_projector_info",
    "mne_mesh_edges",
    "mne_morph_data",
    "mne_omit_first_line",
    "mne_patch_info",
    "mne_pick_channels_cov",
    "mne_pick_channels_forward",
    "mne_prepare_inverse_operator",
    "mne_read_bem_surfaces",
    "mne_read_cov",
    "mne_read_curvature",
    "mne_read_epoch",
    "mne_read_events",
    "mne_read_forward_solution",
    "mne_read_inverse_operator",
    "mne_read_label_file",
    "mne_read_morph_map",
    "mne_read_noise_cov",
    "mne_read_source_spaces",
    "mne_read_stc_file",
    "mne_read_stc_file1",
    "mne_read_surface",
    "mne_read_surfaces",
    "mne_read_w_file",
    "mne_read_w_file1",
    "mne_reduce_surface",
    "mne_rt_define_commands",
    "mne_set_current_comp",
    "mne_source_spectral_analysis",
    "mne_transform_coordinates",
    "mne_transform_source_space_to",
    "mne_transpose_named_matrix",
    "mne_write_cov",
    "mne_write_cov_file",
    "mne_write_events",
    "mne_write_inverse_sol_stc",
    "mne_write_inverse_sol_w",
    "mne_write_label_file",
    "mne_write_stc_file",
    "mne_write_stc_file1",
    "mne_write_surface",
    "mne_write_w_file",
    "mne_write_w_file1",
    "dcm_fit_finger",
    "gen_finger",
    "glm_phi",
    "cfg_branch",
    "cfg_choice",
    "cfg_const",
    "cfg_dep",
    "cfg_entry",
    "cfg_exbranch",
    "cfg_files",
    "cfg_intree",
    "cfg_inv_out",
    "cfg_item",
    "cfg_leaf",
    "cfg_mchoice",
    "cfg_menu",
    "cfg_repeat",
    "cfg_basicio_rewrite",
    "cfg_cfg_basicio",
    "cfg_cfg_basicio_def",
    "cfg_check_assignin",
    "cfg_load_vars",
    "cfg_run_assignin",
    "cfg_run_call_matlab",
    "cfg_run_cd",
    "cfg_run_dir_move",
    "cfg_run_file_filter",
    "cfg_run_file_fplist",
    "cfg_run_file_move",
    "cfg_run_file_split",
    "cfg_run_fileparts",
    "cfg_run_gunzip_files",
    "cfg_run_gzip_files",
    "cfg_run_mkdir",
    "cfg_run_named_dir",
    "cfg_run_named_file",
    "cfg_run_named_input",
    "cfg_run_runjobs",
    "cfg_run_save_vars",
    "cfg_run_subsrefvar",
    "cfg_vout_dir_move",
    "cfg_vout_file_filter",
    "cfg_vout_file_fplist",
    "cfg_vout_file_move",
    "cfg_vout_file_split",
    "cfg_vout_fileparts",
    "cfg_vout_gunzip_files",
    "cfg_vout_gzip_files",
    "cfg_vout_mkdir",
    "cfg_vout_named_dir",
    "cfg_vout_named_file",
    "cfg_vout_named_input",
    "cfg_vout_runjobs",
    "cfg_vout_save_vars",
    "create_cfg_cfg_basicio",
    "cfg_callbuiltin",
    "cfg_confgui",
    "cfg_run_template",
    "cfg_dbstop",
    "cfg_findspec",
    "cfg_get_defaults",
    "cfg_getfile",
    "cfg_load_jobs",
    "cfg_message",
    "cfg_mlbatch_appcfg",
    "cfg_serial",
    "cfg_struct2cfg",
    "cfg_tropts",
    "cfg_txtdesc2cfg",
    "cfg_ui",
    "cfg_ui_multibatch",
    "cfg_ui_util",
    "cfg_util",
    "cfg_example_add1",
    "cfg_example_add2",
    "cfg_example_cumsum1",
    "cfg_example_cumsum2",
    "cfg_example_div",
    "cfg_example_master",
    "cfg_example_run_add1",
    "cfg_example_run_add2",
    "cfg_example_run_cumsum1",
    "cfg_example_run_cumsum2",
    "cfg_example_run_div",
    "cfg_example_run_sum",
    "cfg_example_sum",
    "toy_example",
    "gencode",
    "gencode_rvalue",
    "gencode_substruct",
    "gencode_substructcode",
    "help2cell",
    "hgsave_pre2008a",
    "subsasgn_check_funhandle",
    "subsasgn_check_num",
    "subsasgn_check_valcfg",
    "spm",
    "spm_ADEM",
    "spm_ADEM_M_set",
    "spm_ADEM_diff",
    "spm_ADEM_set",
    "spm_ADEM_update",
    "spm_ALAP",
    "spm_A_reduce",
    "spm_BIDS",
    "spm_BIDS_file",
    "spm_BMS",
    "spm_BMS_F",
    "spm_BMS_F_smpl",
    "spm_BMS_bor",
    "spm_BMS_gibbs",
    "spm_Bcdf",
    "spm_Bpdf",
    "spm_Ce",
    "spm_DEM",
    "spm_DEM_F",
    "spm_DEM_M_set",
    "spm_DEM_R",
    "spm_DEM_diff",
    "spm_DEM_embed",
    "spm_DEM_eval",
    "spm_DEM_eval_diff",
    "spm_DEM_generate",
    "spm_DEM_int",
    "spm_DEM_qH",
    "spm_DEM_qP",
    "spm_DEM_qU",
    "spm_DEM_set",
    "spm_DEM_z",
    "spm_DFP",
    "spm_DFP_plot",
    "spm_DesMtx",
    "spm_DesRep",
    "spm_DisplayTimeSeries",
    "spm_Dpdf",
    "spm_ECdensity",
    "spm_FcUtil",
    "spm_Fcdf",
    "spm_Fpdf",
    "spm_GDEM",
    "spm_Gcdf",
    "spm_Gpdf",
    "spm_Icdf",
    "spm_Ipdf",
    "spm_KL_cat",
    "spm_KL_dir",
    "spm_LAP",
    "spm_LAPF",
    "spm_LAPS",
    "spm_LAP_F",
    "spm_LAP_eval",
    "spm_LAP_iS",
    "spm_LAP_pg",
    "spm_LAP_ph",
    "spm_Laplace",
    "spm_MB_col",
    "spm_MDP_MI",
    "spm_MDP_da",
    "spm_MH",
    "spm_MH_reml",
    "spm_MH_reml_likelihood",
    "spm_Markov_blanket",
    "spm_Menu",
    "spm_NESS_F",
    "spm_NESS_ds",
    "spm_NESS_gen",
    "spm_NESS_gen_lap",
    "spm_Ncdf",
    "spm_Ncdf_jdw",
    "spm_Npdf",
    "spm_P",
    "spm_PEB",
    "spm_P_Bonf",
    "spm_P_FDR",
    "spm_P_RF",
    "spm_P_clusterFDR",
    "spm_P_peakFDR",
    "spm_Pcdf",
    "spm_Pec_resels",
    "spm_Ppdf",
    "spm_Q",
    "spm_Q_perm",
    "spm_ROI",
    "spm_SpUtil",
    "spm_Tcdf",
    "spm_Tpdf",
    "spm_VBX",
    "spm_VOI",
    "spm_Volt_W",
    "spm_Volterra",
    "spm_Welcome",
    "spm_XYZreg",
    "spm_XYZreg_Ex2",
    "spm_Xcdf",
    "spm_Xpdf",
    "spm_affine_priors",
    "spm_ancova",
    "spm_api_bmc",
    "spm_ar_reml",
    "spm_argmax",
    "spm_atlas",
    "spm_authors",
    "spm_axis",
    "spm_barh",
    "spm_bayes2_logbf",
    "spm_beta_compare",
    "spm_betaln",
    "spm_bilinear",
    "spm_bilinear_condition",
    "spm_bireduce",
    "spm_bms_against_null",
    "spm_bms_anova",
    "spm_bms_anova_img",
    "spm_bms_compare_groups",
    "spm_bms_display",
    "spm_bms_display_ROI",
    "spm_bms_display_vox",
    "spm_bms_partition",
    "spm_bms_test_null",
    "spm_bms_ttest",
    "spm_browser",
    "spm_bsplinc",
    "spm_bsplins",
    "spm_bwlabel",
    "spm_cat",
    "spm_cat_struct",
    "spm_cell_swap",
    "spm_changepath",
    "spm_check_filename",
    "spm_check_installation",
    "spm_check_orientations",
    "spm_check_registration",
    "spm_check_results",
    "spm_check_version",
    "spm_circularGraph",
    "spm_clf",
    "spm_cli",
    "spm_clusters",
    "spm_colourmap",
    "spm_combinations",
    "spm_compact_svd",
    "spm_compare_families",
    "spm_cond_units",
    "spm_conman",
    "spm_contrasts",
    "spm_conv",
    "spm_conv_full",
    "spm_conv_vol",
    "spm_convmtx",
    "spm_copy",
    "spm_coreg",
    "spm_cov2corr",
    "spm_create_vol",
    "spm_cross",
    "spm_csd_fmri_gu",
    "spm_csd_fmri_mar",
    "spm_csd_fmri_mtf",
    "spm_cva",
    "spm_cva_ui",
    "spm_dartel_integrate",
    "spm_data_hdr_read",
    "spm_data_hdr_write",
    "spm_data_id",
    "spm_data_read",
    "spm_data_write",
    "spm_dcm_HMM",
    "spm_dcm_HMM_plot",
    "spm_dcm_J",
    "spm_dcm_KL",
    "spm_dcm_U",
    "spm_dcm_average",
    "spm_dcm_bdc",
    "spm_dcm_bma",
    "spm_dcm_bma_results",
    "spm_dcm_bmc",
    "spm_dcm_bmc_peb",
    "spm_dcm_bmr",
    "spm_dcm_bmr_all",
    "spm_dcm_bpa",
    "spm_dcm_check_stability",
    "spm_dcm_compare",
    "spm_dcm_connectivity_ui",
    "spm_dcm_contrasts",
    "spm_dcm_create",
    "spm_dcm_csd_Q",
    "spm_dcm_delay",
    "spm_dcm_diagnose",
    "spm_dcm_display",
    "spm_dcm_estimate",
    "spm_dcm_evidence",
    "spm_dcm_fit",
    "spm_dcm_fmri_check",
    "spm_dcm_fmri_csd",
    "spm_dcm_fmri_csd_DEM",
    "spm_dcm_fmri_csd_data",
    "spm_dcm_fmri_csd_gen",
    "spm_dcm_fmri_csd_results",
    "spm_dcm_fmri_graph_gen",
    "spm_dcm_fmri_image",
    "spm_dcm_fmri_mar",
    "spm_dcm_fmri_mode",
    "spm_dcm_fmri_mode_gen",
    "spm_dcm_fmri_nmm",
    "spm_dcm_fmri_priors",
    "spm_dcm_generate",
    "spm_dcm_graph",
    "spm_dcm_graph_functional",
    "spm_dcm_identify",
    "spm_dcm_load",
    "spm_dcm_loo",
    "spm_dcm_mdp",
    "spm_dcm_mtf",
    "spm_dcm_optimise",
    "spm_dcm_peb",
    "spm_dcm_peb_bmc",
    "spm_dcm_peb_bmc_fam",
    "spm_dcm_peb_con",
    "spm_dcm_peb_fit",
    "spm_dcm_peb_full",
    "spm_dcm_peb_review",
    "spm_dcm_peb_rnd",
    "spm_dcm_peb_rnd_search",
    "spm_dcm_peb_test",
    "spm_dcm_peb_to_gcm",
    "spm_dcm_post_hoc",
    "spm_dcm_post_hoc_old",
    "spm_dcm_ppd",
    "spm_dcm_reduce",
    "spm_dcm_review",
    "spm_dcm_search",
    "spm_dcm_sessions",
    "spm_dcm_simulate",
    "spm_dcm_sparse",
    "spm_dcm_sparse_priors",
    "spm_dcm_specify",
    "spm_dcm_specify_ui",
    "spm_dcm_ui",
    "spm_dcm_voi",
    "spm_dctmtx",
    "spm_ddiff",
    "spm_deface",
    "spm_defaults",
    "spm_deformations",
    "spm_dem2dcm",
    "spm_design_contrasts",
    "spm_design_factorial",
    "spm_design_flexible",
    "spm_design_within_subject",
    "spm_detrend",
    "spm_dftmtx",
    "spm_diag",
    "spm_diag_array",
    "spm_dicom_convert",
    "spm_dicom_essentials",
    "spm_dicom_header",
    "spm_dicom_headers",
    "spm_dicom_metadata",
    "spm_dicom_text_to_dict",
    "spm_diff",
    "spm_diff_dx",
    "spm_diffeo",
    "spm_dilate",
    "spm_dir_MI",
    "spm_dir_norm",
    "spm_dir_sort",
    "spm_dirichlet_exceedance",
    "spm_dot",
    "spm_dwtmtx",
    "spm_dx",
    "spm_dx_eig",
    "spm_ecat2nifti",
    "spm_eeg_artefact",
    "spm_eeg_artefact_events",
    "spm_eeg_artefact_eyeblink",
    "spm_eeg_artefact_flat",
    "spm_eeg_artefact_heartbeat",
    "spm_eeg_artefact_jump",
    "spm_eeg_artefact_nans",
    "spm_eeg_artefact_peak2peak",
    "spm_eeg_artefact_saccade",
    "spm_eeg_artefact_threshchan",
    "spm_eeg_artefact_zscore",
    "spm_eeg_artefact_zscorediff",
    "spm_eeg_assemble_priors",
    "spm_eeg_average",
    "spm_eeg_average_TF",
    "spm_eeg_avgfreq",
    "spm_eeg_avgtime",
    "spm_eeg_bc",
    "spm_eeg_cfc",
    "spm_eeg_collapse_timefreq",
    "spm_eeg_combineplanar",
    "spm_eeg_contrast",
    "spm_eeg_convert",
    "spm_eeg_convert2images",
    "spm_eeg_convert_ui",
    "spm_eeg_copy",
    "spm_eeg_correct_sensor_data",
    "spm_eeg_crop",
    "spm_eeg_definetrial",
    "spm_eeg_dipoles_ui",
    "spm_eeg_displayECD",
    "spm_eeg_display_tf",
    "spm_eeg_downsample",
    "spm_eeg_epochs",
    "spm_eeg_filter",
    "spm_eeg_firstlevel",
    "spm_eeg_fixpnt",
    "spm_eeg_ft2spm",
    "spm_eeg_fuse",
    "spm_eeg_grandmean",
    "spm_eeg_history",
    "spm_eeg_inv_Mesh2Voxels",
    "spm_eeg_inv_check",
    "spm_eeg_inv_checkdatareg",
    "spm_eeg_inv_checkforward",
    "spm_eeg_inv_checkmeshes",
    "spm_eeg_inv_custom_ui",
    "spm_eeg_inv_datareg",
    "spm_eeg_inv_datareg_ui",
    "spm_eeg_inv_extract",
    "spm_eeg_inv_extract_ui",
    "spm_eeg_inv_fmripriors",
    "spm_eeg_inv_forward",
    "spm_eeg_inv_forward_ui",
    "spm_eeg_inv_get_vol_sens",
    "spm_eeg_inv_group",
    "spm_eeg_inv_headcoordinates",
    "spm_eeg_inv_icp",
    "spm_eeg_inv_imag_api",
    "spm_eeg_inv_image_display",
    "spm_eeg_inv_mesh",
    "spm_eeg_inv_mesh_spherify",
    "spm_eeg_inv_mesh_ui",
    "spm_eeg_inv_prep_modes_xval",
    "spm_eeg_inv_results",
    "spm_eeg_inv_results_display",
    "spm_eeg_inv_results_ui",
    "spm_eeg_inv_rigidreg",
    "spm_eeg_inv_spatnorm",
    "spm_eeg_inv_transform_mesh",
    "spm_eeg_inv_transform_points",
    "spm_eeg_inv_vb_ecd_gui",
    "spm_eeg_inv_vbecd",
    "spm_eeg_inv_vbecd_disp",
    "spm_eeg_inv_vbecd_getLF",
    "spm_eeg_inv_vbecd_gui",
    "spm_eeg_inv_vbecd_mom",
    "spm_eeg_inv_visu3D_api",
    "spm_eeg_invert",
    "spm_eeg_invert_EBoptimise",
    "spm_eeg_invert_bma",
    "spm_eeg_invert_classic",
    "spm_eeg_invert_classic_mix",
    "spm_eeg_invert_classic_volumetric",
    "spm_eeg_invert_display",
    "spm_eeg_invert_prepro",
    "spm_eeg_invert_setuppatches",
    "spm_eeg_invert_ui",
    "spm_eeg_invertiter",
    "spm_eeg_lapmtx",
    "spm_eeg_layout3D",
    "spm_eeg_lgainmat",
    "spm_eeg_load",
    "spm_eeg_locate_channels",
    "spm_eeg_mask",
    "spm_eeg_mask2channels",
    "spm_eeg_merge",
    "spm_eeg_meshnative2mni",
    "spm_eeg_modality_ui",
    "spm_eeg_montage",
    "spm_eeg_montage_ui",
    "spm_eeg_morlet",
    "spm_eeg_planarchannelset",
    "spm_eeg_plotScalpData",
    "spm_eeg_prep",
    "spm_eeg_prep_ui",
    "spm_eeg_project3D",
    "spm_eeg_read_bsa",
    "spm_eeg_reduce",
    "spm_eeg_reduce_cva",
    "spm_eeg_reduce_imagcsd",
    "spm_eeg_reduce_pca",
    "spm_eeg_reduce_pca_adapt",
    "spm_eeg_reduce_whiten",
    "spm_eeg_regressors",
    "spm_eeg_regressors_chandata",
    "spm_eeg_regressors_movement_ctf",
    "spm_eeg_regressors_tfphase",
    "spm_eeg_regressors_tfpower",
    "spm_eeg_remove_bad_trials",
    "spm_eeg_render",
    "spm_eeg_review",
    "spm_eeg_review_callbacks",
    "spm_eeg_review_switchDisplay",
    "spm_eeg_review_uis",
    "spm_eeg_robust_averaget",
    "spm_eeg_select_event_ui",
    "spm_eeg_simulate",
    "spm_eeg_simulate_frominv",
    "spm_eeg_smoothmesh_mm",
    "spm_eeg_spatial_confounds",
    "spm_eeg_specest_hilbert",
    "spm_eeg_specest_morlet",
    "spm_eeg_specest_mtmconvol",
    "spm_eeg_specest_mtmfft",
    "spm_eeg_spmft_chan_dictionary",
    "spm_eeg_tf",
    "spm_eeg_tf_rescale",
    "spm_eeg_wrap_dipfit_vbecd",
    "spm_eeg_wrap_momfit_vbecd",
    "spm_ekf",
    "spm_en",
    "spm_epharm",
    "spm_erode",
    "spm_est_V",
    "spm_est_non_sphericity",
    "spm_est_smoothness",
    "spm_existfile",
    "spm_expm",
    "spm_extract_files",
    "spm_extrapolate_def",
    "spm_fMRI_design",
    "spm_field",
    "spm_fieldindices",
    "spm_figure",
    "spm_file",
    "spm_file_ext",
    "spm_file_merge",
    "spm_file_split",
    "spm_fileparts",
    "spm_filter",
    "spm_find_pC",
    "spm_flip_analyze_images",
    "spm_fmin",
    "spm_fmri_concatenate",
    "spm_fmri_spm_ui",
    "spm_fn_reml",
    "spm_fp",
    "spm_fp_display_density",
    "spm_fp_display_nullclines",
    "spm_fp_fmin",
    "spm_fp_fun",
    "spm_fs_fmri_csd",
    "spm_funcheck",
    "spm_funfun",
    "spm_fx_fmri",
    "spm_fx_fmri_linear",
    "spm_fx_hdm",
    "spm_fx_lz",
    "spm_fx_poly",
    "spm_gamrnd",
    "spm_gen_fmri",
    "spm_getSPM",
    "spm_get_anatomical_layout",
    "spm_get_bbox",
    "spm_get_bf",
    "spm_get_closest_affine",
    "spm_get_data",
    "spm_get_dataset",
    "spm_get_defaults",
    "spm_get_lm",
    "spm_get_matdim",
    "spm_get_ons",
    "spm_get_space",
    "spm_get_vc",
    "spm_get_volumes",
    "spm_glass",
    "spm_global",
    "spm_gn_fmin",
    "spm_graph",
    "spm_graph_ui",
    "spm_grid",
    "spm_gx_fmri",
    "spm_gx_fmri_linear",
    "spm_gx_hdm",
    "spm_gx_state_fmri",
    "spm_hanning",
    "spm_hdm_priors",
    "spm_hdm_ui",
    "spm_help",
    "spm_hilbert",
    "spm_hist",
    "spm_hist2",
    "spm_hist_smooth",
    "spm_hrf",
    "spm_image",
    "spm_imatrix",
    "spm_imcalc",
    "spm_ind2sub",
    "spm_inline2func",
    "spm_input",
    "spm_int",
    "spm_int_B",
    "spm_int_D",
    "spm_int_E",
    "spm_int_J",
    "spm_int_L",
    "spm_int_ode",
    "spm_int_sde",
    "spm_interp",
    "spm_inv",
    "spm_invBcdf",
    "spm_invFcdf",
    "spm_invGcdf",
    "spm_invIcdf",
    "spm_invNcdf",
    "spm_invPcdf",
    "spm_invTcdf",
    "spm_invXcdf",
    "spm_inv_phi",
    "spm_inv_spd",
    "spm_ipharm",
    "spm_iwft",
    "spm_jobman",
    "spm_jsonread",
    "spm_jsonwrite",
    "spm_kernels",
    "spm_kl_dirichlet",
    "spm_kl_gamma",
    "spm_kl_normal",
    "spm_kl_normald",
    "spm_kl_wishart",
    "spm_kron",
    "spm_krutil",
    "spm_large_dcm_reduce",
    "spm_length",
    "spm_lg_gamma",
    "spm_list",
    "spm_load",
    "spm_load_priors8",
    "spm_log",
    "spm_log_evidence",
    "spm_log_evidence_reduce",
    "spm_logdet",
    "spm_lorenz_k",
    "spm_lotka_volterra",
    "spm_maff8",
    "spm_make_contrasts",
    "spm_marginal",
    "spm_mask",
    "spm_match_str",
    "spm_matrix",
    "spm_max",
    "spm_mb_ui",
    "spm_meanby",
    "spm_mesh",
    "spm_mesh_adjacency",
    "spm_mesh_area",
    "spm_mesh_borders",
    "spm_mesh_bounding_volume",
    "spm_mesh_calc",
    "spm_mesh_clusters",
    "spm_mesh_contour",
    "spm_mesh_cube",
    "spm_mesh_curvature",
    "spm_mesh_detect",
    "spm_mesh_dist",
    "spm_mesh_distmtx",
    "spm_mesh_edges",
    "spm_mesh_euler",
    "spm_mesh_geodesic",
    "spm_mesh_get_lm",
    "spm_mesh_inflate",
    "spm_mesh_inside",
    "spm_mesh_isoline",
    "spm_mesh_isosurface",
    "spm_mesh_join",
    "spm_mesh_label",
    "spm_mesh_laplacian",
    "spm_mesh_mass_matrix",
    "spm_mesh_max",
    "spm_mesh_neighbours",
    "spm_mesh_normals",
    "spm_mesh_polyhedron",
    "spm_mesh_project",
    "spm_mesh_ray_intersect",
    "spm_mesh_ray_triangle",
    "spm_mesh_reduce",
    "spm_mesh_refine",
    "spm_mesh_render",
    "spm_mesh_resels",
    "spm_mesh_sdf",
    "spm_mesh_select",
    "spm_mesh_smooth",
    "spm_mesh_sphere",
    "spm_mesh_split",
    "spm_mesh_to_grid",
    "spm_mesh_transform",
    "spm_mesh_utils",
    "spm_mesh_volume",
    "spm_mesh_voxelise",
    "spm_mfx",
    "spm_minmax",
    "spm_mip",
    "spm_mip_ui",
    "spm_mkdir",
    "spm_mldivide",
    "spm_mnc2nifti",
    "spm_morlet",
    "spm_morlet_conv",
    "spm_mrdivide",
    "spm_mrf",
    "spm_mtx_cos",
    "spm_multrnd",
    "spm_mvNpdf",
    "spm_mvb",
    "spm_mvb_G",
    "spm_mvb_R2",
    "spm_mvb_U",
    "spm_mvb_bmc",
    "spm_mvb_cvk",
    "spm_mvb_cvk2",
    "spm_mvb_cvk_display",
    "spm_mvb_display",
    "spm_mvb_estimate",
    "spm_mvb_p",
    "spm_mvb_ui",
    "spm_nCr",
    "spm_ncFcdf",
    "spm_ncFpdf",
    "spm_ncTcdf",
    "spm_ncTpdf",
    "spm_ndgrid",
    "spm_ness",
    "spm_ness_GN",
    "spm_ness_J",
    "spm_ness_Lap",
    "spm_ness_N2Sp",
    "spm_ness_Sp2N",
    "spm_ness_Sp2p",
    "spm_ness_U",
    "spm_ness_cond",
    "spm_ness_flows",
    "spm_ness_hd",
    "spm_ness_m2S",
    "spm_ness_p2Sp",
    "spm_nlsi",
    "spm_nlsi_AI",
    "spm_nlsi_GN",
    "spm_nlsi_GN_H",
    "spm_nlsi_LS",
    "spm_nlsi_N",
    "spm_nlsi_Newton",
    "spm_non_sphericity",
    "spm_normrnd",
    "spm_opm_amm",
    "spm_orientations",
    "spm_orth",
    "spm_orthpoly",
    "spm_ov_browser",
    "spm_ov_contour",
    "spm_ov_display",
    "spm_ov_goto_max",
    "spm_ov_mesh",
    "spm_ov_movie",
    "spm_ov_reorient",
    "spm_ov_rgb",
    "spm_ov_roi",
    "spm_ov_save",
    "spm_ovhelper_3Dreg",
    "spm_orthviews",
    "spm_padarray",
    "spm_parrec2nifti",
    "spm_peb_ppi",
    "spm_percentile",
    "spm_perm_mtx",
    "spm_permute_kron",
    "spm_pf",
    "spm_phase_shuffle",
    "spm_phi",
    "spm_phi_dot",
    "spm_pinv",
    "spm_platform",
    "spm_plot_ci",
    "spm_plot_convergence",
    "spm_polymtx",
    "spm_powell",
    "spm_preproc",
    "spm_preproc8",
    "spm_preproc_run",
    "spm_preproc_write8",
    "spm_print",
    "spm_progress_bar",
    "spm_project",
    "spm_psi",
    "spm_rand_mar",
    "spm_rand_power_law",
    "spm_read_netcdf",
    "spm_read_vols",
    "spm_realign",
    "spm_regions",
    "spm_reml",
    "spm_reml_A",
    "spm_reml_ancova",
    "spm_reml_sc",
    "spm_render",
    "spm_render_vol",
    "spm_reorder_contrasts",
    "spm_resels",
    "spm_resels_vol",
    "spm_reslice",
    "spm_results_nidm",
    "spm_results_ui",
    "spm_rmpath",
    "spm_robust_average",
    "spm_robust_glm",
    "spm_s2csd",
    "spm_sample_priors8",
    "spm_sample_vol",
    "spm_save",
    "spm_sde_dx",
    "spm_sdot",
    "spm_searchlight",
    "spm_sections",
    "spm_select",
    "spm_sepmul3d",
    "spm_shp_get_model",
    "spm_shp_get_transforms",
    "spm_shp_install",
    "spm_shp_project_velocity",
    "spm_shp_sample_brains",
    "spm_shp_sample_deformation",
    "spm_shp_transform_mesh",
    "spm_shp_transform_volume",
    "spm_shp_warps",
    "spm_sixel",
    "spm_slice_timing",
    "spm_slice_vol",
    "spm_slm",
    "spm_smohist",
    "spm_smooth",
    "spm_smoothkern",
    "spm_smoothto8bit",
    "spm_softmax",
    "spm_soreduce",
    "spm_sp",
    "spm_sp_reml",
    "spm_sparse_regression",
    "spm_speye",
    "spm_spm",
    "spm_spm_Bayes",
    "spm_spm_Bayes_CY",
    "spm_spm_Bayes_specify",
    "spm_sptop",
    "spm_spy",
    "spm_sqrtm",
    "spm_squeeze",
    "spm_ssm2s",
    "spm_standalone",
    "spm_str_manip",
    "spm_subfun",
    "spm_sum",
    "spm_summarise",
    "spm_surf",
    "spm_svd",
    "spm_swarp",
    "spm_t2z",
    "spm_tests",
    "spm_timeseries_resample",
    "spm_trace",
    "spm_transverse",
    "spm_type",
    "spm_u",
    "spm_uc",
    "spm_uc_Bonf",
    "spm_uc_FDR",
    "spm_uc_RF",
    "spm_uc_clusterFDR",
    "spm_uc_peakFDR",
    "spm_uitab",
    "spm_uncat",
    "spm_unlink",
    "spm_unvec",
    "spm_update",
    "spm_uw_apply",
    "spm_uw_estimate",
    "spm_uw_get_image_def",
    "spm_uw_show",
    "spm_vb_F",
    "spm_vb_Fn",
    "spm_vb_a",
    "spm_vb_adjacency",
    "spm_vb_alpha",
    "spm_vb_beta",
    "spm_vb_contrasts",
    "spm_vb_edgeweights",
    "spm_vb_gamma",
    "spm_vb_get_Ab",
    "spm_vb_get_Gn",
    "spm_vb_get_R",
    "spm_vb_glmar",
    "spm_vb_graphcut",
    "spm_vb_incidence",
    "spm_vb_init_block",
    "spm_vb_lambda",
    "spm_vb_logbf",
    "spm_vb_models",
    "spm_vb_neighbors",
    "spm_vb_ppm_anova",
    "spm_vb_regionF",
    "spm_vb_robust",
    "spm_vb_roi_anova",
    "spm_vb_roi_basis",
    "spm_vb_set_priors",
    "spm_vb_spatial_precision",
    "spm_vb_taylor_R",
    "spm_vb_w",
    "spm_vec",
    "spm_vecfun",
    "spm_vol",
    "spm_vol_nifti",
    "spm_voronoi",
    "spm_wft",
    "spm_write_filtered",
    "spm_write_plane",
    "spm_write_residuals",
    "spm_write_vol",
    "spm_z2p",
    "spm_zeros",
    "ROBOT_DCM_EEG",
    "ROBOT_DCM_fMRI",
    "ROBOT_DEM",
    "end2end_attention",
    "end2end_restingfMRI",
    "spm_eeg_test_coverage",
    "test_checkcode",
    "test_gifti",
    "test_regress_fmri_glm_dcm",
    "test_regress_fmri_group",
    "test_regress_spm_dcm_fmri",
    "test_regress_spm_distort_mesh",
    "test_regress_spm_opm",
    "test_spm",
    "test_spm_BMS_gibbs",
    "test_spm_Ce",
    "test_spm_Ncdf",
    "test_spm_bireduce",
    "test_spm_cat_struct",
    "test_spm_cfg_dcm_est",
    "test_spm_cfg_dcm_fmri",
    "test_spm_cfg_dcm_peb",
    "test_spm_create_vol",
    "test_spm_dcm_bma",
    "test_spm_dcm_bmr",
    "test_spm_dcm_bmr_all",
    "test_spm_dcm_bpa",
    "test_spm_dcm_fit",
    "test_spm_dcm_fmri_check",
    "test_spm_dcm_fmri_csd",
    "test_spm_dcm_identify",
    "test_spm_dcm_loo",
    "test_spm_dcm_peb",
    "test_spm_dcm_peb_bmc",
    "test_spm_dcm_peb_bmc_fam",
    "test_spm_dcm_peb_review",
    "test_spm_dcm_peb_to_gcm",
    "test_spm_dcm_post_hoc",
    "test_spm_dcm_simulate",
    "test_spm_dcm_specify",
    "test_spm_dctmtx",
    "test_spm_eeg_average",
    "test_spm_eeg_bc",
    "test_spm_eeg_crop",
    "test_spm_eeg_ffilter",
    "test_spm_eeg_filter",
    "test_spm_eeg_grandmean",
    "test_spm_eeg_load",
    "test_spm_eeg_merge",
    "test_spm_fileparts",
    "test_spm_filter",
    "test_spm_gamrnd",
    "test_spm_get_data",
    "test_spm_get_lm",
    "test_spm_invNcdf",
    "test_spm_jsonread",
    "test_spm_jsonwrite",
    "test_spm_mar",
    "test_spm_mesh_adjacency",
    "test_spm_mesh_area",
    "test_spm_mesh_borders",
    "test_spm_mesh_contour",
    "test_spm_mesh_dist",
    "test_spm_mesh_edges",
    "test_spm_mesh_euler",
    "test_spm_mesh_geodesic",
    "test_spm_mesh_get_lm",
    "test_spm_mesh_label",
    "test_spm_mesh_laplacian",
    "test_spm_mesh_neighbours",
    "test_spm_mesh_normals",
    "test_spm_mesh_ray_intersect",
    "test_spm_mesh_reduce",
    "test_spm_mesh_refine",
    "test_spm_mesh_sdf",
    "test_spm_mesh_smooth",
    "test_spm_mesh_sphere",
    "test_spm_mesh_volume",
    "test_spm_ncFcdf",
    "test_spm_ncFpdf",
    "test_spm_ncTcdf",
    "test_spm_ncTpdf",
    "test_spm_openmp",
    "test_spm_opm_create",
    "test_spm_opm_epoch_trigger",
    "test_spm_opm_headmodel",
    "test_spm_opm_hfc",
    "test_spm_opm_psd",
    "test_spm_opm_rpsd",
    "test_spm_opm_sim",
    "test_spm_opm_vslm",
    "test_spm_platform",
    "test_spm_plot_ci",
    "test_spm_run_dcm_bms",
    "test_spm_sum",
    "test_spm_trace",
    "test_spm_update",
    "test_spm_z2p",
    "dartel3",
    "optimN",
    "optimNn",
    "optim_compat",
    "spm_dartel_dotprods",
    "spm_dartel_import",
    "spm_dartel_invnorm",
    "spm_dartel_jacobian",
    "spm_dartel_kernel",
    "spm_dartel_norm",
    "spm_dartel_norm_fun",
    "spm_dartel_resids",
    "spm_dartel_smooth",
    "spm_dartel_template",
    "spm_dartel_warp",
    "spm_klaff",
    "spm_norm_population",
    "tbx_cfg_dartel",
    "bf_copy",
    "bf_data",
    "bf_features",
    "bf_features_contcov",
    "bf_features_cov",
    "bf_features_cov_bysamples",
    "bf_features_csd",
    "bf_features_identity",
    "bf_features_regmulticov",
    "bf_features_tdcov",
    "bf_features_vbfa",
    "bf_group",
    "bf_group_GALA",
    "bf_group_batch",
    "bf_group_functionalROI",
    "bf_inverse",
    "bf_inverse_champagne",
    "bf_inverse_deflect",
    "bf_inverse_dics",
    "bf_inverse_ebb",
    "bf_inverse_eloreta",
    "bf_inverse_lcmv",
    "bf_inverse_lcmv_multicov",
    "bf_inverse_minimumnorm",
    "bf_inverse_nutmeg",
    "bf_isfield",
    "bf_load",
    "bf_output",
    "bf_output_PLI",
    "bf_output_image_cfGLM",
    "bf_output_image_dics",
    "bf_output_image_filtcorr",
    "bf_output_image_gain",
    "bf_output_image_kurtosis",
    "bf_output_image_mv",
    "bf_output_image_pac",
    "bf_output_image_powcorr",
    "bf_output_image_power",
    "bf_output_image_sensitivity",
    "bf_output_montage",
    "bf_output_sourcedata_robust",
    "bf_regularise_clifftrunc",
    "bf_regularise_mantrunc",
    "bf_regularise_manual",
    "bf_regularise_minkatrunc",
    "bf_regularise_roi",
    "bf_regularise_tichonov_rankdef",
    "bf_save",
    "bf_save_path",
    "bf_sources",
    "bf_sources_grid",
    "bf_sources_grid_phantom",
    "bf_sources_mesh",
    "bf_sources_mni_coords",
    "bf_sources_scalp",
    "bf_sources_voi",
    "bf_stat_evoked_t",
    "bf_std_fields",
    "bf_view",
    "bf_view_glass",
    "bf_view_surface",
    "bf_wizard_data",
    "bf_wizard_features",
    "bf_wizard_headmodel",
    "bf_wizard_inverse",
    "bf_wizard_output",
    "bf_wizard_sources",
    "bf_wizard_view",
    "bf_wizard_write",
    "bf_write",
    "bf_write_gifti",
    "bf_write_nifti",
    "bf_write_spmeeg",
    "spm_DAiSS",
    "spm_beamforming",
    "tbx_cfg_bf",
    "ADEM_SHC_demo",
    "ADEM_cost_SHC",
    "ADEM_cued_response",
    "ADEM_eyeblink",
    "ADEM_learning",
    "ADEM_lorenz",
    "ADEM_lorenz_entropy",
    "ADEM_lorenz_surprise",
    "ADEM_motor",
    "ADEM_mountaincar_loss",
    "ADEM_observe",
    "ADEM_occlusion",
    "ADEM_occulomotor_delays",
    "ADEM_plaid",
    "ADEM_pursuit",
    "ADEM_reaching",
    "ADEM_salience",
    "ADEM_sample_image",
    "ADEM_visual",
    "ADEM_writing",
    "ALAP_demo_attenuation",
    "DATA_COVID_JHU",
    "DATA_COVID_UK",
    "DATA_COVID_US",
    "DATA_WID_data",
    "DEMO_AI_NLSI",
    "DEMO_BAYES_FACTORS",
    "DEMO_BMR_PEB",
    "DEMO_CVA_RSA",
    "DEMO_DCM_MB",
    "DEMO_DCM_PEB",
    "DEMO_DCM_PEB_FIT",
    "DEMO_GROUP_PEB",
    "DEMO_Lindley_paradox",
    "DEMO_MDP_Stroop",
    "DEMO_MDP_Understanding",
    "DEMO_MDP_maze",
    "DEMO_MDP_maze_X",
    "DEMO_MDP_questions",
    "DEMO_MDP_voice",
    "DEMO_SLR",
    "DEMO_niche_construction",
    "DEM_CLIMATE_India",
    "DEM_COVID",
    "DEM_COVID_AGE",
    "DEM_COVID_COUNTRY",
    "DEM_COVID_DASH",
    "DEM_COVID_I",
    "DEM_COVID_LTLA",
    "DEM_COVID_S",
    "DEM_COVID_T",
    "DEM_COVID_UK",
    "DEM_COVID_UK4",
    "DEM_COVID_UTLA",
    "DEM_COVID_WID",
    "DEM_COVID_X",
    "DEM_Dispatches",
    "DEM_FEP_Least_Action",
    "DEM_FEP_Lorenz",
    "DEM_HB_and_LE",
    "DEM_Immune",
    "DEM_MDP_decision",
    "DEM_SARS",
    "DEM_SARS_I",
    "DEM_Stephen",
    "DEM_birdsong",
    "DEM_cells",
    "DEM_cells_cells",
    "DEM_coupled_oscillators",
    "DEM_dSprites",
    "DEM_demo",
    "DEM_demo_ALAP",
    "DEM_demo_Bayesian_Model_Reduction",
    "DEM_demo_Cornsweet",
    "DEM_demo_DCM_LAP",
    "DEM_demo_DEM",
    "DEM_demo_DFP",
    "DEM_demo_EM",
    "DEM_demo_GF_and_KF",
    "DEM_demo_GLM",
    "DEM_demo_Gabor",
    "DEM_demo_LAP",
    "DEM_demo_Lagrangian",
    "DEM_demo_Lagrangian_flow",
    "DEM_demo_Lorenz",
    "DEM_demo_MDP_DEM",
    "DEM_demo_MDP_X",
    "DEM_demo_MDP_XX",
    "DEM_demo_MDP_fit",
    "DEM_demo_MDP_fit_fields",
    "DEM_demo_MDP_habits",
    "DEM_demo_MDP_maze",
    "DEM_demo_MDP_reading",
    "DEM_demo_MDP_rule",
    "DEM_demo_MDP_search",
    "DEM_demo_MMN",
    "DEM_demo_MMN_deviance",
    "DEM_demo_MMN_gen",
    "DEM_demo_OU",
    "DEM_demo_PEB",
    "DEM_demo_Posner",
    "DEM_demo_SOC",
    "DEM_demo_connectivity_fMRI",
    "DEM_demo_contact_lens",
    "DEM_demo_convolution",
    "DEM_demo_convolution_LAP",
    "DEM_demo_dendrite",
    "DEM_demo_double_well",
    "DEM_demo_doublewell_LAP",
    "DEM_demo_duet",
    "DEM_demo_fMRI_HMM",
    "DEM_demo_fMRI_PEB",
    "DEM_demo_face_inference",
    "DEM_demo_factor_analysis",
    "DEM_demo_filtering",
    "DEM_demo_hdm",
    "DEM_demo_hdm_LAP",
    "DEM_demo_hdm_SCK",
    "DEM_demo_hierarchical_optmisation",
    "DEM_demo_induced_fMRI",
    "DEM_demo_large_fMRI",
    "DEM_demo_lorenz_LAP",
    "DEM_demo_modes_fMRI",
    "DEM_demo_ontology",
    "DEM_demo_psychosis",
    "DEM_demo_song_inference",
    "DEM_demo_song_omission",
    "DEM_demo_song_priors",
    "DEM_demo_texture",
    "DEM_evidence_accumulation",
    "DEM_get_faces",
    "DEM_morphogenesis",
    "DEM_path_integrals",
    "DEM_psychophysics",
    "DEM_self_entropy",
    "DEM_sharing",
    "DEM_spatial_deconvolution",
    "DEM_surveillance",
    "DEM_vaccination",
    "DFP_demo_double_well",
    "DFP_demo_hdm",
    "FEP_MB_demo",
    "FEP_Manifold",
    "FEP_fluctuations",
    "FEP_information_length",
    "FEP_lorenz_surprise",
    "FEP_physics",
    "FEP_self_entropy",
    "KLDemo",
    "MDP_DEM_Mixed_Models_Movement",
    "MDP_DEM_Oculomotion_Pharma_demo",
    "MDP_DEM_Oculomotion_demo",
    "MDP_Heart_Beat",
    "Markov_blankets_and_NESS",
    "expmall",
    "ndstest",
    "spm_ADEM_cue_rt",
    "spm_ADEM_set_rt",
    "spm_CLIMATE_ci",
    "spm_CLIMATE_gen",
    "spm_CLIMATE_plot",
    "spm_CLIMATE_priors",
    "spm_COVID",
    "spm_COVID_B",
    "spm_COVID_BMR",
    "spm_COVID_PV",
    "spm_COVID_R_cii",
    "spm_COVID_S",
    "spm_COVID_SB",
    "spm_COVID_T",
    "spm_COVID_TS",
    "spm_COVID_US",
    "spm_COVID_Y",
    "spm_COVID_ci",
    "spm_COVID_dashboard",
    "spm_COVID_gen",
    "spm_COVID_plot",
    "spm_COVID_priors",
    "spm_COVID_priors_R",
    "spm_COVID_table",
    "spm_DEM_ButtonDownFcn",
    "spm_DEM_EEG",
    "spm_DEM_M",
    "spm_DEM_MEG",
    "spm_DEM_T",
    "spm_DEM_basis",
    "spm_DEM_movie",
    "spm_DEM_play",
    "spm_DEM_play_song",
    "spm_DEM_qC",
    "spm_Lap2Lorenz",
    "spm_MDP",
    "spm_MDP_DEM",
    "spm_MDP_DP",
    "spm_MDP_F",
    "spm_MDP_G",
    "spm_MDP_L",
    "spm_MDP_VB",
    "spm_MDP_VB_ERP",
    "spm_MDP_VB_LFP",
    "spm_MDP_VB_X",
    "spm_MDP_VB_XX",
    "spm_MDP_VB_XXX",
    "spm_MDP_VB_game",
    "spm_MDP_VB_sleep",
    "spm_MDP_VB_trial",
    "spm_MDP_VB_update",
    "spm_MDP_check",
    "spm_MDP_factor_graph",
    "spm_MDP_game",
    "spm_MDP_game_KL",
    "spm_MDP_game_optimism",
    "spm_MDP_link",
    "spm_MDP_log_evidence",
    "spm_MDP_mountain_car",
    "spm_MDP_offer",
    "spm_MDP_plot",
    "spm_MDP_size",
    "spm_MDP_structure_learning",
    "spm_MDP_trust",
    "spm_MDP_urn",
    "spm_NESS_constraints",
    "spm_SARS_ci",
    "spm_SARS_gen",
    "spm_SARS_plot",
    "spm_SARS_priors",
    "spm_SARS_priors_B",
    "spm_SCK",
    "spm_SHC_fx",
    "spm_cornsweet",
    "spm_cost_SHC_fx",
    "spm_cost_SHC_fxa",
    "spm_cost_SHC_path",
    "spm_cost_fx",
    "spm_cost_fxa",
    "spm_dem_ERP",
    "spm_dem_cue_movie",
    "spm_dem_initialise",
    "spm_dem_mdp_movie",
    "spm_dem_occlusion_movie",
    "spm_dem_pursuit_movie",
    "spm_dem_reach_movie",
    "spm_dem_reach_plot",
    "spm_dem_reach_x2J",
    "spm_dem_search_movie",
    "spm_dem_search_plot",
    "spm_dem_search_trajectory",
    "spm_dem_set_movie",
    "spm_diff_all",
    "spm_find_internal",
    "spm_fx_Gabor",
    "spm_fx_Lagrangian",
    "spm_fx_adem_cue",
    "spm_fx_adem_pursuit",
    "spm_fx_adem_reach",
    "spm_fx_adem_salience",
    "spm_fx_adem_write",
    "spm_fx_dem_cue",
    "spm_fx_dem_observe",
    "spm_fx_dem_pursuit",
    "spm_fx_dem_reach",
    "spm_fx_dem_salience",
    "spm_fx_dem_write",
    "spm_fx_hdm_sck",
    "spm_fx_mountaincar",
    "spm_fx_mountaincar_Q",
    "spm_gamma_log_evidence",
    "spm_gx_Gabor",
    "spm_gx_SHC",
    "spm_gx_adem_cue",
    "spm_gx_adem_pursuit",
    "spm_gx_adem_reach",
    "spm_gx_adem_salience",
    "spm_gx_adem_write",
    "spm_gx_dem_cue",
    "spm_gx_dem_pursuit",
    "spm_gx_dem_reach",
    "spm_gx_dem_salience",
    "spm_gx_dem_write",
    "spm_gx_hdm_sck",
    "spm_ho_gm",
    "spm_ho_poly",
    "spm_immune",
    "spm_immune_gen",
    "spm_immune_plot",
    "spm_immune_priors",
    "spm_mc_fx",
    "spm_mc_fx_1",
    "spm_mc_fx_2",
    "spm_mc_fx_3",
    "spm_mc_fx_4",
    "spm_mc_fx_5",
    "spm_mc_fxa_4",
    "spm_mc_fxa_5",
    "spm_mc_loss_C",
    "spm_mc_loss_G",
    "spm_meta_model",
    "spm_mountaincar_Q",
    "spm_mountaincar_fun",
    "spm_mountaincar_movie",
    "spm_multinomial_log_evidence",
    "spm_salience_map",
    "spm_voice",
    "spm_voice_FS",
    "spm_voice_P300",
    "spm_voice_Q",
    "spm_voice_check",
    "spm_voice_dct",
    "spm_voice_ff",
    "spm_voice_filter",
    "spm_voice_frequency",
    "spm_voice_fundamental",
    "spm_voice_get_LEX",
    "spm_voice_get_next",
    "spm_voice_get_word",
    "spm_voice_get_xY",
    "spm_voice_i",
    "spm_voice_iQ",
    "spm_voice_identity",
    "spm_voice_iff",
    "spm_voice_likelihood",
    "spm_voice_onset",
    "spm_voice_onsets",
    "spm_voice_read",
    "spm_voice_repeat",
    "spm_voice_segmentation",
    "spm_voice_speak",
    "spm_voice_test",
    "spm_voice_warp",
    "FieldMap",
    "FieldMap_Run",
    "FieldMap_applyvdm",
    "FieldMap_create",
    "FieldMap_preprocess",
    "pm_angvar",
    "pm_brain_mask",
    "pm_create_connectogram",
    "pm_diff",
    "pm_estimate_ramp",
    "pm_ff_unwrap",
    "pm_get_defaults",
    "pm_initial_regions",
    "pm_invert_phasemap",
    "pm_make_fieldmap",
    "pm_mask",
    "pm_merge_regions",
    "pm_merge_regions_m",
    "pm_pad",
    "pm_restore_ramp",
    "pm_seed",
    "pm_smooth_phasemap",
    "pm_unwrap",
    "tbx_cfg_fieldmap",
    "spm_compute_avg_mat",
    "spm_dexpm",
    "spm_groupwise_ls",
    "spm_meanm",
    "spm_noise_estimate",
    "spm_pairwise",
    "spm_rice_mixture",
    "spm_series_align",
    "tbx_cfg_longitudinal",
    "fil_fit",
    "fil_install",
    "fil_io",
    "fil_label",
    "fil_prec",
    "fil_prune",
    "fil_push_train_data",
    "fil_subvol",
    "fil_train",
    "spm_label",
    "spm_mb_appearance",
    "spm_mb_classes",
    "spm_mb_fit",
    "spm_mb_gmm",
    "spm_mb_init",
    "spm_mb_io",
    "spm_mb_merge",
    "spm_mb_output",
    "spm_mb_shape",
    "spm_mbnorm",
    "tbx_cfg_mb",
    "spm_MEEGtools",
    "spm_create_labels",
    "spm_eeg_bst_fooof",
    "spm_eeg_cont_power",
    "spm_eeg_ctf_synth_gradiometer",
    "spm_eeg_dipole_waveforms",
    "spm_eeg_erp_correction",
    "spm_eeg_ffilter",
    "spm_eeg_fix_ctf_headloc",
    "spm_eeg_ft_artefact_visual",
    "spm_eeg_ft_datareg_manual",
    "spm_eeg_ft_megplanar",
    "spm_eeg_ft_multitaper_coherence",
    "spm_eeg_headplot",
    "spm_eeg_img2maps",
    "spm_eeg_interpolate_artefact",
    "spm_eeg_inv_optireg",
    "spm_eeg_megheadloc",
    "spm_eeg_recode_epoched_ctf",
    "spm_eeg_remove_jumps",
    "spm_eeg_remove_spikes",
    "spm_eeg_reref_eeg",
    "spm_eeg_split_conditions",
    "spm_eeg_tms_correct",
    "spm_eeg_transform_cap",
    "spm_eeg_var_measures",
    "spm_mesh_pack_points",
    "spm_opm_create",
    "spm_opm_epoch_trigger",
    "spm_opm_headmodel",
    "spm_opm_hfc",
    "spm_opm_opreg",
    "spm_opm_plotScalpData",
    "spm_opm_psd",
    "spm_opm_read_lvm",
    "spm_opm_rpsd",
    "spm_opm_sim",
    "spm_opm_synth_gradiometer",
    "spm_opm_vslm",
    "spm_dcm_nvc",
    "spm_dcm_nvc_nd",
    "spm_dcm_nvc_priors",
    "spm_dcm_nvc_specify",
    "spm_fx_cmc_tfm_gen",
    "spm_gen_par",
    "spm_nvc_gen",
    "DEMO_dcm_fmri_nnm",
    "DEMO_model_reduction_ERP",
    "DEMO_tvec_csd_sim",
    "DEMO_tvec_erp_mmn",
    "DEMO_tvec_erp_sim",
    "spm_csd_mtf_plot_pole_zero",
    "spm_dcm_x_neural_NMDA",
    "spm_fx_NMDA",
    "spm_fx_mfm_NMDA",
    "spm_lfp_mtf_sample",
    "spm_nmm_priors_NMDA",
    "spm_x_mfm_NMDA",
    "Neural_demo",
    "ROBOT_NMM",
    "spm_csd_demo",
    "spm_dcm_Granger_asymmetry_demo",
    "spm_dcm_Granger_demo",
    "spm_dcm_prior_responses",
    "spm_delays_demo",
    "spm_demo_proceed",
    "spm_erp2csd_demo",
    "spm_freqs",
    "spm_fx_hh",
    "spm_fx_lfp",
    "spm_fx_mfm_ensemble",
    "spm_gx_hh",
    "spm_gx_mfm",
    "spm_ind_demo",
    "spm_induced_optimise",
    "spm_induced_optimise_parameters",
    "spm_lfp_demo",
    "spm_lfp_log",
    "spm_lfp_mtf",
    "spm_lfp_priors",
    "spm_lfp_sqrt",
    "spm_mfa",
    "spm_mfa_G",
    "spm_mfa_bi",
    "spm_mfa_bi_multi",
    "spm_mfa_demo",
    "spm_mfm_demo",
    "spm_mtf_demo",
    "spm_neil",
    "spm_nested_oscillations_demo",
    "spm_nmda_priors",
    "spm_opt_bfun",
    "spm_seizure_demo",
    "spm_sigmoid_demo",
    "spm_affreg",
    "spm_brainwarp",
    "spm_cfg_normalise",
    "spm_get_orig_coord",
    "spm_normalise",
    "spm_normalise_disp",
    "spm_run_normalise",
    "spm_write_sn",
    "spm_cfg_preproc",
    "spm_invdef",
    "spm_load_priors",
    "spm_maff",
    "spm_prep2sn",
    "spm_preproc_write",
    "spm_run_preproc",
    "spm_sample_priors",
    "spm_SEM_gen",
    "spm_SEM_gen_full",
    "spm_dcm_spem",
    "spm_dcm_spem_data",
    "spm_dcm_spem_results",
    "spm_sextract",
    "spm_srender",
    "tbx_cfg_render",
    "covLin",
    "spm_GPclass",
    "spm_def2sparse",
    "spm_dotprods2",
    "spm_lincom",
    "spm_shoot3d",
    "spm_shoot3di",
    "spm_shoot_blur",
    "spm_shoot_defaults",
    "spm_shoot_divergence",
    "spm_shoot_greens",
    "spm_shoot_kernel",
    "spm_shoot_norm",
    "spm_shoot_scalmom",
    "spm_shoot_template",
    "spm_shoot_update",
    "spm_shoot_warp",
    "tbx_cfg_shoot",
    "lbessi",
    "pp_settings",
    "pull",
    "pullg",
    "push",
    "spm_TVdenoise",
    "spm_TVdenoise2",
    "spm_TVdenoise_config",
    "spm_dctdst",
    "spm_run_denoise",
    "spm_scope",
    "spm_scope_config",
    "spm_slice2vol",
    "spm_slice2vol_config",
    "spm_slice2vol_estimate",
    "spm_slice2vol_reslice",
    "spm_topup",
    "spm_topup_config",
    "tbx_cfg_spatial",
    "tbx_cfg_tsss",
    "tsss_config",
    "tsss_config_momentspace",
    "tsss_spm_enm",
    "tsss_spm_momentspace",
    "estimate_greens_mmclab",
    "spm_dcm_fnirs_estimate",
    "spm_dcm_fnirs_params",
    "spm_dcm_fnirs_priors",
    "spm_dcm_fnirs_specify",
    "spm_dcm_fnirs_viewer_result",
    "spm_fnirs_sensitivity",
    "spm_fnirs_viewer_sensor",
    "spm_fnirs_wavg",
    "spm_fx_fnirs",
    "spm_gx_fnirs",
    "spm_gx_state_fnirs",
    "spm_L_priors",
    "spm_api_erp",
    "spm_api_nmm",
    "spm_bgt_priors",
    "spm_cmc_priors",
    "spm_cmm_NMDA_priors",
    "spm_cmm_priors",
    "spm_csd_chf",
    "spm_csd_int",
    "spm_csd_int_IS",
    "spm_csd_mtf",
    "spm_csd_mtf_gu",
    "spm_dcm_csd",
    "spm_dcm_csd_data",
    "spm_dcm_csd_plot",
    "spm_dcm_csd_priors",
    "spm_dcm_csd_results",
    "spm_dcm_csd_source_optimise",
    "spm_dcm_csd_source_plot",
    "spm_dcm_dem",
    "spm_dcm_eeg_channelmodes",
    "spm_dcm_erp",
    "spm_dcm_erp_bma",
    "spm_dcm_erp_data",
    "spm_dcm_erp_dipfit",
    "spm_dcm_erp_plot",
    "spm_dcm_erp_results",
    "spm_dcm_erp_sensitivity",
    "spm_dcm_erp_update",
    "spm_dcm_erp_viewspatial",
    "spm_dcm_ind",
    "spm_dcm_ind_data",
    "spm_dcm_ind_results",
    "spm_dcm_local_minima",
    "spm_dcm_lock",
    "spm_dcm_neural_priors",
    "spm_dcm_neural_x",
    "spm_dcm_nfm",
    "spm_dcm_phase",
    "spm_dcm_phase_data",
    "spm_dcm_phase_results",
    "spm_dcm_search_eeg",
    "spm_dcm_ssr",
    "spm_dcm_ssr_data",
    "spm_dcm_ssr_results",
    "spm_dcm_symm",
    "spm_dcm_tfm",
    "spm_dcm_tfm_data",
    "spm_dcm_tfm_data_nopad",
    "spm_dcm_tfm_image",
    "spm_dcm_tfm_multimodal",
    "spm_dcm_tfm_response",
    "spm_dcm_tfm_results",
    "spm_dcm_tfm_transfer",
    "spm_dcm_virtual_electrodes",
    "spm_dcm_x_neural",
    "spm_eeg_inv_ecd_DrawDip",
    "spm_epileptor_demo",
    "spm_erp_L",
    "spm_erp_priors",
    "spm_erp_u",
    "spm_fp_cmc_tfm",
    "spm_fs_csd",
    "spm_fx_bgt",
    "spm_fx_cmc",
    "spm_fx_cmc_2014",
    "spm_fx_cmc_tfm",
    "spm_fx_cmm",
    "spm_fx_cmm_NMDA",
    "spm_fx_erp",
    "spm_fx_gen",
    "spm_fx_ind",
    "spm_fx_mfm",
    "spm_fx_mfm_D",
    "spm_fx_mmc",
    "spm_fx_nmda",
    "spm_fx_null",
    "spm_fx_phase",
    "spm_fx_sep",
    "spm_fx_tfm",
    "spm_fx_tfm_P",
    "spm_fy_erp",
    "spm_gen_Q",
    "spm_gen_erp",
    "spm_gen_ind",
    "spm_gen_phase",
    "spm_gx_erp",
    "spm_ind_priors",
    "spm_int_U",
    "spm_lx_dem",
    "spm_lx_erp",
    "spm_lx_ind",
    "spm_lx_phase",
    "spm_mg_switch",
    "spm_mmc_priors",
    "spm_nfm_mtf",
    "spm_nfm_priors",
    "spm_nmm_priors",
    "spm_null_priors",
    "spm_phase_priors",
    "spm_ssr_priors",
    "spm_tfm_priors",
    "spm_x_cmc",
    "spm_x_cmm",
    "spm_x_cmm_NMDA",
    "spm_x_erp",
    "spm_x_lfp",
    "spm_x_mfm",
    "spm_x_nmda",
    "spm_x_nmm",
    "mci_compare_forward",
    "mci_compare_gradients",
    "mci_compare_jacobians",
    "mci_compare_setup",
    "spm_mci_adjoint",
    "spm_mci_adjoint_int",
    "spm_mci_adjoint_sun",
    "spm_mci_flow_sun",
    "spm_mci_flow_t",
    "spm_mci_fwd",
    "spm_mci_grad_curve",
    "spm_mci_joint",
    "spm_mci_joint_grad",
    "spm_mci_sens",
    "spm_mci_sens_init",
    "spm_mci_sens_sun",
    "spm_mci_ais",
    "spm_mci_ais_single",
    "spm_mci_ais_single_vl",
    "spm_mci_check",
    "spm_mci_diag",
    "spm_mci_diff",
    "spm_mci_ess",
    "spm_mci_fixed",
    "spm_mci_glike",
    "spm_mci_glike_deriv",
    "spm_mci_gprior_deriv",
    "spm_mci_init_flow",
    "spm_mci_isvl",
    "spm_mci_lgv",
    "spm_mci_lgv_vl",
    "spm_mci_like_ind",
    "spm_mci_mfx",
    "spm_mci_mfx_dynamic",
    "spm_mci_mh",
    "spm_mci_mh_update",
    "spm_mci_minit",
    "spm_mci_mvnpost",
    "spm_mci_mvntest",
    "spm_mci_obsnoise",
    "spm_mci_phm",
    "spm_mci_pop",
    "spm_mci_popdef",
    "spm_mci_post",
    "spm_mci_postslices",
    "spm_mci_priors",
    "spm_mci_quantiles",
    "spm_mci_random",
    "spm_mci_report",
    "spm_mci_stat",
    "spm_mci_switch",
    "spm_mci_switch_prep",
    "spm_mci_update_cov",
    "spm_mci_vw_init",
    "spm_mvtpdf",
    "spm_nwcov",
    "spm_nwpost",
    "spm_nwrnd",
    "spm_wishrnd",
    "mci_approach_deriv",
    "mci_approach_gen",
    "mci_approach_like",
    "mci_approach_struct",
    "mci_discount_act",
    "mci_discount_deriv",
    "mci_discount_gen",
    "mci_discount_like",
    "mci_discount_struct",
    "mci_pb_deriv",
    "mci_pb_gen",
    "mci_pb_like",
    "mci_pb_struct",
    "mci_exp_init",
    "mci_interp_init",
    "mci_lds_dfdx",
    "mci_lds_fx",
    "mci_lds_gen",
    "mci_lds_group_data",
    "mci_lds_gx",
    "mci_lds_lat2par",
    "mci_lds_par2lat",
    "mci_lds_params",
    "mci_lds_plot_params",
    "mci_lds_struct",
    "mci_linear_deriv",
    "mci_linear_gen",
    "mci_linear_like",
    "mci_linear_post",
    "mci_linear_struct",
    "mci_linsqr_deriv",
    "mci_linsqr_gen",
    "mci_linsqr_like",
    "mci_linsqr_struct",
    "mci_logistic_act",
    "mci_logistic_deriv",
    "mci_logistic_gen",
    "mci_logistic_like",
    "mci_logistic_struct",
    "mci_nmm_fx_delay",
    "mci_nmm_gen",
    "mci_nmm_params",
    "mci_nmm_r2_gx",
    "mci_nmm_r2p2_dfdp",
    "mci_nmm_r2p2_dfdx",
    "mci_nmm_r2p2_fx",
    "mci_nmm_r2p6_fx",
    "mci_nmm_struct",
    "mci_phase_dfdp",
    "mci_phase_dfdx",
    "mci_phase_fx",
    "mci_phase_gx",
    "mci_phase_init",
    "mci_rphase_dfdp",
    "mci_rphase_dfdx",
    "mci_rphase_fx",
    "mci_rphase_gen",
    "mci_rphase_struct",
    "mci_ramsay_fx",
    "mci_ramsay_gen",
    "mci_ramsay_gx",
    "mci_ramsay_struct",
    "mci_plot_surface",
    "spm_MNpdf",
    "spm_boxcars",
    "spm_glm",
    "spm_kmeans",
    "spm_kmeans1",
    "spm_mix",
    "spm_mix_demo1d",
    "spm_rglm",
    "spm_samp_gauss",
    "spm_samp_mix",
    "spm_cva_compare",
    "spm_cva_prob",
    "spm_mlm_bayes",
    "spm_mlm_makecon",
    "spm_mlm_posthoc",
    "spm_pca_order",
    "spm_vpca",
    "spm_vpca_f",
    "spm_vpca_init",
    "spm_vpca_update",
    "spm_ar",
    "spm_ar_freq",
    "spm_ar_pred",
    "spm_ccf2coh",
    "spm_ccf2cor",
    "spm_ccf2csd",
    "spm_ccf2gew",
    "spm_ccf2mar",
    "spm_csd",
    "spm_csd2ccf",
    "spm_csd2coh",
    "spm_csd2gew",
    "spm_csd2mar",
    "spm_dcm2ssm",
    "spm_dpss",
    "spm_dtf2gew",
    "spm_get_omega",
    "spm_granger",
    "spm_ker2ccf",
    "spm_ker2coh",
    "spm_ker2csd",
    "spm_ker2mtf",
    "spm_kl_eig_normal",
    "spm_mar",
    "spm_mar2ccf",
    "spm_mar2coh",
    "spm_mar2csd",
    "spm_mar2gew",
    "spm_mar_conn",
    "spm_mar_gen",
    "spm_mar_pred",
    "spm_mar_prior",
    "spm_mar_spectra",
    "spm_mmtspec",
    "spm_mtf2ccf",
    "spm_mtf2coh",
    "spm_mtf2csd",
    "spm_mtf2gew",
    "spm_rar",
    "spm_spectral_plot",
    "spm_ssm2ccf",
    "spm_ssm2coh",
    "spm_ssm2csd",
    "spm_ssm2ker",
    "spm_ssm2mtf",
    "spm_wavspec",
]
