from mpython import Runtime


def spm_klaff(*args, **kwargs):
    """
      Affine registration by minimising Kullback-Leibler Divergence
        FORMAT M = spm_klaff(Nf,Ng,flag)
        Nf   - NIfTI handle for one image
        Ng   - Nifti handle for the other.  If not passed, then
               spm*/toolbox/Seg/TPM.nii is used.
        flag - an optional argument to indicate a Shoot template
        M    - The voxel-for-voxel affine transform

        The images that are matched are tissue probability maps, in the same form
        as spm/tpm/TPM.nii or the Template files generated by Dartel.  To save
        some memory, no more than three (GM, WM and other) classes are matched
        together.

        Note that the code is very memory hungry because it stores a load of
        image gradients.  If it doesn't work because of this, the recommandation
        is to buy a more powerful computer.
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DARTEL/spm_klaff.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_klaff", *args, **kwargs)
