from mpython import Runtime


def ADEM_eyeblink(*args, **kwargs):
    """
      Simulation of eyeblink conditioning
        FORMAT DEM = ADEM_eyeblink(OPTION)

         OPTION:
            case{'EYEBLINK'}   : spontaneous eye blinking
            case{'AIRPUFF'}    : unconditioned eyeblink response to air puff
            case{'STARTLE'}    : unconditioned  startle response to a sound
            case{'TRACE'}      : trace conditioning to the sound
            case{'DELAY'}      : delay conditioning to the sound
            case{'EXTINCTION'} : extinction of trace conditioning to sound

       __________________________________________________________________________

        This demonstration routine illustrates Pavlovian learning under active
        inference. It uses the eyeblink conditioning paradigm to model startle
        responses and the subsequent acquisition of an eyeblink - under delay and
        trace learning. The various options above determine the nature of the
        simulation (or edit the OPTION below). The generative model, in this
        example, starts with a heteroclinic cycle with an inset. The cycle per se
        generates autonomous eyeblinks periodically, while the inset is
        activated by a conditioned stimulus (CS). The subsequent unstable fixed
        points play the role of an echo-state and enables the learning or
        association of a high-level hidden cause with subsequent unconditioned
        responses (UR).

        In active inference, an unconditioned response corresponds to a prior
        belief that a hidden state will generate action and the unconditioned
        stimulus (US). Pavlovian conditioning is the learning of the Association
        between a conditioned stimulus (CS) and the unconditioned response. The
        dynamics entailed by the heteroclinic cycle enable trace conditioning,
        which may be related to hippocampal function.

        In this example, there are two levels with the hidden states at the first
        level modelling beliefs about eyeblinks, unconditioned responses and
        unconditioned stimuli.  Proprioceptive predictions are generated by
        beliefs about ensuing eyeblinks and unconditioned responses (which
        also predict the conditioned stimulus. Hidden states at the second level
        embody a sense of time through Lotka-Volterra dynamics. Successive epochs
        of time are passed to the first level via a softmax transform. Learning
        corresponds to Hebbian plasticity (that minimises free energy) in the
        connections between the state unit encoding expectations about a UR and
        expectations about the CS (for delay conditioning) and heteroclinic
        states (for trace conditioning): see the functions at the end of this
        routine.
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/ADEM_eyeblink.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("ADEM_eyeblink", *args, **kwargs)
