from mpython import Runtime


def DEM_spatial_deconvolution(*args, **kwargs):
    """
      FORMAT DEM_spatial_deconvolution
       --------------------------------------------------------------------------
        This (toy) demonstration routine illustrates spatiotemporal
        deconvolution of regional responses from imaging time-series.  The
        generative model assumes the data are generated by a small number of
        anatomical parcels that are smoothly displaced. The resulting data are
        then convolved spatially with a smoothly varying spatial kernel. The smooth
        displacement and dispersion are modelled in the usual way using discrete
        cosine basis set.  The model operates on reduced data features, using
        the eigenvariates of the original time-series - this supplements the
        implicit deconvolution with eigen-de-noising.  The ensuing estimates are
        anatomically informed because the generative model stars with a parcellation
        scheme.
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/DEM/DEM_spatial_deconvolution.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("DEM_spatial_deconvolution", *args, **kwargs, nargout=0)
