from mpython import Runtime


def spm_shoot_norm(*args, **kwargs):
    """
      Spatially normalise and smooth fMRI/PET data to MNI space, using Shoot deformation fields
        FORMAT out = spm_shoot_norm(job)
        job - a structure generated by the configuration file
          job.template - Shoot template for aligning to MNI space. Aligns to population
                         average if no template is provided.
          job.subj(n)  - Subject n
              subj(n).def    - Shoot deformation field
              subj(n).images - Images for this subject
          job.vox      - Voxel sizes for spatially normalised images
          job.bb       - Bounding box for spatially normalised images
          job.preserve - How to transform
                         0 = preserve concentrations
                         1 = preserve integral (cf "modulation")

        Normally, Shoot generates deformations that align with the average-
        shaped template.  This routine includes the option to compose the
        shoot deformations with an affine transform derived from an affine
        registration of the template (the final one generated by Shoot),
        with the TPM data released with SPM.

        Note that trilinear interpolation is used, and no masking is done.  It
        is therefore essential that the images are realigned and resliced
        before they are spatially normalised.  Alternatively, contrast images
        generated from unsmoothed native-space fMRI/PET data can be spatially
        normalised for a 2nd level analysis.

        Two "preserve" options are provided.  One of them should do the
        equavalent of generating smoothed "modulated" spatially normalised
        images.  The other does the equivalent of smoothing the modulated
        normalised fMRI/PET, and dividing by the smoothed Jacobian determinants.

       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/toolbox/Shoot/spm_shoot_norm.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_shoot_norm", *args, **kwargs)
