from mpython import Runtime


def spm_dcm_create(*args, **kwargs):
    """
      Create a DCM with simulated data (specified via GUI or an existing model)
        FORMAT spm_dcm_create(syn_model,source_model,SNR)

        syn_model     - name of the synthetic DCM to be created
        source_model  - define new model ('GUI')
                        or import existing model via file selector ('import')
                        or import existing model (directly specified by directory
                        and name)
                        [default: 'GUI']
        SNR           - signal-to-noise ratio [default: 1]

        This function allows to create DCM networks with known connectivity
        parameters from which synthetic data are then generated by calling
        spm_dcm_generate.

        This function is very much like spm_dcm_specify_ui but inputs etc. are
        specified either via the user interface or from an existing model.
        Currently, the interface provided by this function does not allow for
        manual specification of nonlinear DCMs; however, these can be imported
        from existing files.
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/spm_dcm_create.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_dcm_create", *args, **kwargs, nargout=0)
