from mpython import Runtime


def spm_dicom_text_to_dict(*args, **kwargs):
    """
      Create a DICOM dictionary .mat file from a text version
        FORMAT dict = spm_dicom_text_to_dict(textfile)
        OR            spm_dicom_text_to_dict(textfile)
        textfile    - the name of a suitable text version of the dictionary.
                      With no output argument, the results are saved in a .mat
                      file of the same base name.
       __________________________________________________________________________
        The text version is typically generated by copy/pasting from the
        "Digital Imaging and Communications in Medicine (DICOM) Part 6:
        Data Dictionary" pdf file from http://medical.nema.org/standard.html,
        and manually tidying it up (about a solid day's effort).  A
        re-formatted text version is then obtained by running the following:

        awk < DICOM2011_dict.txt '{if ($NF=="RET") print $1,$(NF-3),$(NF-2),$(NF-1); else print $1,$(NF-2),$(NF-1),$(NF);}' | sed 's/(/ /' | sed 's/,/ /' | sed 's/)//' | awk '{printf("%s\t%s\t%s\t%s\t%s\n", $1,$2,$3,$4,$5)}' > new_dicom_dict.txt

        After this, the spm_dicom_text_to_dict function can be run to generate
        the data dictionary.
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/spm_dicom_text_to_dict.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_dicom_text_to_dict", *args, **kwargs)
