from mpython import Runtime


def spm_preproc8(*args, **kwargs):
    """
      Combined Segmentation and Spatial Normalisation

        FORMAT results = spm_preproc8(obj)

        obj is a structure, and must have the following fields...
           image    - a structure (array) of handles of individual scans,
                      of the sort returned by spm_vol.  Data can be
                      multispectral, with N channels, but files must be in
                      voxel-for-voxel alignment.
           biasfwhm - FWHM of bias field(s). There are N elements, one for
                      each channel.
           biasreg  - Regularisation of bias field estimation. N elements.
           tpm      - Tissue probability map data, as generated by
                      spm_load_priors.  This would represent Kb different
                      tissue classes - including air (background).
           lkp      - A lookup table indicating which Gaussians should be used
                      with each of the Kb tissue probability maps.  For example,
                      if there are 6 tissue types, with two Gaussians to
                      represent each, except the 5th, which uses 4 Gaussians,
                      then lkp=[1,1,2,2,3,3,4,4,5,5,5,5,6,6].
           Affine   - a 4x4 affine transformation matrix, such that the mapping
                      from voxels in the individual to those in the template
                      is by tpm.M\Affine*obj.image(1).mat.
           reg      - Regularisation for the nonlinear registration of the
                      template (tissue probability maps) to the individual.
           samp     - The distance (mm) between samples.  In order to achieve
                      a reasonable speed, not all voxels in the images are
                      used for the parameter estimation.  Better segmentation
                      would be expected if all were used, but this would be
                      extremely slow.
           fwhm     - A smoothness estimate for computing a fudge factor that
                      tries to account for spatial covariance in the noise.

        obj also has some optional fields...
           mg       - a 1xK vector (where K is the lengrh of obj.lkp). This
                      represents the mixing proportions within each tissue.
           mn       - an NxK matrix containing the means of the Gaussians.
           vr       - an NxNxK matrix containing the covariances of each of
                      the Gaussians.
           Tbias    - a cell array encoding the parameterisation of each bias
                      field.
           Twarp    - the encoding of the nonlinear deformation field.

        Various estimated parameters are saved as fields of the results
        structure.  Some of these are taken from the input, whereas others
        are estimated or optimised...
           results.image  = obj.image;
           results.tpm    = obj.tpm.V;
           results.Affine = obj.Affine;
           results.lkp    = obj.lkp;
           results.MT     = an affine transform used in conjunction with the
                            parameterisation of the warps.
           results.Twarp  = obj.Twarp;
           results.Tbias  = obj.Tbias;
           results.mg     = obj.mg;
           results.mn     = obj.mn;
           results.vr     = obj.vr;
           results.ll     = Log-likelihood.

       __________________________________________________________________________

        The general principles are described in the following paper, but some
        technical details differ.  These include a different parameterisation
        of the deformations, the ability to use multi-channel data and the
        use of a fuller set of tissue probability maps.  The way the mixing
        proportions are dealt with is also slightly different.

        Ashburner J & Friston KJ. "Unified segmentation".
        NeuroImage 26(3):839-851 (2005).
       __________________________________________________________________________


    [Matlab code]( https://github.com/spm/spm/blob/main/spm_preproc8.m )

    Copyright (C) 1995-2025 Functional Imaging Laboratory, Department of Imaging Neuroscience, UCL
    """
    return Runtime.call("spm_preproc8", *args, **kwargs)
