"""
This module implements the objective functions.

"""

from .init import (
    fun_control_init,
    design_control_init,
    surrogate_control_init,
    optimizer_control_init,
    _init_prefix,
    setup_paths,
    create_spot_tensorboard_path,
    X_reshape,
    check_and_create_dir,
    get_experiment_name,
    get_spot_tensorboard_path,
    get_tensorboard_path,
    get_feature_names,
)
from .aggregate import aggregate_mean_var, get_ranks, select_distant_points
from .classes import get_additional_attributes, get_additional_methods, remove_attributes, reset_weights, add_attributes, get_removed_attributes_and_base_net
from .compare import selectNew, find_equal_in_lists
from .convert import class_for_name, get_Xy_from_df, find_indices, series_to_array, add_logical_columns, map_to_True_False, sort_by_kth_and_return_indices, check_type, set_dataset_target_type
from .device import getDevice
from .eda import (
    get_stars,
    print_exp_table,
    print_res_table,
    gen_design_table,
    compare_two_tree_models,
    generate_config_id,
    filter_highly_correlated,
    plot_sns_heatmap,
    count_missing_data,
    plot_missing_data,
)
from .file import (
    load_cifar10_data,
    save_pickle,
    load_pickle,
    get_experiment_filename,
    get_result_filename,
    _handle_res_filename,
    _handle_exp_filename,
    load_result,
    load_experiment,
    load_and_run_spot_python_experiment,
    load_dict_from_file,
    load_core_model_from_file,
)
from .math import generate_div2_list
from .metrics import apk, mapk, mapk_score, mapk_scorer, get_metric_sign
from .numpy2json import NumpyEncoder
from .progress import progress_bar
from .repair import repair_non_numeric, remove_nan, apply_penalty_NA
from .scaler import TorchStandardScaler, TorchMinMaxScaler
from .seed import set_all_seeds
from .split import compute_lengths_from_fractions, calculate_data_split
from .tensorboard import start_tensorboard, stop_tensorboard
from .time import get_timestamp
from .transform import (
    transform_multby2_int,
    transform_power_2_int,
    transform_power_10_int,
    transform_power_2,
    transform_power_10,
    transform_none_to_None,
    transform_power,
    transform_hyper_parameter_values,
    scale,
    nat_to_cod_X,
    nat_to_cod_y,
    cod_to_nat_X,
    cod_to_nat_y,
)


__all__ = [
    "fun_control_init",
    "design_control_init",
    "surrogate_control_init",
    "optimizer_control_init",
    "aggregate_mean_var",
    "get_ranks",
    "select_distant_points",
    "get_additional_attributes",
    "get_additional_methods",
    "remove_attributes",
    "reset_weights",
    "add_attributes",
    "get_removed_attributes_and_base_net",
    "selectNew",
    "find_equal_in_lists",
    "class_for_name",
    "get_Xy_from_df",
    "find_indices",
    "series_to_array",
    "add_logical_columns",
    "map_to_True_False",
    "sort_by_kth_and_return_indices",
    "check_type",
    "set_dataset_target_type",
    "getDevice",
    "get_stars",
    "print_exp_table",
    "print_res_table",
    "gen_design_table",
    "compare_two_tree_models",
    "generate_config_id",
    "filter_highly_correlated",
    "plot_sns_heatmap",
    "count_missing_data",
    "plot_missing_data",
    "load_cifar10_data",
    "save_pickle",
    "load_pickle",
    "get_experiment_filename",
    "get_result_filename",
    "_handle_res_filename",
    "_handle_exp_filename",
    "load_result",
    "load_experiment",
    "load_and_run_spot_python_experiment",
    "load_dict_from_file",
    "load_core_model_from_file",
    "generate_div2_list",
    "apk",
    "mapk",
    "mapk_score",
    "mapk_scorer",
    "get_metric_sign",
    "NumpyEncoder",
    "progress_bar",
    "repair_non_numeric",
    "remove_nan",
    "apply_penalty_NA",
    "TorchStandardScaler",
    "TorchMinMaxScaler",
    "set_all_seeds",
    "compute_lengths_from_fractions",
    "calculate_data_split",
    "start_tensorboard",
    "stop_tensorboard",
    "get_timestamp",
    "transform_multby2_int",
    "transform_power_2_int",
    "transform_power_10_int",
    "transform_power_2",
    "transform_power_10",
    "transform_none_to_None",
    "transform_power",
    "transform_hyper_parameter_values",
    "scale",
    "nat_to_cod_X",
    "nat_to_cod_y",
    "cod_to_nat_X",
    "cod_to_nat_y",
    "_init_prefix",
    "setup_paths",
    "create_spot_tensorboard_path",
    "X_reshape",
    "check_and_create_dir",
    "get_experiment_name",
    "get_spot_tensorboard_path",
    "get_tensorboard_path",
    "get_feature_names",
]
