# Contributing to Spring Config Client Python

Thanks for considering contributing! This project welcomes all contributions - bug fixes, features, documentation improvements, or even typo fixes.

## Important Note

**This project may appear inactive at times, but that doesn't mean contributions aren't welcome.** If you don't get a response within a week, feel free to ping the issue or PR. The maintainers might be busy, but we genuinely want your contributions.

## How to Contribute

We have issue templates for bug reports and feature requests - use those to get started.

### Making Changes

It's simple:

1. **Fork this repository**
2. **Make your changes** in your fork
3. **Open a Pull Request** back to this repo
4. **Wait for review** - someone will look at it and either merge it or ask for changes

That's it. No complex process, no bureaucracy.

### Guidelines

- Keep changes simple and focused
- Test your changes if possible
- Update documentation if you're changing behavior
- Follow the existing code style (it's pretty straightforward)

### What We're Looking For

- Bug fixes (always welcome!)
- Better error messages
- Documentation improvements
- Performance improvements
- Support for additional Spring Config Server features (if simple to implement)
- Tests (we don't have many, help us fix that!)

### What Probably Won't Get Merged

- Complex features that violate the "keep it simple" philosophy
- Features that add heavy dependencies
- Runtime configuration refresh (out of scope)
- Breaking changes without very good reason

But don't let this discourage you - if you're unsure, open an issue first to discuss!

## Questions?

Open an issue even if you're not sure it's a bug or feature request. We're happy to discuss.

## Code of Conduct

Be respectful. Don't be an asshole to contributors or users.

## License

By contributing, you agree that your contributions will be licensed under the MIT License.
