from enum import Enum


class SqlErrors(Enum):
    '''Enumeration of SQL error types with unique identifiers.'''
    SYN_1_OMITTING_CORRELATION_NAMES                                    = 1
    SYN_2_AMBIGUOUS_COLUMN                                              = 2
    SYN_3_AMBIGUOUS_FUNCTION                                            = 3
    SYN_4_UNDEFINED_COLUMN                                              = 4
    SYN_5_UNDEFINED_FUNCTION                                            = 5
    SYN_6_UNDEFINED_PARAMETER                                           = 6
    SYN_7_UNDEFINED_OBJECT                                              = 7
    SYN_8_INVALID_SCHEMA_NAME                                           = 8
    SYN_9_MISSPELLINGS                                                  = 9
    SYN_10_SYNONYMS                                                     = 10
    SYN_11_OMITTING_QUOTES_AROUND_CHARACTER_DATA                        = 11
    SYN_12_FAILURE_TO_SPECIFY_COLUMN_NAME_TWICE                         = 12
    SYN_13_DATA_TYPE_MISMATCH                                           = 13
    SYN_14_USING_AGGREGATE_FUNCTION_OUTSIDE_SELECT_OR_HAVING            = 14
    SYN_15_AGGREGATE_FUNCTIONS_CANNOT_BE_NESTED                         = 15
    SYN_16_EXTRANEOUS_OR_OMITTED_GROUPING_COLUMN                        = 16
    SYN_17_HAVING_WITHOUT_GROUP_BY                                      = 17
    SYN_18_CONFUSING_FUNCTION_WITH_FUNCTION_PARAMETER                   = 18
    SYN_19_USING_WHERE_TWICE                                            = 19
    SYN_20_OMITTING_THE_FROM_CLAUSE                                     = 20
    SYN_21_COMPARISON_WITH_NULL                                         = 21
    SYN_22_OMITTING_THE_SEMICOLON                                       = 22
    SYN_23_DATE_TIME_FIELD_OVERFLOW                                     = 23
    SYN_24_DUPLICATE_CLAUSE                                             = 24
    SYN_25_USING_AN_UNDEFINED_CORRELATION_NAME                          = 25
    SYN_26_TOO_MANY_COLUMNS_IN_SUBQUERY                                 = 26
    SYN_27_CONFUSING_TABLE_NAMES_WITH_COLUMN_NAMES                      = 27
    SYN_28_RESTRICTION_IN_SELECT_CLAUSE                                 = 28
    SYN_29_PROJECTION_IN_WHERE_CLAUSE                                   = 29
    SYN_30_CONFUSING_THE_ORDER_OF_KEYWORDS                              = 30
    SYN_31_CONFUSING_THE_LOGIC_OF_KEYWORDS                              = 31
    SYN_32_CONFUSING_THE_SYNTAX_OF_KEYWORDS                             = 32
    SYN_33_OMITTING_COMMAS                                              = 33
    SYN_34_CURLY_SQUARE_OR_UNMATCHED_BRACKETS                           = 34
    SYN_35_IS_WHERE_NOT_APPLICABLE                                      = 35
    SYN_36_NONSTANDARD_KEYWORDS_OR_STANDARD_KEYWORDS_IN_WRONG_CONTEXT   = 36
    SYN_37_NONSTANDARD_OPERATORS                                        = 37
    SYN_38_ADDITIONAL_SEMICOLON                                         = 38

    SEM_39_AND_INSTEAD_OF_OR                                            = 39
    SEM_40_TAUTOLOGICAL_OR_INCONSISTENT_EXPRESSION                      = 40
    SEM_41_DISTINCT_IN_SUM_OR_AVG                                       = 41
    SEM_42_DISTINCT_THAT_MIGHT_REMOVE_IMPORTANT_DUPLICATES              = 42
    SEM_43_WILDCARDS_WITHOUT_LIKE                                       = 43
    SEM_44_INCORRECT_WILDCARD                                           = 44
    SEM_45_MIXING_A_GREATER_THAN_0_WITH_IS_NOT_NULL                     = 45
    SEM_46_NULL_IN_IN_ANY_ALL_SUBQUERY                                  = 46
    SEM_47_JOIN_ON_INCORRECT_COLUMN                                     = 47
    SEM_48_OMITTING_A_JOIN                                              = 48
    SEM_49_MANY_DUPLICATES                                              = 49
    SEM_50_CONSTANT_COLUMN_OUTPUT                                       = 50
    SEM_51_DUPLICATE_COLUMN_OUTPUT                                      = 51

    LOG_52_OR_INSTEAD_OF_AND                                            = 52
    LOG_53_EXTRANEOUS_NOT_OPERATOR                                      = 53
    LOG_54_MISSING_NOT_OPERATOR                                         = 54
    LOG_55_SUBSTITUTING_EXISTENCE_NEGATION_WITH_NOT_EQUAL_TO            = 55
    LOG_56_PUTTING_NOT_IN_FRONT_OF_INCORRECT_IN_OR_EXISTS               = 56
    LOG_57_INCORRECT_COMPARISON_OPERATOR_OR_VALUE                       = 57
    LOG_58_JOIN_ON_INCORRECT_TABLE                                      = 58
    LOG_59_JOIN_WHEN_JOIN_NEEDS_TO_BE_OMITTED                           = 59
    LOG_60_JOIN_ON_INCORRECT_COLUMN_MATCHES_POSSIBLE                    = 60
    LOG_61_JOIN_WITH_INCORRECT_COMPARISON_OPERATOR                      = 61
    LOG_62_MISSING_JOIN                                                 = 62
    LOG_63_MPROPER_NESTING_OF_EXPRESSIONS                               = 63
    LOG_64_IMPROPER_NESTING_OF_SUBQUERIES                               = 64
    LOG_65_EXTRANEOUS_QUOTES                                            = 65
    LOG_66_MISSING_EXPRESSION                                           = 66
    LOG_67_EXPRESSION_ON_INCORRECT_COLUMN                               = 67
    LOG_68_EXTRANEOUS_EXPRESSION                                        = 68
    LOG_69_EXPRESSION_IN_INCORRECT_CLAUSE                               = 69
    LOG_70_EXTRANEOUS_COLUMN_IN_SELECT                                  = 70
    LOG_71_MISSING_COLUMN_FROM_SELECT                                   = 71
    LOG_72_MISSING_DISTINCT_FROM_SELECT                                 = 72
    LOG_73_MISSING_AS_FROM_SELECT                                       = 73
    LOG_74_MISSING_COLUMN_FROM_ORDER_BY                                 = 74
    LOG_75_INCORRECT_COLUMN_IN_ORDER_BY                                 = 75
    LOG_76_EXTRANEOUS_ORDER_BY_CLAUSE                                   = 76
    LOG_77_INCORRECT_ORDERING_OF_ROWS                                   = 77
    LOG_78_DISTINCT_AS_FUNCTION_PARAMETER_WHERE_NOT_APPLICABLE          = 78
    LOG_79_MISSING_DISTINCT_FROM_FUNCTION_PARAMETER                     = 79
    LOG_80_INCORRECT_FUNCTION                                           = 80
    LOG_81_INCORRECT_COLUMN_AS_FUNCTION_PARAMETER                       = 81

    COM_82_UNNECESSARY_COMPLICATION                                     = 82
    COM_83_UNNECESSARY_DISTINCT_IN_SELECT_CLAUSE                        = 83
    COM_84_UNNECESSARY_JOIN                                             = 84
    COM_85_UNUSED_CORRELATION_NAME                                      = 85
    COM_86_CORRELATION_NAMES_ARE_ALWAYS_IDENTICAL                       = 86
    COM_87_UNNECESSARILY_GENERAL_COMPARISON_OPERATOR                    = 87
    COM_88_LIKE_WITHOUT_WILDCARDS                                       = 88
    COM_89_UNNECESSARILY_COMPLICATED_SELECT_IN_EXISTS_SUBQUERY          = 89
    COM_90_IN_EXISTS_CAN_BE_REPLACED_BY_COMPARISON                      = 90
    COM_91_UNNECESSARY_AGGREGATE_FUNCTION                               = 91
    COM_92_UNNECESSARY_DISTINCT_IN_AGGREGATE_FUNCTION                   = 92
    COM_93_UNNECESSARY_ARGUMENT_OF_COUNT                                = 93
    COM_94_UNNECESSARY_GROUP_BY_IN_EXISTS_SUBQUERY                      = 94
    COM_95_GROUP_BY_WITH_SINGLETON_GROUPS                               = 95
    COM_96_GROUP_BY_WITH_ONLY_A_SINGLE_GROUP                            = 96
    COM_97_GROUP_BY_CAN_BE_REPLACED_WITH_DISTINCT                       = 97
    COM_98_UNION_CAN_BE_REPLACED_BY_OR                                  = 98
    COM_99_UNNECESSARY_COLUMN_IN_ORDER_BY_CLAUSE                        = 99
    COM_100_ORDER_BY_IN_SUBQUERY                                        = 100
    COM_101_INEFFICIENT_HAVING                                          = 101
    COM_102_INEFFICIENT_UNION                                           = 102
    COM_103_CONDITION_IN_SUBQUERY_CAN_BE_MOVED_UP                       = 103
    COM_104_CONDITION_ON_LEFT_TABLE_IN_LEFT_OUTER_JOIN                  = 104
    COM_105_OUTER_JOIN_CAN_BE_REPLACED_BY_INNER_JOIN                    = 105